/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.GenericJigsawStructure;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import org.joml.Vector3f;

public class StrongholdEndStructure
extends GenericJigsawStructure {
    public static final Codec<StrongholdEndStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StrongholdEndStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)Codec.INT.optionalFieldOf("min_y_allowed").forGetter(structure -> structure.minYAllowed), (App)Codec.INT.optionalFieldOf("max_y_allowed").forGetter(structure -> structure.maxYAllowed), (App)Codec.intRange((int)1, (int)1000).optionalFieldOf("allowed_y_range_from_start").forGetter(structure -> structure.allowedYRangeFromStart), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.BOOL.fieldOf("cannot_spawn_in_liquid").orElse((Object)false).forGetter(structure -> structure.cannotSpawnInLiquid), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("terrain_height_radius_check").forGetter(structure -> structure.terrainHeightCheckRadius), (App)Codec.intRange((int)1, (int)1000).optionalFieldOf("allowed_terrain_height_range").forGetter(structure -> structure.allowedTerrainHeightRange), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("valid_biome_radius_check").forGetter(structure -> structure.biomeRadius), (App)ResourceLocation.f_135803_.listOf().fieldOf("pools_that_ignore_boundaries").orElse(new ArrayList()).xmap(HashSet::new, ArrayList::new).forGetter(structure -> structure.poolsThatIgnoreBoundaries), (App)Codec.intRange((int)1, (int)128).optionalFieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)StringRepresentable.m_216439_(GenericJigsawStructure.BURYING_TYPE::values).optionalFieldOf("burying_type").forGetter(structure -> structure.buryingType), (App)Codec.BOOL.fieldOf("use_bounding_box_hack").orElse((Object)false).forGetter(structure -> structure.useBoundingBoxHack)).apply((Applicative)instance, StrongholdEndStructure::new));

    public StrongholdEndStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, int size, Optional<Integer> minYAllowed, Optional<Integer> maxYAllowed, Optional<Integer> allowedYRangeFromStart, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, boolean cannotSpawnInLiquid, Optional<Integer> terrainHeightCheckRadius, Optional<Integer> allowedTerrainHeightRange, Optional<Integer> biomeRadius, HashSet<ResourceLocation> poolsThatIgnoreBoundaries, Optional<Integer> maxDistanceFromCenter, Optional<GenericJigsawStructure.BURYING_TYPE> buryingType, boolean useBoundingBoxHack) {
        super(config, startPool, size, minYAllowed, maxYAllowed, allowedYRangeFromStart, startHeight, projectStartToHeightmap, cannotSpawnInLiquid, terrainHeightCheckRadius, allowedTerrainHeightRange, biomeRadius, poolsThatIgnoreBoundaries, maxDistanceFromCenter, buryingType, useBoundingBoxHack);
    }

    @Override
    protected boolean extraSpawningChecks(Structure.GenerationContext context, BlockPos blockPos) {
        boolean superCheck = super.extraSpawningChecks(context, blockPos);
        if (!superCheck) {
            return false;
        }
        ChunkPos chunkPos = context.f_226628_();
        int minLandHeight = Math.min(GeneralUtils.getMaxTerrainLimit(context.f_226622_()), context.f_226622_().m_142062_() + 45);
        int xPos = chunkPos.m_45604_();
        int zPos = chunkPos.m_45605_();
        int landHeight = Integer.MAX_VALUE;
        for (int i = 2; i >= 1; --i) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                Vector3f offsetPos = direction.m_253071_();
                offsetPos.mul(35.0f * (float)i);
                landHeight = StrongholdEndStructure.getHeightAt(context, xPos + (int)offsetPos.x(), zPos + (int)offsetPos.z(), landHeight);
                if (landHeight >= minLandHeight) continue;
                return false;
            }
        }
        return (landHeight = StrongholdEndStructure.getHeightAt(context, xPos, zPos, landHeight)) >= minLandHeight;
    }

    private static int getHeightAt(Structure.GenerationContext context, int xPos, int zPos, int landHeight) {
        landHeight = Math.min(landHeight, context.f_226622_().m_223235_(xPos, zPos, Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_()));
        return landHeight;
    }

    @Override
    public StructureType<?> m_213658_() {
        return RSStructures.STRONGHOLD_END.get();
    }
}

