/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.options;

import java.util.function.DoubleConsumer;
import java.util.function.LongConsumer;
import java.util.regex.Pattern;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.CommonComponents;

public class NumberInputBox
extends EditBox {
    private static final Pattern INTEGER_PATTERN = Pattern.compile("-?\\d*");
    private static final Pattern FLOAT_PATTERN = Pattern.compile("-?\\d*(.\\d*)?");

    public NumberInputBox(Font font, int x, int y, int width, int height, String value, boolean floating, LongConsumer longConsumer, DoubleConsumer doubleConsumer) {
        super(font, x, y, width, height, CommonComponents.f_237098_);
        if (floating) {
            this.m_94153_(text -> FLOAT_PATTERN.matcher((CharSequence)text).matches());
        } else {
            this.m_94153_(text -> INTEGER_PATTERN.matcher((CharSequence)text).matches());
        }
        this.m_94144_(value);
        this.m_94151_(text -> {
            if (text.isEmpty()) {
                text = "0";
            }
            if (floating) {
                try {
                    doubleConsumer.accept(Double.parseDouble(text));
                }
                catch (NumberFormatException e) {
                    doubleConsumer.accept(0.0);
                }
            } else {
                try {
                    longConsumer.accept(Long.parseLong(text));
                }
                catch (NumberFormatException e) {
                    longConsumer.accept(0L);
                }
            }
        });
    }
}

