/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.modules.crafting.network;

import java.util.function.Supplier;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolsbase.modules.crafting.items.CraftingCardItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PacketUpdateNBTItemCard {
    private TypedMap args;

    public PacketUpdateNBTItemCard() {
    }

    public PacketUpdateNBTItemCard(FriendlyByteBuf buf) {
        this.args = TypedMapTools.readArguments((FriendlyByteBuf)buf);
    }

    public PacketUpdateNBTItemCard(TypedMap arguments) {
        this.args = arguments;
    }

    protected boolean isValidItem(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof CraftingCardItem;
    }

    public void toBytes(FriendlyByteBuf buf) {
        TypedMapTools.writeArguments((FriendlyByteBuf)buf, (TypedMap)this.args);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer playerEntity = ctx.getSender();
            ItemStack heldItem = playerEntity.m_21120_(InteractionHand.MAIN_HAND);
            if (heldItem.m_41619_()) {
                return;
            }
            if (!this.isValidItem(heldItem)) {
                return;
            }
            CompoundTag tagCompound = heldItem.m_41784_();
            for (Key akey : this.args.getKeys()) {
                String key = akey.name();
                if (Type.STRING.equals(akey.type())) {
                    tagCompound.m_128359_(key, (String)this.args.get(akey));
                    continue;
                }
                if (Type.INTEGER.equals(akey.type())) {
                    tagCompound.m_128405_(key, ((Integer)this.args.get(akey)).intValue());
                    continue;
                }
                if (Type.LONG.equals(akey.type())) {
                    tagCompound.m_128356_(key, ((Long)this.args.get(akey)).longValue());
                    continue;
                }
                if (Type.DOUBLE.equals(akey.type())) {
                    tagCompound.m_128347_(key, ((Double)this.args.get(akey)).doubleValue());
                    continue;
                }
                if (Type.BOOLEAN.equals(akey.type())) {
                    tagCompound.m_128379_(key, ((Boolean)this.args.get(akey)).booleanValue());
                    continue;
                }
                if (Type.BLOCKPOS.equals(akey.type())) {
                    throw new RuntimeException("BlockPos not supported for PacketUpdateNBTItem!");
                }
                if (Type.ITEMSTACK.equals(akey.type())) {
                    throw new RuntimeException("ItemStack not supported for PacketUpdateNBTItem!");
                }
                throw new RuntimeException(akey.type().getType().getSimpleName() + " not supported for PacketUpdateNBTItem!");
            }
        });
        ctx.setPacketHandled(true);
    }
}

