/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.modularstorage.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.container.BaseSlot;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.container.GhostOutputSlot;
import mcjty.lib.container.GhostSlot;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.container.SlotFactory;
import mcjty.lib.container.SlotType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.rftoolsbase.modules.filter.items.FilterModuleItem;
import mcjty.rftoolsstorage.modules.modularstorage.ModularStorageModule;
import mcjty.rftoolsstorage.modules.modularstorage.blocks.ModularStorageTileEntity;
import mcjty.rftoolsstorage.modules.modularstorage.client.SlotOffsetCalculator;
import mcjty.rftoolsstorage.modules.modularstorage.items.StorageModuleItem;
import mcjty.rftoolsstorage.modules.modularstorage.network.PacketStorageInfoToClient;
import mcjty.rftoolsstorage.setup.RFToolsStorageMessages;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.NetworkDirection;

public class ModularStorageContainer
extends GenericContainer {
    public static final String CONTAINER_GRID = "grid";
    public static final String CONTAINER_CARDS = "cards";
    public static final int SLOT_STORAGE_MODULE = 0;
    public static final int SLOT_TYPE_MODULE = 1;
    public static final int SLOT_FILTER_MODULE = 2;
    public static final int SLOT_STORAGE = 3;
    public static final int MAXSIZE_STORAGE = 500;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(3).slot(SlotDefinition.specific(stack -> stack.m_41720_() instanceof StorageModuleItem), CONTAINER_CARDS, 0, 5, 157).slot(SlotDefinition.specific(stack -> false), CONTAINER_CARDS, 1, -18, -18).slot(SlotDefinition.specific(stack -> stack.m_41720_() instanceof FilterModuleItem), CONTAINER_CARDS, 2, 5, 175).box(SlotDefinition.generic().in(), "container", 0, -500, -500, 500, 0, 1, 0).playerSlots(91, 157).box(SlotDefinition.ghost(), CONTAINER_GRID, 1, -61, 127, 3, 3).range(SlotDefinition.ghostOut(), CONTAINER_GRID, 0, -61, 185, 1, 18));

    public ModularStorageContainer(int id, BlockPos pos, ModularStorageTileEntity tileEntity, @Nonnull Player player) {
        super((MenuType)ModularStorageModule.CONTAINER_MODULAR_STORAGE.get(), id, (ContainerFactory)CONTAINER_FACTORY.get(), pos, (GenericTileEntity)tileEntity, player);
    }

    public void setupInventories(IItemHandler itemHandler, Inventory inventory) {
        ModularStorageTileEntity modularStorageTileEntity = (ModularStorageTileEntity)this.te;
        this.addInventory(CONTAINER_CARDS, modularStorageTileEntity.getCardHandler());
        this.addInventory("container", itemHandler);
        this.addInventory("player", (IItemHandler)new InvWrapper((Container)inventory));
        this.addInventory(CONTAINER_GRID, (IItemHandler)modularStorageTileEntity.getCraftingGrid().getCraftingGridInventory());
        this.generateSlots(inventory.f_35978_);
    }

    private int getAdjustedY(int y, boolean onClient) {
        if (onClient) {
            return y + SlotOffsetCalculator.getYOffset();
        }
        return y;
    }

    private boolean isLocked() {
        return ((ModularStorageTileEntity)this.te).isLocked();
    }

    public void generateSlots(Player player) {
        boolean onClient = this.getTe().m_58904_().m_5776_();
        for (SlotFactory slotFactory : ((ContainerFactory)CONTAINER_FACTORY.get()).getSlots()) {
            Object slot;
            if (slotFactory.getSlotType() == SlotType.SLOT_GHOST) {
                slot = new GhostSlot((IItemHandler)this.inventories.get(slotFactory.inventoryName()), slotFactory.index(), slotFactory.x(), slotFactory.y()){

                    public boolean m_8010_(Player player) {
                        if (!ModularStorageContainer.this.isLocked()) {
                            return false;
                        }
                        return super.m_8010_(player);
                    }

                    public boolean m_5857_(@Nonnull ItemStack stack) {
                        if (!ModularStorageContainer.this.isLocked()) {
                            return false;
                        }
                        return super.m_5857_(stack);
                    }

                    public void m_5852_(ItemStack stack) {
                        if (!ModularStorageContainer.this.isLocked()) {
                            return;
                        }
                        super.m_5852_(stack);
                    }
                };
            } else if (slotFactory.getSlotType() == SlotType.SLOT_GHOSTOUT) {
                slot = new GhostOutputSlot((IItemHandler)this.inventories.get(slotFactory.inventoryName()), slotFactory.index(), slotFactory.x(), slotFactory.y()){

                    public boolean m_8010_(Player player) {
                        if (!ModularStorageContainer.this.isLocked()) {
                            return false;
                        }
                        return super.m_8010_(player);
                    }

                    public boolean m_5857_(@Nonnull ItemStack stack) {
                        if (!ModularStorageContainer.this.isLocked()) {
                            return false;
                        }
                        return super.m_5857_(stack);
                    }

                    public void m_5852_(@Nonnull ItemStack stack) {
                        if (!ModularStorageContainer.this.isLocked()) {
                            return;
                        }
                        super.m_5852_(stack);
                    }
                };
            } else if (slotFactory.getSlotType() == SlotType.SLOT_SPECIFICITEM) {
                final SlotDefinition slotDefinition = slotFactory.slotDefinition();
                slot = new SlotItemHandler((IItemHandler)this.inventories.get(slotFactory.inventoryName()), slotFactory.index(), slotFactory.x(), this.getAdjustedY(slotFactory.y(), onClient)){

                    public boolean m_5857_(@Nonnull ItemStack stack) {
                        if (ModularStorageContainer.this.isLocked()) {
                            return false;
                        }
                        return slotDefinition.itemStackMatches(stack);
                    }
                };
            } else {
                slot = slotFactory.getSlotType() == SlotType.SLOT_PLAYERINV || slotFactory.getSlotType() == SlotType.SLOT_PLAYERHOTBAR ? new BaseSlot((IItemHandler)this.inventories.get(slotFactory.inventoryName()), this.te, slotFactory.index(), slotFactory.x(), this.getAdjustedY(slotFactory.y(), onClient)) : new BaseSlot((IItemHandler)this.inventories.get(slotFactory.inventoryName()), this.te, slotFactory.index(), slotFactory.x(), this.getAdjustedY(slotFactory.y(), onClient)){

                    public boolean m_5857_(@Nonnull ItemStack stack) {
                        if (!ModularStorageContainer.this.isLocked()) {
                            return false;
                        }
                        return this.getItemHandler().isItemValid(((Slot)this).f_40219_ - 3, stack);
                    }
                };
            }
            this.m_38897_((Slot)slot);
        }
    }

    public void m_150399_(int index, int button, @Nonnull ClickType mode, @Nonnull Player player) {
        if (index != 0 || !player.m_20193_().f_46443_) {
            // empty if block
        }
        super.m_150399_(index, button, mode, player);
    }

    public void m_38946_() {
        super.m_38946_();
        ModularStorageTileEntity modularStorageTileEntity = (ModularStorageTileEntity)this.te;
        String sortMode = modularStorageTileEntity.getSortMode();
        String viewMode = modularStorageTileEntity.getViewMode();
        boolean groupMode = modularStorageTileEntity.isGroupMode();
        String filter = modularStorageTileEntity.getFilter();
        boolean locked = modularStorageTileEntity.isLocked();
        Player player = this.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            RFToolsStorageMessages.INSTANCE.sendTo((Object)new PacketStorageInfoToClient(modularStorageTileEntity.m_58899_(), sortMode, viewMode, groupMode, filter, locked), player2.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }
}

