/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.crafter.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.ItemStackList;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsutility.modules.crafter.CrafterModule;
import mcjty.rftoolsutility.modules.crafter.blocks.CrafterBaseTE;
import mcjty.rftoolsutility.modules.crafter.blocks.CrafterContainer;
import mcjty.rftoolsutility.modules.crafter.data.CraftingRecipe;
import mcjty.rftoolsutility.setup.RFToolsUtilityMessages;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class GuiCrafter
extends GenericGuiContainer<CrafterBaseTE, CrafterContainer> {
    private EnergyBar energyBar;
    private WidgetList recipeList;
    private Button applyButton;
    private static final ResourceLocation iconGuiElements = new ResourceLocation("rftoolsbase", "textures/gui/guielements.png");

    public GuiCrafter(CrafterBaseTE te, CrafterContainer container, Inventory inventory) {
        super((GenericTileEntity)te, (AbstractContainerMenu)container, inventory, ((BaseBlock)CrafterModule.CRAFTER1.get()).getManualEntry());
    }

    public static void register() {
        GuiCrafter.register((MenuType)((MenuType)CrafterModule.CONTAINER_CRAFTER.get()), GuiCrafter::new);
    }

    public void m_7856_() {
        this.window = new Window((Screen)this, this.tileEntity, RFToolsUtilityMessages.INSTANCE, new ResourceLocation("rftoolsutility", "gui/crafter.gui"));
        super.m_7856_();
        this.initializeFields();
        this.window.event("select", (source, params) -> this.selectRecipe());
    }

    private void initializeFields() {
        this.recipeList = (WidgetList)this.window.findChild("recipes");
        this.energyBar = (EnergyBar)this.window.findChild("energybar");
        this.applyButton = (Button)this.window.findChild("apply");
    }

    private void updateFields() {
        if (this.window == null) {
            return;
        }
        this.recipeList.selected(((CrafterBaseTE)this.tileEntity).getSelected());
        ((ImageChoiceLabel)this.window.findChild("redstone")).setCurrentChoice(((CrafterBaseTE)this.tileEntity).getRSMode().ordinal());
        this.populateList();
        this.updateEnergyBar(this.energyBar);
    }

    private void populateList() {
        this.recipeList.removeChildren();
        for (int i = 0; i < ((CrafterBaseTE)this.tileEntity).getSupportedRecipes(); ++i) {
            CraftingRecipe recipe = ((CrafterBaseTE)this.tileEntity).getRecipe(i);
            this.addRecipeLine(recipe.getResult());
        }
    }

    private void addRecipeLine(ItemStack craftingResult) {
        String readableName = Tools.getReadableName((ItemStack)craftingResult);
        int color = StyleConfig.colorTextInListNormal;
        if (craftingResult.m_41619_()) {
            readableName = "<no recipe>";
            color = -11513776;
        }
        Panel panel = (Panel)Widgets.horizontal().children(new Widget[]{new BlockRender().renderItem((Object)craftingResult).tooltips(new String[]{"Double click to edit this recipe"}), ((Label)((Label)((Label)Widgets.label((String)readableName).color(color)).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).dynamic(true)).tooltips(new String[]{"Double click to edit this recipe"})});
        this.recipeList.children(new Widget[]{panel});
    }

    private void selectRecipe() {
        int selected = this.recipeList.getSelected();
        this.setValue(RFToolsUtilityMessages.INSTANCE, CrafterBaseTE.SELECTED, selected);
    }

    private void updateButtons() {
        if (this.recipeList != null) {
            boolean selected = this.recipeList.getSelected() != -1;
            this.applyButton.enabled(selected);
        } else {
            this.applyButton.enabled(false);
        }
    }

    protected void m_7286_(@Nonnull GuiGraphics graphics, float v, int x, int y) {
        if (this.window == null) {
            return;
        }
        this.updateFields();
        this.updateButtons();
        this.drawWindow(graphics);
        this.drawGhostSlots(graphics);
    }

    private void drawGhostSlots(GuiGraphics graphics) {
        Lighting.m_84931_();
        PoseStack matrixStack = graphics.m_280168_();
        matrixStack.m_85836_();
        matrixStack.m_252880_((float)this.f_97735_, (float)this.f_97736_, 100.0f);
        ItemStackList ghostSlots = ((CrafterBaseTE)this.tileEntity).getGhostSlots();
        GlStateManager._enableDepthTest();
        GlStateManager._disableBlend();
        for (int i = 0; i < ghostSlots.size(); ++i) {
            int slotIdx;
            Slot slot;
            ItemStack stack = (ItemStack)ghostSlots.get(i);
            if (stack.m_41619_() || (slot = ((CrafterContainer)this.f_97732_).m_38853_(slotIdx = i < 26 ? i + 10 : i + 36 - 26)).m_6657_()) continue;
            RenderHelper.renderAndDecorateItem((GuiGraphics)graphics, (ItemStack)stack, (int)slot.f_40220_, (int)slot.f_40221_);
            RenderSystem.enableBlend();
            RenderSystem.disableDepthTest();
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)iconGuiElements);
            RenderHelper.drawTexturedModalRect((PoseStack)matrixStack, (int)slot.f_40220_, (int)slot.f_40221_, (int)224, (int)48, (int)16, (int)16);
            RenderSystem.enableDepthTest();
            RenderSystem.disableBlend();
        }
        matrixStack.m_85849_();
    }
}

