/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import mcjty.rftoolsbase.api.screens.FormatStyle;
import mcjty.rftoolsbase.api.screens.IModuleGuiBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class NbtSanitizerModuleGuiBuilder
implements IModuleGuiBuilder {
    private final Map<String, Set<String>> enumKeys = new HashMap<String, Set<String>>();
    private final Set<String> stringKeys = new HashSet<String>();
    private final Map<String, Integer> boundedIntegerKeys = new HashMap<String, Integer>();
    private final Set<String> integerKeys = new HashSet<String>();
    private boolean hasModeKeys = false;
    private final Set<String> booleanKeys = new HashSet<String>();
    private final Set<String> itemKeys = new HashSet<String>();
    private final Level world;
    @Nullable
    private final CompoundTag oldCompound;
    private static final Set<String> FORMAT_STRINGS = ImmutableSet.copyOf((Object[])((String[])Arrays.stream(FormatStyle.values()).map(FormatStyle::getName).toArray(String[]::new)));

    public NbtSanitizerModuleGuiBuilder(Level world, @Nullable CompoundTag oldCompound) {
        this.world = world;
        this.oldCompound = oldCompound;
    }

    public CompoundTag sanitizeNbt(CompoundTag fromClient) {
        String key;
        CompoundTag newCompound = this.oldCompound != null ? this.oldCompound.m_6426_() : new CompoundTag();
        for (Map.Entry<String, Set<String>> entry : this.enumKeys.entrySet()) {
            key = entry.getKey();
            if (!fromClient.m_128425_(key, 8)) continue;
            String value = fromClient.m_128461_(key);
            if (!entry.getValue().contains(value)) continue;
            newCompound.m_128359_(key, value);
        }
        for (String string : this.stringKeys) {
            if (!fromClient.m_128425_(string, 8)) continue;
            newCompound.m_128359_(string, fromClient.m_128461_(string));
        }
        for (Map.Entry entry : this.boundedIntegerKeys.entrySet()) {
            int value;
            key = (String)entry.getKey();
            if (!fromClient.m_128425_(key, 3) || (value = fromClient.m_128451_(key)) < 0 || value >= (Integer)entry.getValue()) continue;
            newCompound.m_128405_(key, value);
        }
        for (String string : this.integerKeys) {
            if (!fromClient.m_128425_(string, 3)) continue;
            newCompound.m_128405_(string, fromClient.m_128451_(string));
        }
        if (this.hasModeKeys && fromClient.m_128425_("showdiff", 1) && fromClient.m_128425_("showpct", 1) && fromClient.m_128425_("hidetext", 1)) {
            boolean showdiff = fromClient.m_128471_("showdiff");
            boolean bl = fromClient.m_128471_("showpct");
            boolean hidetext = fromClient.m_128471_("hidetext");
            if (!(showdiff && bl || showdiff && hidetext || bl && hidetext)) {
                newCompound.m_128379_("showdiff", showdiff);
                newCompound.m_128379_("showpct", bl);
                newCompound.m_128379_("hidetext", hidetext);
            }
        }
        for (String string : this.booleanKeys) {
            if (!fromClient.m_128425_(string, 1)) continue;
            newCompound.m_128379_(string, fromClient.m_128471_(string));
        }
        for (String string : this.itemKeys) {
            if (fromClient.m_128425_(string, 10)) {
                CompoundTag tag = new CompoundTag();
                ItemStack.m_41712_((CompoundTag)fromClient.m_128469_(string)).m_41739_(tag);
                newCompound.m_128365_(string, (Tag)tag);
                continue;
            }
            newCompound.m_128473_(string);
        }
        return newCompound;
    }

    public CompoundTag getCurrentData() {
        return this.oldCompound.m_6426_();
    }

    public Level getWorld() {
        return this.world;
    }

    public IModuleGuiBuilder choices(String tagname, String tooltip, String ... choices) {
        this.enumKeys.put(tagname, (Set<String>)ImmutableSet.copyOf((Object[])choices));
        return this;
    }

    public IModuleGuiBuilder format(String tagname) {
        this.enumKeys.put(tagname, FORMAT_STRINGS);
        return this;
    }

    public IModuleGuiBuilder text(String tagname, String ... tooltip) {
        this.stringKeys.add(tagname);
        return this;
    }

    public IModuleGuiBuilder choices(String tagname, IModuleGuiBuilder.Choice ... choices) {
        this.boundedIntegerKeys.put(tagname, choices.length);
        return this;
    }

    public IModuleGuiBuilder integer(String tagname, String ... tooltip) {
        this.integerKeys.add(tagname);
        return this;
    }

    public IModuleGuiBuilder color(String tagname, String ... tooltip) {
        this.integerKeys.add(tagname);
        return this;
    }

    public IModuleGuiBuilder mode(String componentName) {
        this.hasModeKeys = true;
        return this;
    }

    public IModuleGuiBuilder toggle(String tagname, String label, String ... tooltip) {
        this.booleanKeys.add(tagname);
        return this;
    }

    public IModuleGuiBuilder toggleNegative(String tagname, String label, String ... tooltip) {
        this.booleanKeys.add(tagname);
        return this;
    }

    public IModuleGuiBuilder ghostStack(String tagname) {
        this.itemKeys.add(tagname);
        return this;
    }

    public IModuleGuiBuilder label(String text) {
        return this;
    }

    public IModuleGuiBuilder leftLabel(String text) {
        return this;
    }

    public IModuleGuiBuilder block(String tagname) {
        return this;
    }

    public IModuleGuiBuilder nl() {
        return this;
    }
}

