/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.network;

import java.util.Map;
import java.util.function.Supplier;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.screens.data.IModuleData;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenTileEntity;
import mcjty.rftoolsutility.modules.screen.network.PacketReturnScreenData;
import mcjty.rftoolsutility.setup.RFToolsUtilityMessages;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class PacketGetScreenData {
    private final String modid;
    private final GlobalPos pos;
    private final long millis;

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130070_(this.modid);
        buf.m_130064_(this.pos.m_122646_());
        buf.m_130085_(this.pos.m_122640_().m_135782_());
        buf.writeLong(this.millis);
    }

    public PacketGetScreenData(FriendlyByteBuf buf) {
        this.modid = buf.m_130136_(Short.MAX_VALUE);
        BlockPos pos = buf.m_130135_();
        ResourceKey id = LevelTools.getId((ResourceLocation)buf.m_130281_());
        this.pos = GlobalPos.m_122643_((ResourceKey)id, (BlockPos)pos);
        this.millis = buf.readLong();
    }

    public PacketGetScreenData(String modid, GlobalPos pos, long millis) {
        this.modid = modid;
        this.pos = pos;
        this.millis = millis;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            BlockEntity patt1817$temp;
            Level world = ctx.getSender().m_20193_();
            if ((world = LevelTools.getLevel((Level)world, (ResourceKey)this.pos.m_122640_())).m_46805_(this.pos.m_122646_()) && (patt1817$temp = world.m_7702_(this.pos.m_122646_())) instanceof ScreenTileEntity) {
                ScreenTileEntity screen = (ScreenTileEntity)patt1817$temp;
                Map<Integer, IModuleData> screenData = screen.getScreenData(this.millis);
                PacketReturnScreenData msg = new PacketReturnScreenData(this.pos, screenData);
                RFToolsUtilityMessages.INSTANCE.sendTo((Object)msg, ctx.getSender().f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            }
        });
        ctx.setPacketHandled(true);
    }
}

