/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.rsinsertexportupgrade.item;

import com.refinedmods.refinedstorage.api.util.IFilter;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.validator.ItemValidator;
import com.ultramega.rsinsertexportupgrade.inventory.item.ConfiguredItemsInUpgradeItemHandler;
import com.ultramega.rsinsertexportupgrade.item.UpgradeItem;
import com.ultramega.rsinsertexportupgrade.registry.ModItems;
import com.ultramega.rsinsertexportupgrade.util.ItemUpgrade;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class UpgradeItemHandler
extends BaseItemHandler {
    public final List<IFilter> filters;

    public UpgradeItemHandler(List<IFilter> filters) {
        super(2);
        this.filters = filters;
        this.addValidator((Predicate)new ItemValidator((Item)ModItems.INSERT_UPGRADE.get())).addValidator((Predicate)new ItemValidator((Item)ModItems.EXPORT_UPGRADE.get()));
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.filters.clear();
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack filterItem = this.getStackInSlot(i);
            if (filterItem.m_41619_()) continue;
            this.handleFilterItem(filterItem);
        }
    }

    private void handleFilterItem(ItemStack upgradeItem) {
        int mode = UpgradeItem.getMode(upgradeItem);
        int[] selectedInventorySlots = UpgradeItem.getSelectedInventorySlots(upgradeItem);
        ArrayList<ItemUpgrade> foundFilters = new ArrayList<ItemUpgrade>();
        for (ItemStack stack : new ConfiguredItemsInUpgradeItemHandler(upgradeItem).getConfiguredItems()) {
            if (stack.m_41720_() == ModItems.INSERT_UPGRADE.get() || stack.m_41720_() == ModItems.EXPORT_UPGRADE.get()) {
                this.handleFilterItem(stack);
                continue;
            }
            if (stack.m_41619_()) continue;
            foundFilters.add(new ItemUpgrade(mode, selectedInventorySlots));
        }
        this.filters.addAll(foundFilters);
    }
}

