/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.rsinsertexportupgrade.screen;

import com.refinedmods.refinedstorage.container.slot.filter.FilterSlot;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.ultramega.rsinsertexportupgrade.RSInsertExportUpgrade;
import com.ultramega.rsinsertexportupgrade.container.UpgradeContainerMenu;
import com.ultramega.rsinsertexportupgrade.item.UpgradeItem;
import com.ultramega.rsinsertexportupgrade.network.UpgradeUpdateMessage;
import com.ultramega.rsinsertexportupgrade.util.UpgradeType;
import java.awt.Color;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;

public class UpgradeScreen
extends BaseScreen<UpgradeContainerMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("rsinsertexportupgrade", "textures/gui/upgrade.png");
    private static final ResourceLocation CHECKMARK = new ResourceLocation("rsinsertexportupgrade", "textures/gui/checkmark.png");
    private static final ResourceLocation XMARK = new ResourceLocation("rsinsertexportupgrade", "textures/gui/xmark.png");
    private static final Color[] slotColors = new Color[]{Color.RED, new Color(28, 134, 238), new Color(124, 252, 0), new Color(106, 61, 154), new Color(255, 127, 0), new Color(166, 124, 0), new Color(126, 192, 238), new Color(251, 154, 153), new Color(144, 238, 144), new Color(202, 178, 214), new Color(253, 191, 111), new Color(139, 139, 0), new Color(238, 230, 133), new Color(176, 48, 96), new Color(255, 131, 250), new Color(255, 20, 147), new Color(0, 0, 255), new Color(165, 42, 42)};
    private int mode;
    private final int[] selectedInventorySlots;
    private final UpgradeType type;
    private Button modeButton;

    public UpgradeScreen(UpgradeType type, UpgradeContainerMenu containerMenu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)containerMenu, 176, 163, inventory, title);
        this.type = type;
        this.mode = UpgradeItem.getMode(containerMenu.getUpgradeItem());
        this.selectedInventorySlots = UpgradeItem.getSelectedInventorySlots(containerMenu.getUpgradeItem());
    }

    public void onPostInit(int x, int y) {
        if (this.type == UpgradeType.INSERT) {
            this.modeButton = this.addButton(x + 118, y + 58, 0, 20, (Component)Component.m_237113_((String)""), true, true, btn -> {
                this.mode = this.mode == 0 ? 1 : 0;
                this.updateModeButton(x, this.mode);
                this.sendUpdate();
            });
            this.updateModeButton(x, this.mode);
        }
    }

    private void updateModeButton(int x, int mode) {
        MutableComponent text = mode == 0 ? Component.m_237115_((String)"sidebutton.refinedstorage.mode.whitelist") : Component.m_237115_((String)"sidebutton.refinedstorage.mode.blacklist");
        this.modeButton.m_93674_(this.f_96547_.m_92895_(text.getString()) + 12);
        this.modeButton.m_252865_(x + 118 - (mode == 1 ? 2 : 0));
        this.modeButton.m_93666_((Component)text);
    }

    public void tick(int x, int y) {
    }

    public void renderBackground(GuiGraphics graphics, int x, int y, int mouseX, int mouseY) {
        graphics.m_280218_(TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
        for (int i = 0; i < ((UpgradeContainerMenu)this.f_97732_).f_38839_.size(); ++i) {
            Slot slot = (Slot)((UpgradeContainerMenu)this.f_97732_).f_38839_.get(i);
            if (slot instanceof FilterSlot) {
                if (this.type == UpgradeType.INSERT) continue;
                UpgradeScreen.renderSlotHighlight(graphics, this.type, this.f_96547_, slot.f_40220_ + this.f_97735_, slot.f_40221_ + this.f_97736_, true, i - 36 + 1);
                continue;
            }
            if (this.selectedInventorySlots[i] >= 1) {
                UpgradeScreen.renderSlotHighlight(graphics, this.type, this.f_96547_, slot.f_40220_ + this.f_97735_, slot.f_40221_ + this.f_97736_, true, this.selectedInventorySlots[i]);
                continue;
            }
            if (this.selectedInventorySlots[i] != 0) continue;
            UpgradeScreen.renderSlotHighlight(graphics, this.type, this.f_96547_, slot.f_40220_ + this.f_97735_, slot.f_40221_ + this.f_97736_, false, -1);
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    protected void m_6597_(Slot slot, int slotId, int mouseButton, ClickType type) {
        super.m_6597_(slot, slotId, mouseButton, type);
        if (!(slot instanceof FilterSlot) && slotId >= 0 && type != ClickType.PICKUP_ALL) {
            if (this.type == UpgradeType.INSERT) {
                this.selectedInventorySlots[slotId] = this.selectedInventorySlots[slotId] == 0 ? 1 : 0;
            } else if (mouseButton == 0) {
                if (this.selectedInventorySlots[slotId] >= slotColors.length) {
                    this.selectedInventorySlots[slotId] = 0;
                } else {
                    int n = slotId;
                    this.selectedInventorySlots[n] = this.selectedInventorySlots[n] + 1;
                }
            } else {
                this.selectedInventorySlots[slotId] = 0;
            }
            this.sendUpdate();
        }
    }

    public static void renderSlotHighlight(GuiGraphics graphics, UpgradeType type, Font font, int x, int y, boolean checked, int filterIndex) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 300.0f);
        if (checked) {
            if (type == UpgradeType.INSERT) {
                graphics.m_280163_(CHECKMARK, x + 7, y, 0.0f, 0.0f, 9, 8, 9, 8);
            } else {
                graphics.m_280488_(font, String.valueOf(filterIndex), x + 16 - font.m_92895_(String.valueOf(filterIndex)), y, Color.GREEN.hashCode());
            }
        } else {
            graphics.m_280163_(XMARK, x + 9, y, 0.0f, 0.0f, 7, 7, 7, 7);
        }
        graphics.m_280168_().m_85849_();
    }

    public void renderForeground(GuiGraphics graphics, int mouseX, int mouseY) {
        this.renderString(graphics, 7, 7, this.f_96539_.getString());
        this.renderString(graphics, 7, 69, I18n.m_118938_((String)"container.inventory", (Object[])new Object[0]));
    }

    public void sendUpdate() {
        RSInsertExportUpgrade.NETWORK_HANDLER.sendToServer(new UpgradeUpdateMessage(this.type.getId(), this.mode, this.selectedInventorySlots, ((UpgradeContainerMenu)this.m_6262_()).selectedSideButton));
    }
}

