/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client.model;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shetiphian.core.ShetiPhianCore;
import shetiphian.core.common.Function;

@OnlyIn(value=Dist.CLIENT)
public class PackTextureOverrideHandler
implements ResourceManagerReloadListener {
    private static final PackTextureOverrideHandler INSTANCE = new PackTextureOverrideHandler();
    public static Gson GSON = new GsonBuilder().create();
    private static final Map<Item, ResourceLocation> OVERRIDES = new HashMap<Item, ResourceLocation>();

    public static boolean contains(ItemStack stack) {
        return OVERRIDES.containsKey(stack.m_41720_());
    }

    public static ResourceLocation get(ItemStack stack) {
        return OVERRIDES.getOrDefault(stack.m_41720_(), MissingTextureAtlasSprite.m_118071_());
    }

    public static void init() {
        ResourceManager manager = Minecraft.m_91087_().m_91098_();
        if (manager instanceof ReloadableResourceManager) {
            ((ReloadableResourceManager)manager).m_7217_((PreparableReloadListener)INSTANCE);
        }
        INSTANCE.load();
    }

    public void m_6213_(ResourceManager resourceManager) {
        OVERRIDES.clear();
        this.load();
    }

    private void load() {
        ResourceLocation loc = new ResourceLocation("shetiphian:texture_remap.json");
        List resources = Minecraft.m_91087_().m_91098_().m_213829_(loc);
        Type token = new TypeToken<Map<String, String>>(){}.getType();
        for (Resource resource : resources) {
            Map map;
            try (BufferedReader reader = resource.m_215508_();){
                map = (Map)GSON.fromJson((Reader)reader, token);
            }
            catch (Exception e) {
                ShetiPhianCore.LOGGER.error(String.format("Error loading texture_remap.json form %s\n\t%s", resource.m_215506_(), e.getLocalizedMessage()));
                break;
            }
            map.forEach((key, value) -> {
                try {
                    ResourceLocation location = new ResourceLocation(key);
                    ItemStack stack = Function.findItemStack(1, location);
                    if (stack.m_41619_()) {
                        throw new Exception(String.format("No registry entry for [%s] found", key));
                    }
                    location = new ResourceLocation(value);
                    OVERRIDES.put(stack.m_41720_(), location);
                }
                catch (Exception e) {
                    ShetiPhianCore.LOGGER.error(String.format("Ignoring invalid texture_remap entry ['%s':'%s'] form %s\n\t%s", key, value, resource.m_215506_(), e.getLocalizedMessage()));
                }
            });
        }
    }
}

