/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.showcaseitem;

import com.mojang.blaze3d.platform.InputConstants;
import com.ultramega.showcaseitem.ModKeyBindings;
import com.ultramega.showcaseitem.config.ShowcaseItemConfig;
import com.ultramega.showcaseitem.message.ShareItemMessage;
import com.ultramega.showcaseitem.message.ShowcaseItemNetwork;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="showcaseitem", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ShowcaseItemFeature {
    public static float alphaValue = 1.0f;
    private static long lastShadeTimestamp = -1L;

    @OnlyIn(value=Dist.CLIENT)
    public static void renderItemForMessage(GuiGraphics guiGraphics, FormattedCharSequence sequence, float x, float y, int color) {
        if (!((Boolean)ShowcaseItemConfig.RENDER_ITEMS_IN_CHAT.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        StringBuilder before = new StringBuilder();
        sequence.m_13731_((counter_, style, character) -> {
            String sofar = before.toString();
            if (sofar.endsWith("    ")) {
                ShowcaseItemFeature.render(mc, guiGraphics, sofar.substring(0, sofar.length() - 3), x, y, style, color);
                return false;
            }
            before.append((char)character);
            return true;
        });
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void keyboardEvent(ScreenEvent.KeyPressed.Pre event) {
        Minecraft mc = Minecraft.m_91087_();
        if (InputConstants.m_84830_((long)mc.m_91268_().m_85439_(), (int)ModKeyBindings.SHOWCASE_ITEM.getKey().m_84873_()) && ShowcaseItemFeature.keyModifierPressed(mc)) {
            ShowcaseItemFeature.keyPressed();
        }
    }

    public static void keyPressed() {
        Minecraft mc = Minecraft.m_91087_();
        Screen screen = mc.f_91080_;
        if (screen instanceof AbstractContainerScreen) {
            ItemStack stack;
            AbstractContainerScreen gui = (AbstractContainerScreen)screen;
            List children = gui.m_6702_();
            for (GuiEventListener c : children) {
                EditBox tf;
                if (!(c instanceof EditBox) || !(tf = (EditBox)c).m_93696_()) continue;
                return;
            }
            Slot slot = gui.getSlotUnderMouse();
            if (slot != null && !(stack = slot.m_7993_()).m_41619_()) {
                if (mc.f_91073_ == null || mc.f_91073_.m_46467_() - lastShadeTimestamp <= 10L) {
                    return;
                }
                lastShadeTimestamp = mc.f_91073_.m_46467_();
                ShareItemMessage message = new ShareItemMessage(slot.f_40219_, gui.m_6262_().f_38840_);
                ShowcaseItemNetwork.sendToServer(message);
            }
        }
    }

    public static void shareItem(ServerPlayer player, int slot, int containedId) {
        if (player.f_36096_.f_38840_ == containedId) {
            ItemStack stack;
            NonNullList slots = player.f_36096_.f_38839_;
            if (slot >= 0 && slots.size() > slot && !(stack = ((Slot)slots.get(slot)).m_7993_()).m_41619_()) {
                MutableComponent comp = Component.m_237110_((String)"showcaseitem.misc.shared_item", (Object[])new Object[]{player.m_7755_()});
                Component itemComp = stack.m_41611_();
                comp.m_7220_(itemComp);
                player.f_8924_.m_6846_().m_11314_().forEach(p -> p.m_213846_((Component)comp));
            }
        }
    }

    public static MutableComponent createStackComponent(ItemStack stack, MutableComponent component) {
        if (!((Boolean)ShowcaseItemConfig.RENDER_ITEMS_IN_CHAT.get()).booleanValue()) {
            return component;
        }
        Style style = component.m_7383_();
        if (stack.m_41613_() > 64) {
            ItemStack copyStack = stack.m_41777_();
            copyStack.m_41764_(64);
            style = style.m_131144_(new HoverEvent(HoverEvent.Action.f_130832_, (Object)new HoverEvent.ItemStackInfo(copyStack)));
            component.m_130948_(style);
        }
        MutableComponent out = Component.m_237113_((String)"   ");
        out.m_6270_(style);
        return out.m_7220_((Component)component);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void render(Minecraft mc, GuiGraphics guiGraphics, String before, float x, float y, Style style, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        HoverEvent hoverEvent = style.m_131186_();
        if (hoverEvent != null && hoverEvent.m_130820_() == HoverEvent.Action.f_130832_) {
            ItemStack stack;
            HoverEvent.ItemStackInfo contents = (HoverEvent.ItemStackInfo)hoverEvent.m_130823_(HoverEvent.Action.f_130832_);
            ItemStack itemStack = stack = contents != null ? contents.m_130898_() : ItemStack.f_41583_;
            if (stack.m_41619_()) {
                stack = new ItemStack((ItemLike)Blocks.f_50375_);
            }
            int shift = mc.f_91062_.m_92895_(before);
            if (a > 0.0f) {
                alphaValue = a;
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_252931_(guiGraphics.m_280168_().m_85850_().m_252922_());
                guiGraphics.m_280168_().m_252880_((float)shift + x - 3.0f, y, 0.0f);
                guiGraphics.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
                guiGraphics.m_280203_(stack, 0, 0);
                guiGraphics.m_280168_().m_85849_();
                alphaValue = 1.0f;
            }
        }
    }

    private static boolean keyModifierPressed(Minecraft mc) {
        int keyModifierInt = ShowcaseItemFeature.checkLeftKeyModifier();
        int keyModifierInt2 = ShowcaseItemFeature.checkRightKeyModifier();
        if (keyModifierInt != -1) {
            return InputConstants.m_84830_((long)mc.m_91268_().m_85439_(), (int)keyModifierInt);
        }
        if (keyModifierInt2 != -1) {
            return InputConstants.m_84830_((long)mc.m_91268_().m_85439_(), (int)keyModifierInt2);
        }
        return true;
    }

    private static int checkLeftKeyModifier() {
        KeyModifier keyModifier = ModKeyBindings.SHOWCASE_ITEM.getKeyModifier();
        int keyModifierInt = -1;
        if (keyModifier.equals((Object)KeyModifier.CONTROL)) {
            keyModifierInt = 341;
        } else if (keyModifier.equals((Object)KeyModifier.ALT)) {
            keyModifierInt = 342;
        } else if (keyModifier.equals((Object)KeyModifier.SHIFT)) {
            keyModifierInt = 340;
        }
        return keyModifierInt;
    }

    private static int checkRightKeyModifier() {
        KeyModifier keyModifier = ModKeyBindings.SHOWCASE_ITEM.getKeyModifier();
        int keyModifierInt = -1;
        if (keyModifier.equals((Object)KeyModifier.CONTROL)) {
            keyModifierInt = 345;
        } else if (keyModifier.equals((Object)KeyModifier.ALT)) {
            keyModifierInt = 346;
        } else if (keyModifier.equals((Object)KeyModifier.SHIFT)) {
            keyModifierInt = 344;
        }
        return keyModifierInt;
    }
}

