/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.item;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;

public interface ICoreTool
extends ICoreItem {
    public static final Set<ItemStat> RELEVANT_STATS = ImmutableSet.of((Object)ItemStats.DURABILITY, (Object)ItemStats.REPAIR_EFFICIENCY, (Object)ItemStats.ENCHANTMENT_VALUE, (Object)ItemStats.HARVEST_LEVEL, (Object)ItemStats.HARVEST_SPEED, (Object)ItemStats.MELEE_DAMAGE, (Object[])new ItemStat[]{ItemStats.ATTACK_SPEED});
    public static final Set<ItemStat> EXCLUDED_STATS = ImmutableSet.of((Object)ItemStats.ARMOR_DURABILITY, (Object)ItemStats.REPAIR_VALUE, (Object)ItemStats.RANGED_DAMAGE, (Object)ItemStats.RANGED_SPEED, (Object)ItemStats.PROJECTILE_ACCURACY, (Object)ItemStats.PROJECTILE_SPEED, (Object[])new ItemStat[]{ItemStats.ARMOR, ItemStats.ARMOR_TOUGHNESS, ItemStats.MAGIC_ARMOR, ItemStats.KNOCKBACK_RESISTANCE});

    @Override
    default public Set<ItemStat> getRelevantStats(@Nonnull ItemStack stack) {
        return RELEVANT_STATS;
    }

    @Override
    default public Set<ItemStat> getExcludedStats(ItemStack stack) {
        return EXCLUDED_STATS;
    }

    @Override
    default public boolean isValidSlot(String slot) {
        return EquipmentSlot.MAINHAND.m_20751_().equalsIgnoreCase(slot) || EquipmentSlot.OFFHAND.m_20751_().equalsIgnoreCase(slot);
    }

    @Override
    default public Collection<PartType> getRequiredParts() {
        return ImmutableList.of((Object)PartType.MAIN, (Object)PartType.ROD);
    }

    default public int getDamageOnBlockBreak(ItemStack gear, Level world, BlockState state, BlockPos pos) {
        return !state.m_204336_(BlockTags.f_13035_) && state.m_60800_((BlockGetter)world, pos) > 0.0f ? 1 : 0;
    }

    default public int getDamageOnHitEntity(ItemStack gear, LivingEntity target, LivingEntity attacker) {
        return 2;
    }

    @Override
    default public boolean hasTexturesFor(PartType partType) {
        return partType != PartType.CORD && partType != PartType.FLETCHING && partType != PartType.ADORNMENT && partType != PartType.LINING;
    }
}

