/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.PartData;

interface IGearRecipe {
    public ICoreItem getOutputItem();

    default public Collection<PartData> getParts(Container inv) {
        ArrayList<MaterialInstance> materials = new ArrayList<MaterialInstance>();
        IMaterial first = null;
        ArrayList<PartData> parts = new ArrayList<PartData>();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            MaterialInstance mat = MaterialInstance.from(stack);
            if (mat != null) {
                if (first == null) {
                    first = mat.get();
                } else if (!((Boolean)Config.Common.allowLegacyMaterialMixing.get()).booleanValue() && first != mat.get()) {
                    return Collections.emptyList();
                }
                materials.add(mat);
                continue;
            }
            PartData part2 = PartData.from(stack);
            if (part2 == null) continue;
            parts.add(part2);
        }
        if (!materials.isEmpty()) {
            IGearRecipe.createToolHead(this.getOutputItem().getGearType(), materials).ifPresent(part -> parts.add(0, (PartData)part));
        }
        return parts;
    }

    public static Optional<PartData> createToolHead(GearType gearType, List<? extends IMaterialInstance> materials) {
        return IGearRecipe.createCompoundPart(gearType, PartType.MAIN, materials);
    }

    public static Optional<PartData> createCompoundPart(GearType gearType, PartType partType, List<? extends IMaterialInstance> materials) {
        return partType.getCompoundPartItem(gearType).map(item -> {
            ItemStack stack = item.create(materials);
            return PartData.from(stack);
        });
    }
}

