/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.setup;

import java.util.Collection;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.item.BlueprintPackageItem;
import net.silentchaos512.gear.item.CompoundMaterialItem;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.item.CraftedMaterialItem;
import net.silentchaos512.gear.item.CraftingItems;
import net.silentchaos512.gear.item.CustomMaterialItem;
import net.silentchaos512.gear.item.FragmentItem;
import net.silentchaos512.gear.item.GuideBookItem;
import net.silentchaos512.gear.item.JewelerKitItem;
import net.silentchaos512.gear.item.MainPartItem;
import net.silentchaos512.gear.item.ModKitItem;
import net.silentchaos512.gear.item.RepairKitItem;
import net.silentchaos512.gear.item.SeedItem;
import net.silentchaos512.gear.item.SlingshotAmmoItem;
import net.silentchaos512.gear.item.blueprint.GearBlueprintItem;
import net.silentchaos512.gear.item.blueprint.PartBlueprintItem;
import net.silentchaos512.gear.item.blueprint.book.BlueprintBookItem;
import net.silentchaos512.gear.item.gear.GearArmorItem;
import net.silentchaos512.gear.item.gear.GearArrowItem;
import net.silentchaos512.gear.item.gear.GearAxeItem;
import net.silentchaos512.gear.item.gear.GearBowItem;
import net.silentchaos512.gear.item.gear.GearCrossbowItem;
import net.silentchaos512.gear.item.gear.GearCurioItem;
import net.silentchaos512.gear.item.gear.GearDaggerItem;
import net.silentchaos512.gear.item.gear.GearElytraItem;
import net.silentchaos512.gear.item.gear.GearExcavatorItem;
import net.silentchaos512.gear.item.gear.GearFishingRodItem;
import net.silentchaos512.gear.item.gear.GearHammerItem;
import net.silentchaos512.gear.item.gear.GearHoeItem;
import net.silentchaos512.gear.item.gear.GearMacheteItem;
import net.silentchaos512.gear.item.gear.GearMattockItem;
import net.silentchaos512.gear.item.gear.GearPaxelItem;
import net.silentchaos512.gear.item.gear.GearPickaxeItem;
import net.silentchaos512.gear.item.gear.GearProspectorHammerItem;
import net.silentchaos512.gear.item.gear.GearSawItem;
import net.silentchaos512.gear.item.gear.GearShearsItem;
import net.silentchaos512.gear.item.gear.GearShieldItem;
import net.silentchaos512.gear.item.gear.GearShovelItem;
import net.silentchaos512.gear.item.gear.GearSickleItem;
import net.silentchaos512.gear.item.gear.GearSlingshotItem;
import net.silentchaos512.gear.item.gear.GearSwordItem;
import net.silentchaos512.gear.item.gear.GearTridentItem;
import net.silentchaos512.gear.setup.SgBlocks;
import net.silentchaos512.lib.registry.ItemRegistryObject;
import net.silentchaos512.lib.util.TimeUtils;

public final class SgItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"silentgear");
    public static final ItemRegistryObject<GuideBookItem> GUIDE_BOOK = SgItems.register("guide_book", () -> new GuideBookItem(SgItems.unstackableProps()));
    public static final ItemRegistryObject<BlueprintPackageItem> BLUEPRINT_PACKAGE = SgItems.register("blueprint_package", () -> new BlueprintPackageItem(SilentGear.getId("starter_blueprints")));
    public static final ItemRegistryObject<Item> MOD_KIT = SgItems.register("mod_kit", () -> new ModKitItem(SgItems.unstackableProps().m_41497_(Rarity.UNCOMMON)));
    public static final ItemRegistryObject<Item> VERY_CRUDE_REPAIR_KIT = SgItems.register("very_crude_repair_kit", () -> new RepairKitItem(() -> ((ForgeConfigSpec.IntValue)Config.Common.repairKitVeryCrudeCapacity).get(), () -> ((ForgeConfigSpec.DoubleValue)Config.Common.repairKitVeryCrudeEfficiency).get(), SgItems.unstackableProps().m_41497_(Rarity.COMMON)));
    public static final ItemRegistryObject<Item> CRUDE_REPAIR_KIT = SgItems.register("crude_repair_kit", () -> new RepairKitItem(() -> ((ForgeConfigSpec.IntValue)Config.Common.repairKitCrudeCapacity).get(), () -> ((ForgeConfigSpec.DoubleValue)Config.Common.repairKitCrudeEfficiency).get(), SgItems.unstackableProps().m_41497_(Rarity.COMMON)));
    public static final ItemRegistryObject<Item> STURDY_REPAIR_KIT = SgItems.register("sturdy_repair_kit", () -> new RepairKitItem(() -> ((ForgeConfigSpec.IntValue)Config.Common.repairKitSturdyCapacity).get(), () -> ((ForgeConfigSpec.DoubleValue)Config.Common.repairKitSturdyEfficiency).get(), SgItems.unstackableProps().m_41497_(Rarity.UNCOMMON)));
    public static final ItemRegistryObject<Item> CRIMSON_REPAIR_KIT = SgItems.register("crimson_repair_kit", () -> new RepairKitItem(() -> ((ForgeConfigSpec.IntValue)Config.Common.repairKitCrimsonCapacity).get(), () -> ((ForgeConfigSpec.DoubleValue)Config.Common.repairKitCrimsonEfficiency).get(), SgItems.unstackableProps().m_41497_(Rarity.RARE)));
    public static final ItemRegistryObject<Item> AZURE_REPAIR_KIT = SgItems.register("azure_repair_kit", () -> new RepairKitItem(() -> ((ForgeConfigSpec.IntValue)Config.Common.repairKitAzureCapacity).get(), () -> ((ForgeConfigSpec.DoubleValue)Config.Common.repairKitAzureEfficiency).get(), SgItems.unstackableProps().m_41497_(Rarity.EPIC)));
    public static final ItemRegistryObject<Item> COATING_SMITHING_TEMPLATE = SgItems.register("coating_smithing_template", () -> new Item(SgItems.baseProps()));
    public static final ItemRegistryObject<BlueprintBookItem> BLUEPRINT_BOOK = SgItems.register("blueprint_book", () -> new BlueprintBookItem(SgItems.unstackableProps().m_41497_(Rarity.UNCOMMON)));
    public static final ItemRegistryObject<PartBlueprintItem> JEWELER_TOOLS = SgItems.register("jeweler_tools", () -> new JewelerKitItem(PartType.ADORNMENT, false, SgItems.unstackableProps()));
    public static final ItemRegistryObject<PartBlueprintItem> ROD_BLUEPRINT = SgItems.registerPartBlueprint(PartType.ROD, false);
    public static final ItemRegistryObject<PartBlueprintItem> TIP_BLUEPRINT = SgItems.registerPartBlueprint(PartType.TIP, false);
    public static final ItemRegistryObject<PartBlueprintItem> COATING_BLUEPRINT = SgItems.registerPartBlueprint(PartType.COATING, false);
    public static final ItemRegistryObject<PartBlueprintItem> GRIP_BLUEPRINT = SgItems.registerPartBlueprint(PartType.GRIP, false);
    public static final ItemRegistryObject<PartBlueprintItem> BINDING_BLUEPRINT = SgItems.registerPartBlueprint(PartType.BINDING, false);
    public static final ItemRegistryObject<PartBlueprintItem> LINING_BLUEPRINT = SgItems.registerPartBlueprint(PartType.LINING, false);
    public static final ItemRegistryObject<PartBlueprintItem> CORD_BLUEPRINT = SgItems.registerPartBlueprint(PartType.CORD, false);
    public static final ItemRegistryObject<PartBlueprintItem> FLETCHING_BLUEPRINT = SgItems.registerPartBlueprint(PartType.FLETCHING, false);
    public static final ItemRegistryObject<GearBlueprintItem> SWORD_BLUEPRINT = SgItems.registerGearBlueprint(GearType.SWORD, false);
    public static final ItemRegistryObject<GearBlueprintItem> KATANA_BLUEPRINT = SgItems.registerGearBlueprint(GearType.KATANA, false);
    public static final ItemRegistryObject<GearBlueprintItem> MACHETE_BLUEPRINT = SgItems.registerGearBlueprint(GearType.MACHETE, false);
    public static final ItemRegistryObject<GearBlueprintItem> SPEAR_BLUEPRINT = SgItems.registerGearBlueprint(GearType.SPEAR, false);
    public static final ItemRegistryObject<GearBlueprintItem> TRIDENT_BLUEPRINT = SgItems.registerGearBlueprint(GearType.TRIDENT, false);
    public static final ItemRegistryObject<GearBlueprintItem> KNIFE_BLUEPRINT = SgItems.registerGearBlueprint(GearType.KNIFE, false);
    public static final ItemRegistryObject<GearBlueprintItem> DAGGER_BLUEPRINT = SgItems.registerGearBlueprint(GearType.DAGGER, false);
    public static final ItemRegistryObject<GearBlueprintItem> PICKAXE_BLUEPRINT = SgItems.registerGearBlueprint(GearType.PICKAXE, false);
    public static final ItemRegistryObject<GearBlueprintItem> SHOVEL_BLUEPRINT = SgItems.registerGearBlueprint(GearType.SHOVEL, false);
    public static final ItemRegistryObject<GearBlueprintItem> AXE_BLUEPRINT = SgItems.registerGearBlueprint(GearType.AXE, false);
    public static final ItemRegistryObject<GearBlueprintItem> PAXEL_BLUEPRINT = SgItems.registerGearBlueprint(GearType.PAXEL, false);
    public static final ItemRegistryObject<GearBlueprintItem> HAMMER_BLUEPRINT = SgItems.registerGearBlueprint(GearType.HAMMER, false);
    public static final ItemRegistryObject<GearBlueprintItem> EXCAVATOR_BLUEPRINT = SgItems.registerGearBlueprint(GearType.EXCAVATOR, false);
    public static final ItemRegistryObject<GearBlueprintItem> SAW_BLUEPRINT = SgItems.registerGearBlueprint(GearType.SAW, false);
    public static final ItemRegistryObject<GearBlueprintItem> HOE_BLUEPRINT = SgItems.registerGearBlueprint(GearType.HOE, false);
    public static final ItemRegistryObject<GearBlueprintItem> MATTOCK_BLUEPRINT = SgItems.registerGearBlueprint(GearType.MATTOCK, false);
    public static final ItemRegistryObject<GearBlueprintItem> PROSPECTOR_HAMMER_BLUEPRINT = SgItems.registerGearBlueprint(GearType.PROSPECTOR_HAMMER, false);
    public static final ItemRegistryObject<GearBlueprintItem> SICKLE_BLUEPRINT = SgItems.registerGearBlueprint(GearType.SICKLE, false);
    public static final ItemRegistryObject<GearBlueprintItem> SHEARS_BLUEPRINT = SgItems.registerGearBlueprint(GearType.SHEARS, false);
    public static final ItemRegistryObject<GearBlueprintItem> FISHING_ROD_BLUEPRINT = SgItems.registerGearBlueprint(GearType.FISHING_ROD, false);
    public static final ItemRegistryObject<GearBlueprintItem> BOW_BLUEPRINT = SgItems.registerGearBlueprint(GearType.BOW, false);
    public static final ItemRegistryObject<GearBlueprintItem> CROSSBOW_BLUEPRINT = SgItems.registerGearBlueprint(GearType.CROSSBOW, false);
    public static final ItemRegistryObject<GearBlueprintItem> SLINGSHOT_BLUEPRINT = SgItems.registerGearBlueprint(GearType.SLINGSHOT, false);
    public static final ItemRegistryObject<GearBlueprintItem> SHIELD_BLUEPRINT = SgItems.registerGearBlueprint(GearType.SHIELD, false);
    public static final ItemRegistryObject<GearBlueprintItem> HELMET_BLUEPRINT = SgItems.registerGearBlueprint(GearType.HELMET, false);
    public static final ItemRegistryObject<GearBlueprintItem> CHESTPLATE_BLUEPRINT = SgItems.registerGearBlueprint(GearType.CHESTPLATE, false);
    public static final ItemRegistryObject<GearBlueprintItem> LEGGINGS_BLUEPRINT = SgItems.registerGearBlueprint(GearType.LEGGINGS, false);
    public static final ItemRegistryObject<GearBlueprintItem> BOOTS_BLUEPRINT = SgItems.registerGearBlueprint(GearType.BOOTS, false);
    public static final ItemRegistryObject<GearBlueprintItem> ELYTRA_BLUEPRINT = SgItems.registerGearBlueprint(GearType.ELYTRA, false);
    public static final ItemRegistryObject<GearBlueprintItem> ARROW_BLUEPRINT = SgItems.registerGearBlueprint(GearType.ARROW, false);
    public static final ItemRegistryObject<GearBlueprintItem> RING_BLUEPRINT = SgItems.registerGearBlueprint(GearType.RING, false);
    public static final ItemRegistryObject<GearBlueprintItem> BRACELET_BLUEPRINT = SgItems.registerGearBlueprint(GearType.BRACELET, false);
    public static final ItemRegistryObject<PartBlueprintItem> ROD_TEMPLATE = SgItems.registerPartBlueprint(PartType.ROD, true);
    public static final ItemRegistryObject<PartBlueprintItem> TIP_TEMPLATE = SgItems.registerPartBlueprint(PartType.TIP, true);
    public static final ItemRegistryObject<PartBlueprintItem> COATING_TEMPLATE = SgItems.registerPartBlueprint(PartType.COATING, true);
    public static final ItemRegistryObject<PartBlueprintItem> GRIP_TEMPLATE = SgItems.registerPartBlueprint(PartType.GRIP, true);
    public static final ItemRegistryObject<PartBlueprintItem> BINDING_TEMPLATE = SgItems.registerPartBlueprint(PartType.BINDING, true);
    public static final ItemRegistryObject<PartBlueprintItem> LINING_TEMPLATE = SgItems.registerPartBlueprint(PartType.LINING, true);
    public static final ItemRegistryObject<PartBlueprintItem> CORD_TEMPLATE = SgItems.registerPartBlueprint(PartType.CORD, true);
    public static final ItemRegistryObject<PartBlueprintItem> FLETCHING_TEMPLATE = SgItems.registerPartBlueprint(PartType.FLETCHING, true);
    public static final ItemRegistryObject<GearBlueprintItem> SWORD_TEMPLATE = SgItems.registerGearBlueprint(GearType.SWORD, true);
    public static final ItemRegistryObject<GearBlueprintItem> KATANA_TEMPLATE = SgItems.registerGearBlueprint(GearType.KATANA, true);
    public static final ItemRegistryObject<GearBlueprintItem> MACHETE_TEMPLATE = SgItems.registerGearBlueprint(GearType.MACHETE, true);
    public static final ItemRegistryObject<GearBlueprintItem> SPEAR_TEMPLATE = SgItems.registerGearBlueprint(GearType.SPEAR, true);
    public static final ItemRegistryObject<GearBlueprintItem> TRIDENT_TEMPLATE = SgItems.registerGearBlueprint(GearType.TRIDENT, true);
    public static final ItemRegistryObject<GearBlueprintItem> KNIFE_TEMPLATE = SgItems.registerGearBlueprint(GearType.KNIFE, true);
    public static final ItemRegistryObject<GearBlueprintItem> DAGGER_TEMPLATE = SgItems.registerGearBlueprint(GearType.DAGGER, true);
    public static final ItemRegistryObject<GearBlueprintItem> PICKAXE_TEMPLATE = SgItems.registerGearBlueprint(GearType.PICKAXE, true);
    public static final ItemRegistryObject<GearBlueprintItem> SHOVEL_TEMPLATE = SgItems.registerGearBlueprint(GearType.SHOVEL, true);
    public static final ItemRegistryObject<GearBlueprintItem> AXE_TEMPLATE = SgItems.registerGearBlueprint(GearType.AXE, true);
    public static final ItemRegistryObject<GearBlueprintItem> PAXEL_TEMPLATE = SgItems.registerGearBlueprint(GearType.PAXEL, true);
    public static final ItemRegistryObject<GearBlueprintItem> HAMMER_TEMPLATE = SgItems.registerGearBlueprint(GearType.HAMMER, true);
    public static final ItemRegistryObject<GearBlueprintItem> EXCAVATOR_TEMPLATE = SgItems.registerGearBlueprint(GearType.EXCAVATOR, true);
    public static final ItemRegistryObject<GearBlueprintItem> SAW_TEMPLATE = SgItems.registerGearBlueprint(GearType.SAW, true);
    public static final ItemRegistryObject<GearBlueprintItem> HOE_TEMPLATE = SgItems.registerGearBlueprint(GearType.HOE, true);
    public static final ItemRegistryObject<GearBlueprintItem> MATTOCK_TEMPLATE = SgItems.registerGearBlueprint(GearType.MATTOCK, true);
    public static final ItemRegistryObject<GearBlueprintItem> PROSPECTOR_HAMMER_TEMPLATE = SgItems.registerGearBlueprint(GearType.PROSPECTOR_HAMMER, true);
    public static final ItemRegistryObject<GearBlueprintItem> SICKLE_TEMPLATE = SgItems.registerGearBlueprint(GearType.SICKLE, true);
    public static final ItemRegistryObject<GearBlueprintItem> SHEARS_TEMPLATE = SgItems.registerGearBlueprint(GearType.SHEARS, true);
    public static final ItemRegistryObject<GearBlueprintItem> FISHING_ROD_TEMPLATE = SgItems.registerGearBlueprint(GearType.FISHING_ROD, true);
    public static final ItemRegistryObject<GearBlueprintItem> BOW_TEMPLATE = SgItems.registerGearBlueprint(GearType.BOW, true);
    public static final ItemRegistryObject<GearBlueprintItem> CROSSBOW_TEMPLATE = SgItems.registerGearBlueprint(GearType.CROSSBOW, true);
    public static final ItemRegistryObject<GearBlueprintItem> SLINGSHOT_TEMPLATE = SgItems.registerGearBlueprint(GearType.SLINGSHOT, true);
    public static final ItemRegistryObject<GearBlueprintItem> SHIELD_TEMPLATE = SgItems.registerGearBlueprint(GearType.SHIELD, true);
    public static final ItemRegistryObject<GearBlueprintItem> HELMET_TEMPLATE = SgItems.registerGearBlueprint(GearType.HELMET, true);
    public static final ItemRegistryObject<GearBlueprintItem> CHESTPLATE_TEMPLATE = SgItems.registerGearBlueprint(GearType.CHESTPLATE, true);
    public static final ItemRegistryObject<GearBlueprintItem> LEGGINGS_TEMPLATE = SgItems.registerGearBlueprint(GearType.LEGGINGS, true);
    public static final ItemRegistryObject<GearBlueprintItem> BOOTS_TEMPLATE = SgItems.registerGearBlueprint(GearType.BOOTS, true);
    public static final ItemRegistryObject<GearBlueprintItem> ELYTRA_TEMPLATE = SgItems.registerGearBlueprint(GearType.ELYTRA, true);
    public static final ItemRegistryObject<GearBlueprintItem> ARROW_TEMPLATE = SgItems.registerGearBlueprint(GearType.ARROW, true);
    public static final ItemRegistryObject<GearBlueprintItem> RING_TEMPLATE = SgItems.registerGearBlueprint(GearType.RING, true);
    public static final ItemRegistryObject<GearBlueprintItem> BRACELET_TEMPLATE = SgItems.registerGearBlueprint(GearType.BRACELET, true);
    public static final ItemRegistryObject<MainPartItem> SWORD_BLADE = SgItems.registerCompoundPart("sword_blade", () -> new MainPartItem(GearType.SWORD, SgItems.unstackableProps()));
    public static final ItemRegistryObject<MainPartItem> KATANA_BLADE = SgItems.registerCompoundPart("katana_blade", () -> new MainPartItem(GearType.KATANA, SgItems.unstackableProps()));
    public static final ItemRegistryObject<MainPartItem> MACHETE_BLADE = SgItems.registerCompoundPart("machete_blade", () -> new MainPartItem(GearType.MACHETE, SgItems.unstackableProps()));
    public static final ItemRegistryObject<MainPartItem> SPEAR_TIP = SgItems.registerCompoundPart("spear_tip", () -> new MainPartItem(GearType.SPEAR, SgItems.unstackableProps()));
    public static final ItemRegistryObject<MainPartItem> TRIDENT_PRONGS = SgItems.registerCompoundPart("trident_prongs", () -> new MainPartItem(GearType.TRIDENT, SgItems.unstackableProps()));
    public static final ItemRegistryObject<MainPartItem> KNIFE_BLADE = SgItems.registerCompoundPart("knife_blade", () -> new MainPartItem(GearType.KNIFE, SgItems.unstackableProps()));
    public static final ItemRegistryObject<MainPartItem> DAGGER_BLADE = SgItems.registerCompoundPart("dagger_blade", () -> new MainPartItem(GearType.DAGGER, SgItems.unstackableProps()));
    public static final ItemRegistryObject<MainPartItem> PICKAXE_HEAD = SgItems.registerCompoundPart("pickaxe_head", () -> new MainPartItem(GearType.PICKAXE, SgItems.unstackableProps()));
    public static final ItemRegistryObject<MainPartItem> SHOVEL_HEAD = SgItems.registerCompoundPart("shovel_head", () -> new MainPartItem(GearType.SHOVEL, SgItems.unstackableProps()));
    public static final ItemRegistryObject<MainPartItem> AXE_HEAD = SgItems.registerCompoundPart("axe_head", () -> new MainPartItem(GearType.AXE, SgItems.unstackableProps()));
    public static final ItemRegistryObject<MainPartItem> PAXEL_HEAD = SgItems.registerCompoundPart("paxel_head", () -> new MainPartItem(GearType.PAXEL, SgItems.unstackableProps()));
    public static final ItemRegistryObject<MainPartItem> HAMMER_HEAD = SgItems.registerCompoundPart("hammer_head", () -> new MainPartItem(GearType.HAMMER, SgItems.unstackableProps()));
    public static final ItemRegistryObject<MainPartItem> EXCAVATOR_HEAD = SgItems.registerCompoundPart("excavator_head", () -> new MainPartItem(GearType.EXCAVATOR, SgItems.unstackableProps()));
    public static final ItemRegistryObject<MainPartItem> SAW_BLADE = SgItems.registerCompoundPart("saw_blade", () -> new MainPartItem(GearType.SAW, SgItems.unstackableProps()));
    public static final ItemRegistryObject<MainPartItem> HOE_HEAD = SgItems.registerCompoundPart("hoe_head", () -> new MainPartItem(GearType.HOE, SgItems.unstackableProps()));
    public static final ItemRegistryObject<MainPartItem> MATTOCK_HEAD = SgItems.registerCompoundPart("mattock_head", () -> new MainPartItem(GearType.MATTOCK, SgItems.unstackableProps()));
    public static final ItemRegistryObject<MainPartItem> PROSPECTOR_HAMMER_HEAD = SgItems.registerCompoundPart("prospector_hammer_head", () -> new MainPartItem(GearType.PROSPECTOR_HAMMER, SgItems.unstackableProps()));
    public static final ItemRegistryObject<MainPartItem> SICKLE_BLADE = SgItems.registerCompoundPart("sickle_blade", () -> new MainPartItem(GearType.SICKLE, SgItems.unstackableProps()));
    public static final ItemRegistryObject<MainPartItem> SHEARS_BLADES = SgItems.registerCompoundPart("shears_blades", () -> new MainPartItem(GearType.SHEARS, SgItems.unstackableProps()));
    public static final ItemRegistryObject<MainPartItem> FISHING_REEL_AND_HOOK = SgItems.registerCompoundPart("fishing_reel_and_hook", () -> new MainPartItem(GearType.FISHING_ROD, SgItems.unstackableProps()));
    public static final ItemRegistryObject<MainPartItem> BOW_LIMBS = SgItems.registerCompoundPart("bow_limbs", () -> new MainPartItem(GearType.BOW, SgItems.unstackableProps()));
    public static final ItemRegistryObject<MainPartItem> CROSSBOW_LIMBS = SgItems.registerCompoundPart("crossbow_limbs", () -> new MainPartItem(GearType.CROSSBOW, SgItems.unstackableProps()));
    public static final ItemRegistryObject<MainPartItem> SLINGSHOT_LIMBS = SgItems.registerCompoundPart("slingshot_limbs", () -> new MainPartItem(GearType.SLINGSHOT, SgItems.unstackableProps()));
    public static final ItemRegistryObject<MainPartItem> SHIELD_PLATE = SgItems.registerCompoundPart("shield_plate", () -> new MainPartItem(GearType.SHIELD, new Item.Properties().m_41487_(1)));
    public static final ItemRegistryObject<MainPartItem> HELMET_PLATES = SgItems.registerCompoundPart("helmet_plates", () -> new MainPartItem(GearType.HELMET, SgItems.unstackableProps()));
    public static final ItemRegistryObject<MainPartItem> CHESTPLATE_PLATES = SgItems.registerCompoundPart("chestplate_plates", () -> new MainPartItem(GearType.CHESTPLATE, SgItems.unstackableProps()));
    public static final ItemRegistryObject<MainPartItem> LEGGING_PLATES = SgItems.registerCompoundPart("legging_plates", () -> new MainPartItem(GearType.LEGGINGS, SgItems.unstackableProps()));
    public static final ItemRegistryObject<MainPartItem> BOOT_PLATES = SgItems.registerCompoundPart("boot_plates", () -> new MainPartItem(GearType.BOOTS, SgItems.unstackableProps()));
    public static final ItemRegistryObject<MainPartItem> ELYTRA_WINGS = SgItems.registerCompoundPart("elytra_wings", () -> new MainPartItem(GearType.ELYTRA, SgItems.unstackableProps()));
    public static final ItemRegistryObject<MainPartItem> ARROW_HEADS = SgItems.registerCompoundPart("arrow_heads", () -> new MainPartItem(GearType.ARROW, SgItems.unstackableProps()));
    public static final ItemRegistryObject<MainPartItem> RING_SHANK = SgItems.registerCompoundPart("ring_shank", () -> new MainPartItem(GearType.RING, SgItems.unstackableProps()));
    public static final ItemRegistryObject<MainPartItem> BRACELET_BAND = SgItems.registerCompoundPart("bracelet_band", () -> new MainPartItem(GearType.BRACELET, SgItems.unstackableProps()));
    public static final ItemRegistryObject<CompoundPartItem> ROD = SgItems.registerCompoundPart("rod", () -> new CompoundPartItem(PartType.ROD, SgItems.baseProps()));
    public static final ItemRegistryObject<CompoundPartItem> TIP = SgItems.registerCompoundPart("tip", () -> new CompoundPartItem(PartType.TIP, SgItems.baseProps()));
    public static final ItemRegistryObject<CompoundPartItem> COATING = SgItems.registerCompoundPart("coating", () -> new CompoundPartItem(PartType.COATING, SgItems.baseProps()));
    public static final ItemRegistryObject<CompoundPartItem> GRIP = SgItems.registerCompoundPart("grip", () -> new CompoundPartItem(PartType.GRIP, SgItems.baseProps()));
    public static final ItemRegistryObject<CompoundPartItem> BINDING = SgItems.registerCompoundPart("binding", () -> new CompoundPartItem(PartType.BINDING, SgItems.baseProps()));
    public static final ItemRegistryObject<CompoundPartItem> LINING = SgItems.registerCompoundPart("lining", () -> new CompoundPartItem(PartType.LINING, SgItems.baseProps()));
    public static final ItemRegistryObject<CompoundPartItem> CORD = SgItems.registerCompoundPart("cord", () -> new CompoundPartItem(PartType.CORD, SgItems.baseProps()));
    public static final ItemRegistryObject<CompoundPartItem> FLETCHING = SgItems.registerCompoundPart("fletching", () -> new CompoundPartItem(PartType.FLETCHING, SgItems.baseProps()));
    public static final ItemRegistryObject<CompoundPartItem> ADORNMENT = SgItems.registerCompoundPart("adornment", () -> new CompoundPartItem(PartType.ADORNMENT, SgItems.baseProps()));
    public static final ItemRegistryObject<CompoundMaterialItem> ALLOY_INGOT = SgItems.register("alloy_ingot", () -> new CompoundMaterialItem(SgItems.baseProps()));
    public static final ItemRegistryObject<CompoundMaterialItem> HYBRID_GEM = SgItems.register("hybrid_gem", () -> new CompoundMaterialItem(SgItems.baseProps()));
    public static final ItemRegistryObject<CompoundMaterialItem> MIXED_FABRIC = SgItems.register("mixed_fabric", () -> new CompoundMaterialItem(SgItems.baseProps()));
    public static final ItemRegistryObject<CustomMaterialItem> CUSTOM_INGOT = SgItems.register("custom_ingot", () -> new CustomMaterialItem(SgItems.baseProps()));
    public static final ItemRegistryObject<CustomMaterialItem> CUSTOM_GEM = SgItems.register("custom_gem", () -> new CustomMaterialItem(SgItems.baseProps()));
    public static final ItemRegistryObject<CraftedMaterialItem> SHEET_METAL = SgItems.register("sheet_metal", () -> new CraftedMaterialItem(SgItems.baseProps()));
    public static final ItemRegistryObject<FragmentItem> FRAGMENT;
    public static final ItemRegistryObject<Item> PEBBLE;
    public static final ItemRegistryObject<ItemNameBlockItem> FLAX_SEEDS;
    public static final ItemRegistryObject<ItemNameBlockItem> FLUFFY_SEEDS;
    public static final ItemRegistryObject<Item> NETHER_BANANA;
    public static final ItemRegistryObject<Item> GOLDEN_NETHER_BANANA;
    public static final ItemRegistryObject<Item> NETHERWOOD_CHARCOAL;
    public static final ItemRegistryObject<GearSwordItem> SWORD;
    public static final ItemRegistryObject<GearSwordItem> KATANA;
    public static final ItemRegistryObject<GearMacheteItem> MACHETE;
    public static final ItemRegistryObject<GearSwordItem> SPEAR;
    public static final ItemRegistryObject<GearTridentItem> TRIDENT;
    public static final ItemRegistryObject<GearDaggerItem> KNIFE;
    public static final ItemRegistryObject<GearDaggerItem> DAGGER;
    public static final ItemRegistryObject<GearPickaxeItem> PICKAXE;
    public static final ItemRegistryObject<GearShovelItem> SHOVEL;
    public static final ItemRegistryObject<GearAxeItem> AXE;
    public static final ItemRegistryObject<GearPaxelItem> PAXEL;
    public static final ItemRegistryObject<GearHammerItem> HAMMER;
    public static final ItemRegistryObject<GearExcavatorItem> EXCAVATOR;
    public static final ItemRegistryObject<GearSawItem> SAW;
    public static final ItemRegistryObject<GearProspectorHammerItem> PROSPECTOR_HAMMER;
    public static final ItemRegistryObject<GearHoeItem> HOE;
    public static final ItemRegistryObject<GearMattockItem> MATTOCK;
    public static final ItemRegistryObject<GearSickleItem> SICKLE;
    public static final ItemRegistryObject<GearShearsItem> SHEARS;
    public static final ItemRegistryObject<GearFishingRodItem> FISHING_ROD;
    public static final ItemRegistryObject<GearBowItem> BOW;
    public static final ItemRegistryObject<GearCrossbowItem> CROSSBOW;
    public static final ItemRegistryObject<GearSlingshotItem> SLINGSHOT;
    public static final ItemRegistryObject<GearShieldItem> SHIELD;
    public static final ItemRegistryObject<GearArrowItem> ARROW;
    public static final ItemRegistryObject<GearArmorItem> HELMET;
    public static final ItemRegistryObject<GearArmorItem> CHESTPLATE;
    public static final ItemRegistryObject<GearArmorItem> LEGGINGS;
    public static final ItemRegistryObject<GearArmorItem> BOOTS;
    public static final ItemRegistryObject<GearElytraItem> ELYTRA;
    public static final ItemRegistryObject<GearCurioItem> RING;
    public static final ItemRegistryObject<GearCurioItem> BRACELET;

    private SgItems() {
    }

    private static Item.Properties baseProps() {
        return new Item.Properties();
    }

    private static Item.Properties unstackableProps() {
        return SgItems.baseProps().m_41487_(1);
    }

    private static <T extends Item> ItemRegistryObject<T> register(String name, Supplier<T> item) {
        return new ItemRegistryObject(ITEMS.register(name, item));
    }

    private static <T extends CompoundPartItem> ItemRegistryObject<T> registerCompoundPart(String name, Supplier<T> item) {
        return SgItems.register(name, item);
    }

    private static ItemRegistryObject<GearBlueprintItem> registerGearBlueprint(GearType gearType, boolean singleUse) {
        String name = gearType.getName() + "_" + (singleUse ? "template" : "blueprint");
        return SgItems.register(name, () -> new GearBlueprintItem(gearType, singleUse, SgItems.baseProps()));
    }

    private static ItemRegistryObject<PartBlueprintItem> registerPartBlueprint(PartType partType, boolean singleUse) {
        String name = partType.getName().m_135815_() + "_" + (singleUse ? "template" : "blueprint");
        return SgItems.register(name, () -> new PartBlueprintItem(partType, singleUse, SgItems.baseProps()));
    }

    public static <T> Collection<T> getItems(Class<T> clazz) {
        return ITEMS.getEntries().stream().map(RegistryObject::get).filter(clazz::isInstance).map(item -> item).collect(Collectors.toList());
    }

    public static Collection<Item> getItems(Predicate<Item> predicate) {
        return ITEMS.getEntries().stream().map(RegistryObject::get).filter(predicate).collect(Collectors.toList());
    }

    static {
        CraftingItems.register(ITEMS);
        FRAGMENT = SgItems.register("fragment", () -> new FragmentItem(SgItems.baseProps()));
        PEBBLE = SgItems.register("pebble", () -> new SlingshotAmmoItem(SgItems.baseProps()));
        FLAX_SEEDS = SgItems.register("flax_seeds", () -> new SeedItem((Block)SgBlocks.FLAX_PLANT.get(), SgItems.baseProps()));
        FLUFFY_SEEDS = SgItems.register("fluffy_seeds", () -> new SeedItem((Block)SgBlocks.FLUFFY_PLANT.get(), SgItems.baseProps()));
        NETHER_BANANA = SgItems.register("nether_banana", () -> new Item(SgItems.baseProps().m_41489_(new FoodProperties.Builder().m_38760_(5).m_38758_(0.4f).m_38767_())));
        GOLDEN_NETHER_BANANA = SgItems.register("golden_nether_banana", () -> new Item(SgItems.baseProps().m_41489_(new FoodProperties.Builder().m_38760_(10).m_38758_(1.0f).m_38765_().effect(() -> new MobEffectInstance(MobEffects.f_19607_, TimeUtils.ticksFromMinutes((float)10.0f)), 1.0f).effect(() -> new MobEffectInstance(MobEffects.f_19606_, TimeUtils.ticksFromMinutes((float)5.0f)), 1.0f).effect(() -> new MobEffectInstance(MobEffects.f_19605_, TimeUtils.ticksFromSeconds((float)10.0f)), 1.0f).m_38767_())));
        NETHERWOOD_CHARCOAL = SgItems.register("netherwood_charcoal", () -> new Item(SgItems.baseProps()){

            public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
                return (Integer)Config.Common.netherwoodCharcoalBurnTime.get();
            }
        });
        SWORD = SgItems.register("sword", () -> new GearSwordItem(GearType.SWORD));
        KATANA = SgItems.register("katana", () -> new GearSwordItem(GearType.KATANA));
        MACHETE = SgItems.register("machete", () -> new GearMacheteItem(GearType.MACHETE));
        SPEAR = SgItems.register("spear", () -> new GearSwordItem(GearType.SPEAR));
        TRIDENT = SgItems.register("trident", () -> new GearTridentItem());
        KNIFE = SgItems.register("knife", () -> new GearDaggerItem(GearType.KNIFE));
        DAGGER = SgItems.register("dagger", () -> new GearDaggerItem(GearType.DAGGER));
        PICKAXE = SgItems.register("pickaxe", () -> new GearPickaxeItem(GearType.PICKAXE));
        SHOVEL = SgItems.register("shovel", () -> new GearShovelItem(GearType.SHOVEL));
        AXE = SgItems.register("axe", () -> new GearAxeItem(GearType.AXE));
        PAXEL = SgItems.register("paxel", () -> new GearPaxelItem(GearType.PAXEL));
        HAMMER = SgItems.register("hammer", () -> new GearHammerItem(GearType.HAMMER));
        EXCAVATOR = SgItems.register("excavator", () -> new GearExcavatorItem(GearType.EXCAVATOR));
        SAW = SgItems.register("saw", () -> new GearSawItem(GearType.SAW));
        PROSPECTOR_HAMMER = SgItems.register("prospector_hammer", () -> new GearProspectorHammerItem(GearType.PROSPECTOR_HAMMER));
        HOE = SgItems.register("hoe", () -> new GearHoeItem(GearType.HOE));
        MATTOCK = SgItems.register("mattock", () -> new GearMattockItem());
        SICKLE = SgItems.register("sickle", () -> new GearSickleItem(GearType.SICKLE));
        SHEARS = SgItems.register("shears", () -> new GearShearsItem());
        FISHING_ROD = SgItems.register("fishing_rod", GearFishingRodItem::new);
        BOW = SgItems.register("bow", () -> new GearBowItem());
        CROSSBOW = SgItems.register("crossbow", () -> new GearCrossbowItem());
        SLINGSHOT = SgItems.register("slingshot", () -> new GearSlingshotItem());
        SHIELD = SgItems.register("shield", () -> new GearShieldItem());
        ARROW = SgItems.register("arrow", () -> new GearArrowItem(SgItems.unstackableProps()));
        HELMET = SgItems.register("helmet", () -> new GearArmorItem(ArmorItem.Type.HELMET));
        CHESTPLATE = SgItems.register("chestplate", () -> new GearArmorItem(ArmorItem.Type.CHESTPLATE));
        LEGGINGS = SgItems.register("leggings", () -> new GearArmorItem(ArmorItem.Type.LEGGINGS));
        BOOTS = SgItems.register("boots", () -> new GearArmorItem(ArmorItem.Type.BOOTS));
        ELYTRA = SgItems.register("elytra", () -> new GearElytraItem(SgItems.unstackableProps()));
        RING = SgItems.register("ring", () -> new GearCurioItem(GearType.RING, "ring", SgItems.unstackableProps()));
        BRACELET = SgItems.register("bracelet", () -> new GearCurioItem(GearType.BRACELET, "bracelet", SgItems.unstackableProps()));
    }
}

