/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.advancements;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;

public class GenericIntTrigger
implements CriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("silentlib", "generic_int");
    private final Map<PlayerAdvancements, Listeners> listeners = new HashMap<PlayerAdvancements, Listeners>();

    public ResourceLocation m_7295_() {
        return ID;
    }

    public void m_6467_(PlayerAdvancements playerAdvancementsIn, CriterionTrigger.Listener<Instance> listenerIn) {
        Listeners triggerListeners = this.listeners.get(playerAdvancementsIn);
        if (triggerListeners == null) {
            triggerListeners = new Listeners(playerAdvancementsIn);
            this.listeners.put(playerAdvancementsIn, triggerListeners);
        }
        triggerListeners.add(listenerIn);
    }

    public void m_6468_(PlayerAdvancements playerAdvancementsIn, CriterionTrigger.Listener<Instance> listenerIn) {
        Listeners triggerListeners = this.listeners.get(playerAdvancementsIn);
        if (triggerListeners != null) {
            triggerListeners.remove(listenerIn);
            if (triggerListeners.isEmpty()) {
                this.listeners.remove(playerAdvancementsIn);
            }
        }
    }

    public void m_5656_(PlayerAdvancements playerAdvancementsIn) {
        this.listeners.remove(playerAdvancementsIn);
    }

    public Instance createInstance(JsonObject json, DeserializationContext p_230307_2_) {
        String type = GsonHelper.m_13851_((JsonObject)json, (String)"type", (String)"unknown");
        int value = GsonHelper.m_13824_((JsonObject)json, (String)"value", (int)0);
        return new Instance(type, value);
    }

    public void trigger(ServerPlayer player, ResourceLocation type, int value) {
        Listeners triggerListeners = this.listeners.get(player.m_8960_());
        if (triggerListeners != null) {
            triggerListeners.trigger(type.toString(), value);
        }
    }

    static class Listeners {
        private final PlayerAdvancements playerAdvancements;
        private final Set<CriterionTrigger.Listener<Instance>> listeners = new HashSet<CriterionTrigger.Listener<Instance>>();

        Listeners(PlayerAdvancements playerAdvancementsIn) {
            this.playerAdvancements = playerAdvancementsIn;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(CriterionTrigger.Listener<Instance> listener) {
            this.listeners.add(listener);
        }

        public void remove(CriterionTrigger.Listener<Instance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(String typeIn, int valueIn) {
            ArrayList<CriterionTrigger.Listener<Instance>> list = new ArrayList<CriterionTrigger.Listener<Instance>>();
            for (CriterionTrigger.Listener<Instance> listener : this.listeners) {
                if (!((Instance)listener.m_13685_()).test(typeIn, valueIn)) continue;
                list.add(listener);
            }
            for (CriterionTrigger.Listener listener : list) {
                listener.m_13686_(this.playerAdvancements);
            }
        }
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        String type;
        int value;

        Instance(String type, int value) {
            super(ID, ContextAwarePredicate.f_285567_);
            this.type = type;
            this.value = value;
        }

        public static Instance instance(ResourceLocation type, int value) {
            return new Instance(type.toString(), value);
        }

        public boolean test(String typeIn, int valueIn) {
            return this.type.equals(typeIn) && this.value <= valueIn;
        }

        public JsonObject m_7683_(SerializationContext p_230240_1_) {
            JsonObject json = new JsonObject();
            json.addProperty("type", this.type);
            json.addProperty("value", (Number)this.value);
            return json;
        }
    }
}

