/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.chipped;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerType;
import net.p3pp3rf1y.sophisticatedcore.compat.chipped.BlockTransformationRecipeContainer;
import net.p3pp3rf1y.sophisticatedcore.compat.chipped.BlockTransformationUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class BlockTransformationUpgradeContainer
extends UpgradeContainerBase<BlockTransformationUpgradeWrapper, BlockTransformationUpgradeContainer> {
    private static final String DATA_SHIFT_CLICK_INTO_STORAGE = "shiftClickIntoStorage";
    private final BlockTransformationRecipeContainer recipeContainer;

    public BlockTransformationUpgradeContainer(Player player, int upgradeContainerId, BlockTransformationUpgradeWrapper upgradeWrapper, UpgradeContainerType<BlockTransformationUpgradeWrapper, BlockTransformationUpgradeContainer> type) {
        super(player, upgradeContainerId, upgradeWrapper, type);
        ContainerLevelAccess worldPosCallable = player.m_9236_().f_46443_ ? ContainerLevelAccess.f_39287_ : ContainerLevelAccess.m_39289_((Level)player.m_9236_(), (BlockPos)player.m_20183_());
        this.recipeContainer = new BlockTransformationRecipeContainer(this, upgradeWrapper.getRecipeType(), this.slots::add, this, worldPosCallable);
    }

    @Override
    public void handleMessage(CompoundTag data) {
        if (data.m_128441_(DATA_SHIFT_CLICK_INTO_STORAGE)) {
            this.setShiftClickIntoStorage(data.m_128471_(DATA_SHIFT_CLICK_INTO_STORAGE));
        } else {
            this.recipeContainer.handleMessage(data);
        }
    }

    public boolean shouldShiftClickIntoStorage() {
        return ((BlockTransformationUpgradeWrapper)this.upgradeWrapper).shouldShiftClickIntoStorage();
    }

    public void setShiftClickIntoStorage(boolean shiftClickIntoStorage) {
        ((BlockTransformationUpgradeWrapper)this.upgradeWrapper).setShiftClickIntoStorage(shiftClickIntoStorage);
        this.sendDataToServer(() -> NBTHelper.putBoolean(new CompoundTag(), DATA_SHIFT_CLICK_INTO_STORAGE, shiftClickIntoStorage));
    }

    public BlockTransformationRecipeContainer getRecipeContainer() {
        return this.recipeContainer;
    }

    @Override
    public boolean mergeIntoStorageFirst(Slot slot) {
        return this.recipeContainer.isNotResultSlot(slot) || this.shouldShiftClickIntoStorage();
    }

    @Override
    public boolean allowsPickupAll(Slot slot) {
        return this.recipeContainer.isNotResultSlot(slot);
    }
}

