/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.blueprints.v1;

import net.minecraft.SharedConstants;

public enum DataVersion {
    UPCOMING(3466, null, null),
    v1_20_1(3465, "1.20.1", UPCOMING),
    v1_20(3463, "1.20", v1_20_1),
    v1_19_4(3328, "1.19.4", v1_20),
    v1_19_3(3218, "1.19.3", v1_19_4),
    v1_19_2(3120, "1.19.2", v1_19_3),
    v1_19_1(3117, "1.19.1", v1_19_2),
    v1_19(3105, "1.19", v1_19_1),
    v1_18_2(2975, "1.18.2", v1_19),
    v1_18_1(2865, "1.18.1", v1_18_2),
    v1_18(2860, "1.18", v1_18_1),
    v1_17_1(2730, "1.17.1", v1_18),
    v1_17(2724, "1.17", v1_17_1),
    v1_16_5(2586, "1.16.5", v1_17),
    v1_16_4(2584, "1.16.4", v1_16_5),
    v1_16_3(2580, "1.16.3", v1_16_4),
    v1_16_2(2578, "1.16.2", v1_16_3),
    v1_16_1(2567, "1.16.1", v1_16_2),
    v1_16(2566, "1.16", v1_16_1),
    v1_15_2(2230, "1.15.2", v1_16),
    v1_15_1(2227, "1.15.1", v1_15_2),
    v1_15(2225, "1.15", v1_15_1),
    v1_14_4(1976, "1.14.4", v1_15),
    v1_14_3(1968, "1.14.3", v1_14_4),
    v1_14_2(1963, "1.14.2", v1_14_3),
    v1_14_1(1957, "1.14.1", v1_14_2),
    v1_14(1952, "1.14", v1_14_1),
    v1_13_2(1631, "1.13.2", v1_14),
    v1_13_1(1628, "1.13.1", v1_13_2),
    v1_13(1519, "1.13", v1_13_1),
    post1466(1467, "post1466", v1_13),
    pre1466(1465, "pre1466", post1466),
    v1_12_2(1343, "1.12.2", pre1466),
    v1_12_1(1241, "1.12.1", v1_12_2),
    v1_12(1139, "1.12", v1_12_1),
    v1_11_2(922, "1.11.2", v1_12),
    v1_11_1(921, "1.11.1", v1_11_2),
    v1_11(819, "1.11", v1_11_1),
    v1_10_2(512, "1.10.2", v1_11),
    v1_10_1(511, "1.10.1", v1_10_2),
    v1_10(510, "1.10", v1_10_1),
    v1_9_4(184, "1.9.4", v1_10),
    v1_9_3(183, "1.9.3", v1_9_4),
    v1_9_2(176, "1.9.2", v1_9_3),
    v1_9_1(175, "1.9.1", v1_9_2),
    v1_9(169, "1.9", v1_9_1),
    DEFAULT(0, null, v1_9);

    public static final DataVersion CURRENT;
    private final int dataVersion;
    private final String mcVersion;
    private final DataVersion successor;

    private DataVersion(int dataVersion, String mcVersion, DataVersion successor) {
        this.dataVersion = dataVersion;
        this.mcVersion = mcVersion;
        this.successor = successor;
    }

    public int getDataVersion() {
        return this.dataVersion;
    }

    public String getMcVersion() {
        return this.mcVersion;
    }

    public DataVersion getSuccessor() {
        return this.successor;
    }

    public static DataVersion findFromMcVersion(String mcVersion) {
        if (mcVersion == null) {
            return DEFAULT;
        }
        for (DataVersion ver : DataVersion.values()) {
            if (ver.mcVersion == null || !ver.mcVersion.equals(mcVersion)) continue;
            return ver;
        }
        return DEFAULT;
    }

    public static DataVersion findFromDataVersion(int dataVersion) {
        DataVersion version = DEFAULT;
        while (version.successor != null && version.successor.dataVersion <= dataVersion) {
            version = version.successor;
        }
        return version;
    }

    static {
        CURRENT = DataVersion.findFromDataVersion(SharedConstants.m_183709_().m_183476_().m_193006_());
    }
}

