/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.commands;

import com.ldtteam.structurize.blocks.interfaces.ISpecialCreativeHandlerAnchorBlock;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.commands.AbstractCommand;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.placement.StructurePlacer;
import com.ldtteam.structurize.placement.structure.AbstractStructureHandler;
import com.ldtteam.structurize.placement.structure.CreativeStructureHandler;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.util.PlacementSettings;
import com.ldtteam.structurize.util.RotationMirror;
import com.ldtteam.structurize.util.TickedWorldOperation;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class PasteCommand
extends AbstractCommand {
    public static final String commandName = "paste";
    private static final String PLAYER_NOT_FOUND = "com.structurize.command.playernotfound";
    private static final String PASTE_SUCCESS_MESSAGE = "com.structurize.command.paste.success";
    private static final String NO_PERMISSION_MESSAGE = "com.structurize.command.paste.no.perm";
    private static final String NO_PACK_MESSAGE = "com.structurize.command.paste.no.pack";
    private static final String NO_BLUEPRINT_MESSAGE = "com.structurize.command.paste.no.blueprint";
    private static final String PLAYER_NAME = "player";
    private static final String POS = "pos";
    private static final String PACK_NAME = "pack";
    private static final String FILE_PATH = "path";
    private static final String ROTATION = "rotation";
    private static final String MIRROR = "mirror";
    private static final String PRETTY = "pretty";

    private static int execute(CommandSourceStack source, BlockPos pos, String pack, String tempPath, Rotation rotation, boolean mirrored, boolean pretty, Player player) throws CommandSyntaxException {
        AbstractStructureHandler structure;
        @Nullable ServerLevel world = source.m_81372_();
        if (source.m_81373_() instanceof Player && !source.m_81375_().m_7500_()) {
            source.m_81352_((Component)Component.m_237113_((String)NO_PERMISSION_MESSAGE));
            return 0;
        }
        if (!(player instanceof ServerPlayer)) {
            source.m_81352_((Component)Component.m_237115_((String)PLAYER_NOT_FOUND));
            return 0;
        }
        Mirror mirror = mirrored ? Mirror.FRONT_BACK : Mirror.NONE;
        String[] split = tempPath.split("\\.");
        StringBuilder builder = new StringBuilder();
        for (String string : split) {
            if (!builder.toString().isEmpty()) {
                builder.append("/");
            }
            builder.append(string);
        }
        String path = builder.toString();
        String[] packSplit = pack.split("\\.");
        StringBuilder packBuilder = new StringBuilder();
        for (String part : packSplit) {
            if (!packBuilder.toString().isEmpty()) {
                packBuilder.append(" ");
            }
            packBuilder.append(part);
        }
        String string = packBuilder.toString();
        if (!StructurePacks.hasPack(string)) {
            source.m_81352_((Component)Component.m_237115_((String)NO_PACK_MESSAGE));
            return 0;
        }
        Blueprint blueprint = StructurePacks.getBlueprint(string, path + ".blueprint", true);
        if (blueprint == null) {
            source.m_81352_((Component)Component.m_237115_((String)NO_BLUEPRINT_MESSAGE));
            return 0;
        }
        BlockState anchor = blueprint.m_8055_(blueprint.getPrimaryBlockOffset());
        blueprint.setRotationMirror(RotationMirror.of(rotation, mirror), (Level)world);
        if (anchor.m_60734_() instanceof ISpecialCreativeHandlerAnchorBlock) {
            if (!((ISpecialCreativeHandlerAnchorBlock)anchor.m_60734_()).setup((ServerPlayer)player, (Level)world, pos, blueprint, new PlacementSettings(mirror, rotation), pretty, string, path)) {
                return 0;
            }
            structure = ((ISpecialCreativeHandlerAnchorBlock)anchor.m_60734_()).getStructureHandler((Level)world, pos, blueprint, new PlacementSettings(mirror, rotation), pretty);
        } else {
            structure = new CreativeStructureHandler((Level)world, pos, blueprint, new PlacementSettings(mirror, rotation), pretty);
        }
        StructurePlacer instantPlacer = new StructurePlacer(structure);
        Manager.addToQueue(new TickedWorldOperation(instantPlacer, player));
        source.m_288197_(() -> Component.m_237115_((String)PASTE_SUCCESS_MESSAGE), true);
        return 1;
    }

    private static int onExecute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.m_174395_(context, (String)POS);
        String packName = StringArgumentType.getString(context, (String)PACK_NAME);
        String path = StringArgumentType.getString(context, (String)FILE_PATH);
        return PasteCommand.execute((CommandSourceStack)context.getSource(), pos, packName, path, Rotation.NONE, false, true, (Player)((CommandSourceStack)context.getSource()).m_230896_());
    }

    private static int onExecuteWithRotation(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.m_174395_(context, (String)POS);
        String packName = StringArgumentType.getString(context, (String)PACK_NAME);
        String path = StringArgumentType.getString(context, (String)FILE_PATH);
        Rotation rotation = Rotation.values()[IntegerArgumentType.getInteger(context, (String)ROTATION)];
        return PasteCommand.execute((CommandSourceStack)context.getSource(), pos, packName, path, rotation, false, true, (Player)((CommandSourceStack)context.getSource()).m_230896_());
    }

    private static int onExecuteWithRotationAndMirror(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.m_174395_(context, (String)POS);
        String packName = StringArgumentType.getString(context, (String)PACK_NAME);
        String path = StringArgumentType.getString(context, (String)FILE_PATH);
        Rotation rotation = Rotation.values()[IntegerArgumentType.getInteger(context, (String)ROTATION)];
        boolean mirror = BoolArgumentType.getBool(context, (String)MIRROR);
        return PasteCommand.execute((CommandSourceStack)context.getSource(), pos, packName, path, rotation, mirror, true, (Player)((CommandSourceStack)context.getSource()).m_230896_());
    }

    private static int onExecuteWithFull(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.m_174395_(context, (String)POS);
        String packName = StringArgumentType.getString(context, (String)PACK_NAME);
        String path = StringArgumentType.getString(context, (String)FILE_PATH);
        Rotation rotation = Rotation.values()[IntegerArgumentType.getInteger(context, (String)ROTATION)];
        boolean mirror = BoolArgumentType.getBool(context, (String)MIRROR);
        boolean pretty = BoolArgumentType.getBool(context, (String)PRETTY);
        return PasteCommand.execute((CommandSourceStack)context.getSource(), pos, packName, path, rotation, mirror, pretty, (Player)((CommandSourceStack)context.getSource()).m_230896_());
    }

    private static int onExecuteWithFullAndPlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.m_174395_(context, (String)POS);
        String packName = StringArgumentType.getString(context, (String)PACK_NAME);
        String path = StringArgumentType.getString(context, (String)FILE_PATH);
        Rotation rotation = Rotation.values()[IntegerArgumentType.getInteger(context, (String)ROTATION)];
        boolean mirror = BoolArgumentType.getBool(context, (String)MIRROR);
        boolean pretty = BoolArgumentType.getBool(context, (String)PRETTY);
        GameProfile profile = GameProfileArgument.m_94590_(context, (String)PLAYER_NAME).stream().findFirst().orElse(null);
        if (profile == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)PLAYER_NOT_FOUND));
            return 0;
        }
        return PasteCommand.execute((CommandSourceStack)context.getSource(), pos, packName, path, rotation, mirror, pretty, (Player)((CommandSourceStack)context.getSource()).m_81372_().m_7654_().m_6846_().m_11259_(profile.getId()));
    }

    protected static LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)PasteCommand.newLiteral(commandName).then(PasteCommand.newArgument(POS, BlockPosArgument.m_118239_()).then(PasteCommand.newArgument(PACK_NAME, StringArgumentType.string()).then(((RequiredArgumentBuilder)PasteCommand.newArgument(FILE_PATH, StringArgumentType.string()).executes(PasteCommand::onExecute)).then(((RequiredArgumentBuilder)PasteCommand.newArgument(ROTATION, IntegerArgumentType.integer((int)0, (int)3)).executes(PasteCommand::onExecuteWithRotation)).then(((RequiredArgumentBuilder)PasteCommand.newArgument(MIRROR, BoolArgumentType.bool()).executes(PasteCommand::onExecuteWithRotationAndMirror)).then(((RequiredArgumentBuilder)PasteCommand.newArgument(PRETTY, BoolArgumentType.bool()).executes(PasteCommand::onExecuteWithFull)).then(PasteCommand.newArgument(PLAYER_NAME, GameProfileArgument.m_94584_()).executes(PasteCommand::onExecuteWithFullAndPlayer))))))));
    }
}

