/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.util;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;

public enum RotationMirror {
    NONE(Rotation.NONE, Mirror.NONE),
    R90(Rotation.CLOCKWISE_90, Mirror.NONE),
    R180(Rotation.CLOCKWISE_180, Mirror.NONE),
    R270(Rotation.COUNTERCLOCKWISE_90, Mirror.NONE),
    MIR_NONE(Rotation.NONE, Mirror.FRONT_BACK),
    MIR_R90(Rotation.CLOCKWISE_90, Mirror.FRONT_BACK),
    MIR_R180(Rotation.CLOCKWISE_180, Mirror.FRONT_BACK),
    MIR_R270(Rotation.COUNTERCLOCKWISE_90, Mirror.FRONT_BACK);

    public static final RotationMirror[] MIRRORED;
    public static final RotationMirror[] NOT_MIRRORED;
    private final Rotation rotation;
    private final Mirror mirror;
    private RotationMirror rotateCW90;
    private RotationMirror rotateCW180;
    private RotationMirror rotateCCW90;
    private RotationMirror mirrorFB;
    private RotationMirror mirrorLR;

    private RotationMirror(Rotation rotation, Mirror mirror) {
        this.rotation = rotation;
        this.mirror = mirror;
    }

    public Rotation rotation() {
        return this.rotation;
    }

    public boolean isMirrored() {
        return this.mirror != Mirror.NONE;
    }

    public Mirror mirror() {
        return this.mirror;
    }

    public RotationMirror rotate(Rotation offset) {
        return switch (offset) {
            default -> throw new IncompatibleClassChangeError();
            case Rotation.CLOCKWISE_90 -> this.rotateCW90;
            case Rotation.CLOCKWISE_180 -> this.rotateCW180;
            case Rotation.COUNTERCLOCKWISE_90 -> this.rotateCCW90;
            case Rotation.NONE -> this;
        };
    }

    public RotationMirror mirrorate() {
        return this.mirrorate(Mirror.FRONT_BACK);
    }

    public RotationMirror mirrorate(Mirror mirrorIn) {
        return switch (mirrorIn) {
            default -> throw new IncompatibleClassChangeError();
            case Mirror.LEFT_RIGHT -> this.mirrorLR;
            case Mirror.FRONT_BACK -> this.mirrorFB;
            case Mirror.NONE -> this;
        };
    }

    public static RotationMirror of(Rotation rotation, Mirror mirror) {
        return NONE.mirrorate(mirror).rotate(rotation);
    }

    public BlockPos applyToPos(BlockPos pos) {
        return this.applyToPos(pos, BlockPos.f_121853_);
    }

    public BlockPos applyToPos(BlockPos pos, BlockPos pivot) {
        return StructureTemplate.m_74593_((BlockPos)pos, (Mirror)this.mirror, (Rotation)this.rotation, (BlockPos)pivot);
    }

    public Vec3 applyToPos(Vec3 pos) {
        return this.applyToPos(pos, BlockPos.f_121853_);
    }

    public Vec3 applyToPos(Vec3 pos, BlockPos pivot) {
        return StructureTemplate.m_74578_((Vec3)pos, (Mirror)this.mirror, (Rotation)this.rotation, (BlockPos)pivot);
    }

    public RotationMirror calcDifferenceTowards(RotationMirror end) {
        for (RotationMirror rotMir : this.mirror == end.mirror ? NOT_MIRRORED : MIRRORED) {
            if (this.add(rotMir) != end) continue;
            return rotMir;
        }
        throw new IllegalStateException("Missing RotationMirror path");
    }

    public RotationMirror add(RotationMirror other) {
        return this.mirrorate(other.mirror).rotate(other.rotation);
    }

    static {
        MIRRORED = new RotationMirror[]{MIR_NONE, MIR_R90, MIR_R180, MIR_R270};
        NOT_MIRRORED = new RotationMirror[]{NONE, R90, R180, R270};
        RotationMirror.NONE.rotateCW90 = R90;
        RotationMirror.R90.rotateCW90 = R180;
        RotationMirror.R180.rotateCW90 = R270;
        RotationMirror.R270.rotateCW90 = NONE;
        RotationMirror.MIR_NONE.rotateCW90 = MIR_R90;
        RotationMirror.MIR_R90.rotateCW90 = MIR_R180;
        RotationMirror.MIR_R180.rotateCW90 = MIR_R270;
        RotationMirror.MIR_R270.rotateCW90 = MIR_NONE;
        RotationMirror.NONE.rotateCW180 = R180;
        RotationMirror.R90.rotateCW180 = R270;
        RotationMirror.R180.rotateCW180 = NONE;
        RotationMirror.R270.rotateCW180 = R90;
        RotationMirror.MIR_NONE.rotateCW180 = MIR_R180;
        RotationMirror.MIR_R90.rotateCW180 = MIR_R270;
        RotationMirror.MIR_R180.rotateCW180 = MIR_NONE;
        RotationMirror.MIR_R270.rotateCW180 = MIR_R90;
        RotationMirror.NONE.rotateCCW90 = R270;
        RotationMirror.R90.rotateCCW90 = NONE;
        RotationMirror.R180.rotateCCW90 = R90;
        RotationMirror.R270.rotateCCW90 = R180;
        RotationMirror.MIR_NONE.rotateCCW90 = MIR_R270;
        RotationMirror.MIR_R90.rotateCCW90 = MIR_NONE;
        RotationMirror.MIR_R180.rotateCCW90 = MIR_R90;
        RotationMirror.MIR_R270.rotateCCW90 = MIR_R180;
        RotationMirror.NONE.mirrorFB = MIR_NONE;
        RotationMirror.R90.mirrorFB = MIR_R270;
        RotationMirror.R180.mirrorFB = MIR_R180;
        RotationMirror.R270.mirrorFB = MIR_R90;
        RotationMirror.MIR_NONE.mirrorFB = NONE;
        RotationMirror.MIR_R90.mirrorFB = R270;
        RotationMirror.MIR_R180.mirrorFB = R180;
        RotationMirror.MIR_R270.mirrorFB = R90;
        RotationMirror.NONE.mirrorLR = MIR_R180;
        RotationMirror.R90.mirrorLR = MIR_R90;
        RotationMirror.R180.mirrorLR = MIR_NONE;
        RotationMirror.R270.mirrorLR = MIR_R270;
        RotationMirror.MIR_NONE.mirrorLR = R180;
        RotationMirror.MIR_R90.mirrorLR = R90;
        RotationMirror.MIR_R180.mirrorLR = NONE;
        RotationMirror.MIR_R270.mirrorLR = R270;
    }
}

