/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.blueprints.v1;

import com.ldtteam.structurize.api.util.BlockPosUtil;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.blockentities.interfaces.IBlueprintDataProviderBE;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.blueprints.v1.DataFixerUtils;
import com.ldtteam.structurize.blueprints.v1.DataVersion;
import com.mojang.serialization.Dynamic;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.fixes.ChunkPalettedStorageFix;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;

public class BlueprintUtil {
    public static final int DEFAULT_FIXER_IF_NOT_FOUND = DataVersion.v1_12_2.getDataVersion();
    public static final String NBT_OPTIONAL_DATA_TAG = "optional_data";

    public static Blueprint createBlueprint(Level world, BlockPos pos, boolean saveEntities, short sizeX, short sizeY, short sizeZ, String name, Optional<BlockPos> anchorPos) {
        BlockEntity tile;
        ArrayList<BlockState> pallete = new ArrayList<BlockState>();
        pallete.add(Blocks.f_50016_.m_49966_());
        short[][][] structure = new short[sizeY][sizeZ][sizeX];
        ArrayList<CompoundTag> tileEntities = new ArrayList<CompoundTag>();
        ArrayList<String> requiredMods = new ArrayList<String>();
        for (BlockPos mutablePos : BlockPos.m_121940_((BlockPos)pos, (BlockPos)pos.m_7918_(sizeX - 1, sizeY - 1, sizeZ - 1))) {
            LevelChunk chunk;
            BlockEntity te;
            BlockState state = world.m_8055_(mutablePos);
            String modName = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_()).m_135827_();
            short x = (short)(mutablePos.m_123341_() - pos.m_123341_());
            short y = (short)(mutablePos.m_123342_() - pos.m_123342_());
            short z = (short)(mutablePos.m_123343_() - pos.m_123343_());
            if (!modName.equals("minecraft") && !modName.equals("structurize")) {
                if (!ModList.get().getModContainerById(modName).isPresent()) {
                    structure[y][z][x] = (short)pallete.indexOf(Blocks.f_50016_.m_49966_());
                    continue;
                }
                if (!requiredMods.contains(modName)) {
                    requiredMods.add(modName);
                }
            }
            BlockEntity blockEntity = te = (chunk = world.m_46745_(mutablePos)).m_62954_().containsKey(mutablePos) && !((BlockEntity)chunk.m_62954_().get(mutablePos)).m_58901_() ? chunk.m_7702_(mutablePos) : world.m_7702_(mutablePos.m_7949_());
            if (te != null) {
                CompoundTag teTag = te.m_187480_();
                teTag.m_128376_("x", x);
                teTag.m_128376_("y", y);
                teTag.m_128376_("z", z);
                tileEntities.add(teTag);
            }
            if (!pallete.contains(state)) {
                pallete.add(state);
            }
            structure[y][z][x] = (short)pallete.indexOf(state);
        }
        CompoundTag[] tes = tileEntities.toArray(new CompoundTag[0]);
        ArrayList<CompoundTag> entitiesTag = new ArrayList<CompoundTag>();
        List entities = new ArrayList();
        if (saveEntities) {
            entities = world.m_45933_(null, new AABB((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)(pos.m_123341_() + sizeX), (double)(pos.m_123342_() + sizeY), (double)(pos.m_123343_() + sizeZ)));
        }
        for (Entity entity : entities) {
            if (!entity.m_6095_().m_20584_()) continue;
            Vec3 oldPos = entity.m_20182_();
            CompoundTag entityTag = entity.serializeNBT();
            ListTag posList = new ListTag();
            posList.add((Object)DoubleTag.m_128500_((double)(oldPos.f_82479_ - (double)pos.m_123341_())));
            posList.add((Object)DoubleTag.m_128500_((double)(oldPos.f_82480_ - (double)pos.m_123342_())));
            posList.add((Object)DoubleTag.m_128500_((double)(oldPos.f_82481_ - (double)pos.m_123343_())));
            BlockPos entityPos = entity.m_20183_();
            if (entity instanceof HangingEntity) {
                entityPos = ((HangingEntity)entity).m_31748_();
            }
            entityTag.m_128365_("Pos", (Tag)posList);
            entityTag.m_128365_("TileX", (Tag)IntTag.m_128679_((int)(entityPos.m_123341_() - pos.m_123341_())));
            entityTag.m_128365_("TileY", (Tag)IntTag.m_128679_((int)(entityPos.m_123342_() - pos.m_123342_())));
            entityTag.m_128365_("TileZ", (Tag)IntTag.m_128679_((int)(entityPos.m_123343_() - pos.m_123343_())));
            entitiesTag.add(entityTag);
        }
        Blueprint schem = new Blueprint(sizeX, sizeY, sizeZ, (short)pallete.size(), pallete, structure, tes, requiredMods);
        schem.setEntities(entitiesTag.toArray(new CompoundTag[0]));
        if (anchorPos.isPresent()) {
            BlockPos relativeAnchorPos = new BlockPos((Vec3i)anchorPos.get().m_121996_((Vec3i)pos));
            schem.setCachePrimaryOffset(relativeAnchorPos);
        }
        if ((tile = world.m_7702_(pos.m_121955_((Vec3i)schem.getPrimaryBlockOffset()))) instanceof IBlueprintDataProviderBE) {
            CompoundTag blueprintData = (CompoundTag)schem.getBlockInfoAsMap().get(schem.getPrimaryBlockOffset()).getTileEntityData().m_128423_("blueprintDataProvider");
            if (name != null) {
                String fileName = FilenameUtils.getBaseName((String)name);
                blueprintData.m_128359_("schematicName", fileName);
                ((IBlueprintDataProviderBE)tile).setSchematicName(fileName);
                ((IBlueprintDataProviderBE)tile).setBlueprintPath(name);
            }
            BlockPos corner1 = BlockPos.f_121853_.m_121996_((Vec3i)schem.getPrimaryBlockOffset());
            BlockPos corner2 = new BlockPos(sizeX - 1, sizeY - 1, sizeZ - 1).m_121996_((Vec3i)schem.getPrimaryBlockOffset());
            ((IBlueprintDataProviderBE)tile).setSchematicCorners(corner1, corner2);
            BlockPosUtil.writeToNBT(blueprintData, "corner1", corner1);
            BlockPosUtil.writeToNBT(blueprintData, "corner2", corner2);
            if (!world.f_46443_) {
                ((ServerLevel)world).m_7726_().m_8450_(pos);
            }
        }
        if (name != null) {
            schem.setName(name);
        }
        return schem;
    }

    public static CompoundTag writeBlueprintToNBT(Blueprint schem) {
        CompoundTag tag = new CompoundTag();
        tag.m_128344_("version", (byte)1);
        tag.m_128376_("size_x", schem.getSizeX());
        tag.m_128376_("size_y", schem.getSizeY());
        tag.m_128376_("size_z", schem.getSizeZ());
        BlockState[] palette = schem.getPalette();
        ListTag paletteTag = new ListTag();
        for (short i = 0; i < schem.getPalleteSize(); i = (short)(i + 1)) {
            paletteTag.add((Object)NbtUtils.m_129202_((BlockState)palette[i]));
        }
        tag.m_128365_("palette", (Tag)paletteTag);
        int[] blockInt = BlueprintUtil.convertBlocksToSaveData(schem.getStructure(), schem.getSizeX(), schem.getSizeY(), schem.getSizeZ());
        tag.m_128385_("blocks", blockInt);
        ListTag finishedTes = new ListTag();
        CompoundTag[] tes = (CompoundTag[])Arrays.stream(schem.getTileEntities()).flatMap(Arrays::stream).flatMap(Arrays::stream).filter(Objects::nonNull).toArray(CompoundTag[]::new);
        finishedTes.addAll(Arrays.asList(tes));
        tag.m_128365_("tile_entities", (Tag)finishedTes);
        ListTag finishedEntities = new ListTag();
        CompoundTag[] entities = schem.getEntities();
        finishedEntities.addAll(Arrays.asList(entities));
        tag.m_128365_("entities", (Tag)finishedEntities);
        List<String> requiredMods = schem.getRequiredMods();
        ListTag modsList = new ListTag();
        for (String requiredMod : requiredMods) {
            modsList.add((Object)StringTag.m_129297_((String)requiredMod));
        }
        tag.m_128365_("required_mods", (Tag)modsList);
        String name = schem.getName();
        String[] architects = schem.getArchitects();
        if (name != null) {
            tag.m_128359_("name", name);
        }
        if (architects != null) {
            ListTag architectsTag = new ListTag();
            for (String architect : architects) {
                architectsTag.add((Object)StringTag.m_129297_((String)architect));
            }
            tag.m_128365_("architects", (Tag)architectsTag);
        }
        tag.m_128365_("mcversion", (Tag)IntTag.m_128679_((int)SharedConstants.m_183709_().m_183476_().m_193006_()));
        CompoundTag optionalTag = new CompoundTag();
        CompoundTag structurizeTag = new CompoundTag();
        BlockPosUtil.writeToNBT(structurizeTag, "primary_offset", schem.getPrimaryBlockOffset());
        optionalTag.m_128365_("structurize", (Tag)structurizeTag);
        tag.m_128365_(NBT_OPTIONAL_DATA_TAG, (Tag)optionalTag);
        return tag;
    }

    public static List<BlockState> fixPalette(int oldDataVersion, ListTag paletteTag) {
        short paletteSize = (short)paletteTag.size();
        ArrayList<BlockState> palette = new ArrayList<BlockState>();
        for (short i = 0; i < paletteSize; i = (short)(i + 1)) {
            CompoundTag nbt = paletteTag.m_128728_((int)i);
            try {
                CompoundTag fixedNbt = DataFixerUtils.runDataFixer(nbt, References.f_16783_, oldDataVersion);
                switch (oldDataVersion) {
                    case 1343: {
                        BlueprintUtil.fixPalette1343(fixedNbt);
                    }
                }
                BlockState state = NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)fixedNbt);
                palette.add(i, state);
                continue;
            }
            catch (Exception e) {
                palette.add(i, Blocks.f_50016_.m_49966_());
                Log.getLogger().warn("Blueprint reader: something went wrong loading block at position: " + i, (Throwable)e);
            }
        }
        return palette;
    }

    private static void fixPalette1343(CompoundTag oldBlockState) {
        String name = oldBlockState.m_128461_("Name");
        oldBlockState.m_128359_("Name", oldBlockState.m_128461_("Name").toLowerCase(Locale.US));
        if (name.contains("structurize")) {
            if (name.contains("blockshingle_")) {
                String[] split = name.split(":")[1].split("_");
                oldBlockState.m_128359_("Name", "structurize:clay_" + (String)(split.length > 2 ? split[1] + "_" + split[2] : split[1]) + "_shingle");
            } else if (name.contains("blockshingleslab")) {
                oldBlockState.m_128359_("Name", "structurize:clay_shingle_slab");
            } else if (name.contains("blocktimberframe")) {
                String[] split = name.split(":")[1].split("_");
                Object output = "structurize:" + (split.length > 3 ? split[3] : split[2]) + "_" + (String)(split.length > 3 ? split[1] + "_" + split[2] : split[1]) + "_paper_timber_frame";
                output = ((String)output).replace("doublecrossed", "double_crossed");
                output = ((String)output).replace("sideframed", "side_framed");
                output = ((String)output).replace("upgated", "up_gated");
                output = ((String)output).replace("downgated", "down_gated");
                output = ((String)output).replace("onecrossedlr", "one_crossed_lr");
                output = ((String)output).replace("onecrossedrl", "one_crossed_rl");
                output = ((String)output).replace("horizontalplain", "horizontal_plain");
                output = ((String)output).replace("sideframedhorizontal", "side_framed_horizontal");
                oldBlockState.m_128359_("Name", (String)output);
            } else if (name.contains("blockpaperwall") && !name.contains("_")) {
                oldBlockState.m_128359_("Name", "structurize:" + oldBlockState.m_128469_("Properties").m_128461_("variant") + "_blockpaperwall");
            }
        }
    }

    public static CompoundTag[] fixTileEntities(int oldDataVersion, ListTag tileEntitiesTag) {
        CompoundTag[] tileEntities = new CompoundTag[tileEntitiesTag.size()];
        for (short i = 0; i < tileEntities.length; i = (short)(i + 1)) {
            CompoundTag nbt = tileEntitiesTag.m_128728_((int)i);
            try {
                String id = nbt.m_128461_("id");
                if (id.contains("minecolonies")) {
                    nbt.m_128359_("id", id.toLowerCase(Locale.US));
                    nbt.m_128359_("Item", nbt.m_128461_("Item".toLowerCase(Locale.US)));
                    tileEntities[i] = nbt;
                    continue;
                }
                if (id.equals("minecraft:flower_pot") || id.equals("minecraft:noteblock")) {
                    tileEntities[i] = nbt;
                    continue;
                }
                tileEntities[i] = id.startsWith("minecraft:") ? DataFixerUtils.runDataFixer(nbt, References.f_16781_, oldDataVersion) : nbt;
                continue;
            }
            catch (Exception e) {
                tileEntities[i] = null;
                Log.getLogger().warn("Blueprint reader: something went wrong loading tile entity at position: " + i, (Throwable)e);
            }
        }
        return tileEntities;
    }

    public static CompoundTag[] fixEntities(int oldDataVersion, ListTag entitiesTag) {
        CompoundTag[] entities = new CompoundTag[entitiesTag.size()];
        for (short i = 0; i < entities.length; i = (short)(i + 1)) {
            CompoundTag nbt = entitiesTag.m_128728_((int)i);
            try {
                String id = nbt.m_128461_("id");
                entities[i] = id.startsWith("minecraft:") ? DataFixerUtils.runDataFixer(nbt, References.f_16786_, oldDataVersion) : nbt;
                continue;
            }
            catch (Exception e) {
                entities[i] = null;
                Log.getLogger().warn("Blueprint reader: something went wrong loading entity at position: " + i, (Throwable)e);
            }
        }
        return entities;
    }

    private static List<BlockPos> searchForBlockIdInBlocks(short idToCheck, short[][][] blocks) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        for (int y = 0; y < blocks.length; y = (int)((short)(y + 1))) {
            short[][] temp = blocks[y];
            for (int z = 0; z < temp.length; z = (int)((short)(z + 1))) {
                short[] temp2 = temp[z];
                for (int x = 0; x < temp2.length; x = (int)((short)(x + 1))) {
                    short id = temp2[x];
                    if (id != idToCheck) continue;
                    result.add(new BlockPos(x, y, z));
                }
            }
        }
        return result;
    }

    private static Map<Integer, BlockPos> searchForTEposInTEs(List<BlockPos> blockPosToFind, CompoundTag[] tileEntities) {
        HashMap<Integer, BlockPos> result = new HashMap<Integer, BlockPos>();
        for (int i = 0; i < tileEntities.length; ++i) {
            BlockPos bp;
            CompoundTag compound = tileEntities[i];
            if (compound == null || !blockPosToFind.contains(bp = new BlockPos(compound.m_128451_("x"), compound.m_128451_("y"), compound.m_128451_("z")))) continue;
            result.put(i, bp);
        }
        return result;
    }

    private static void teToBlockStateFix(List<BlockState> palette, short[][][] blocks, CompoundTag[] tileEntities, short paletteIndex, Function<CompoundTag, CompoundTag> dataFixer) {
        Map<Integer, BlockPos> teToReplace = BlueprintUtil.searchForTEposInTEs(BlueprintUtil.searchForBlockIdInBlocks(paletteIndex, blocks), tileEntities);
        HashMap<BlockState, Short> newBlocksToBlockId = new HashMap<BlockState, Short>();
        boolean paletteFull = false;
        palette.set(paletteIndex, null);
        for (Map.Entry<Integer, BlockPos> e : teToReplace.entrySet()) {
            short newBlockId;
            CompoundTag teCompound = tileEntities[e.getKey()];
            tileEntities[e.getKey().intValue()] = null;
            CompoundTag newBScompound = dataFixer.apply(teCompound);
            BlockState newBlockState = NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)newBScompound);
            short s = newBlockId = paletteFull ? newBlocksToBlockId.getOrDefault(newBlockState, (short)palette.size()) : paletteIndex;
            if (newBlockId == palette.size()) {
                palette.add(newBlockId, newBlockState);
                newBlocksToBlockId.put(newBlockState, newBlockId);
            } else if (!paletteFull) {
                palette.set(newBlockId, newBlockState);
                newBlocksToBlockId.put(newBlockState, newBlockId);
                paletteFull = true;
            }
            blocks[e.getValue().m_123342_()][e.getValue().m_123343_()][e.getValue().m_123341_()] = newBlockId;
        }
    }

    public static void fixCross1343(List<BlockState> palette, short[][][] blocks, CompoundTag[] tileEntities, CompoundTag[] entities) {
        short s = palette.size();
        for (short i = 0; i < s; i = (short)(i + 1)) {
            BlockState bs = palette.get(i);
            if (bs.m_60734_() == Blocks.f_50248_) {
                BlueprintUtil.teToBlockStateFix(palette, blocks, tileEntities, i, teCompound -> {
                    String type = teCompound.m_128461_("Item") + teCompound.m_128451_("Data");
                    return (CompoundTag)ChunkPalettedStorageFix.f_15048_.getOrDefault(type, (Dynamic)ChunkPalettedStorageFix.f_15048_.get("minecraft:air0")).getValue();
                });
                continue;
            }
            if (bs.m_60734_() != Blocks.f_50065_) continue;
            BlueprintUtil.teToBlockStateFix(palette, blocks, tileEntities, i, teCompound -> {
                String type = Boolean.toString(teCompound.m_128471_("powered")) + (byte)Math.min(Math.max(teCompound.m_128451_("note"), 0), 24);
                return (CompoundTag)ChunkPalettedStorageFix.f_15051_.getOrDefault(type, (Dynamic)ChunkPalettedStorageFix.f_15051_.get("false0")).getValue();
            });
        }
    }

    public static Blueprint readBlueprintFromNBT(CompoundTag nbtTag) {
        CompoundTag tag = nbtTag;
        byte version = tag.m_128445_("version");
        if (version == 1) {
            CompoundTag optionalTag;
            short sizeX = tag.m_128448_("size_x");
            short sizeY = tag.m_128448_("size_y");
            short sizeZ = tag.m_128448_("size_z");
            ArrayList<String> requiredMods = new ArrayList<String>();
            ArrayList<String> missingMods = new ArrayList<String>();
            ListTag modsList = (ListTag)tag.m_128423_("required_mods");
            int modListSize = modsList.size();
            for (int i = 0; i < modListSize; ++i) {
                requiredMods.add(modsList.get(i).m_7916_());
                if (((String)requiredMods.get(i)).equals("minecraft") || ModList.get().getModContainerById((String)requiredMods.get(i)).isPresent()) continue;
                LogManager.getLogger().warn("Found missing mods for Blueprint, some blocks may be missing: " + (String)requiredMods.get(i));
                missingMods.add((String)requiredMods.get(i));
            }
            int oldDataVersion = tag.m_128441_("mcversion") ? tag.m_128451_("mcversion") : DEFAULT_FIXER_IF_NOT_FOUND;
            ListTag paletteTag = (ListTag)tag.m_128423_("palette");
            List<BlockState> palette = BlueprintUtil.fixPalette(oldDataVersion, paletteTag);
            short[][][] blocks = BlueprintUtil.convertSaveDataToBlocks(tag.m_128465_("blocks"), sizeX, sizeY, sizeZ);
            CompoundTag[] tileEntities = BlueprintUtil.fixTileEntities(oldDataVersion, (ListTag)tag.m_128423_("tile_entities"));
            CompoundTag[] entities = BlueprintUtil.fixEntities(oldDataVersion, (ListTag)tag.m_128423_("entities"));
            if (oldDataVersion == DEFAULT_FIXER_IF_NOT_FOUND) {
                BlueprintUtil.fixCross1343(palette, blocks, tileEntities, entities);
            }
            Blueprint schem = new Blueprint(sizeX, sizeY, sizeZ, (short)palette.size(), palette, blocks, tileEntities, requiredMods).setMissingMods(missingMods.toArray(new String[0]));
            schem.setEntities(entities);
            if (tag.m_128431_().contains("name")) {
                schem.setName(tag.m_128461_("name"));
            }
            if (tag.m_128431_().contains("architects")) {
                ListTag architectsTag = (ListTag)tag.m_128423_("architects");
                String[] architects = new String[architectsTag.size()];
                for (int i = 0; i < architectsTag.size(); ++i) {
                    architects[i] = architectsTag.m_128778_(i);
                }
                schem.setArchitects(architects);
            }
            if (tag.m_128431_().contains(NBT_OPTIONAL_DATA_TAG) && (optionalTag = tag.m_128469_(NBT_OPTIONAL_DATA_TAG)).m_128431_().contains("structurize")) {
                CompoundTag structurizeTag = optionalTag.m_128469_("structurize");
                BlockPos offsetPos = BlockPosUtil.readFromNBT(structurizeTag, "primary_offset");
                schem.setCachePrimaryOffset(offsetPos);
            }
            return schem;
        }
        return null;
    }

    public static void writeToStream(OutputStream os, Blueprint schem) {
        try {
            NbtIo.m_128947_((CompoundTag)BlueprintUtil.writeBlueprintToNBT(schem), (OutputStream)os);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static int[] convertBlocksToSaveData(short[][][] multDimArray, short sizeX, short sizeY, short sizeZ) {
        int currentInt;
        short[] oneDimArray = new short[sizeX * sizeY * sizeZ];
        int j = 0;
        for (short y = 0; y < sizeY; y = (short)(y + 1)) {
            for (short z = 0; z < sizeZ; z = (short)(z + 1)) {
                for (short x = 0; x < sizeX; x = (short)(x + 1)) {
                    oneDimArray[j++] = multDimArray[y][z][x];
                }
            }
        }
        int[] ints = new int[(int)Math.ceil((float)oneDimArray.length / 2.0f)];
        for (int i = 1; i < oneDimArray.length; i += 2) {
            currentInt = oneDimArray[i - 1];
            ints[(int)Math.ceil((double)((double)((float)i / 2.0f))) - 1] = currentInt = currentInt << 16 | oneDimArray[i];
        }
        if (oneDimArray.length % 2 == 1) {
            ints[ints.length - 1] = currentInt = oneDimArray[oneDimArray.length - 1] << 16;
        }
        return ints;
    }

    public static short[][][] convertSaveDataToBlocks(int[] ints, short sizeX, short sizeY, short sizeZ) {
        short[] oneDimArray = new short[ints.length * 2];
        for (int i = 0; i < ints.length; ++i) {
            oneDimArray[i * 2] = (short)(ints[i] >> 16);
            oneDimArray[i * 2 + 1] = (short)ints[i];
        }
        short[][][] multDimArray = new short[sizeY][sizeZ][sizeX];
        int i = 0;
        for (short y = 0; y < sizeY; y = (short)(y + 1)) {
            for (short z = 0; z < sizeZ; z = (short)(z + 1)) {
                for (short x = 0; x < sizeX; x = (short)(x + 1)) {
                    multDimArray[y][z][x] = oneDimArray[i++];
                }
            }
        }
        return multDimArray;
    }
}

