/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.event;

import com.ldtteam.blockui.BOScreen;
import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.api.util.BlockPosUtil;
import com.ldtteam.structurize.api.util.IScrollableItem;
import com.ldtteam.structurize.api.util.ISpecialBlockPickItem;
import com.ldtteam.structurize.blockentities.interfaces.IBlueprintDataProviderBE;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.client.BlueprintHandler;
import com.ldtteam.structurize.client.ModKeyMappings;
import com.ldtteam.structurize.client.gui.WindowExtendedBuildTool;
import com.ldtteam.structurize.items.ItemScanTool;
import com.ldtteam.structurize.items.ModItems;
import com.ldtteam.structurize.network.messages.ItemMiddleMouseMessage;
import com.ldtteam.structurize.network.messages.ScanToolTeleportMessage;
import com.ldtteam.structurize.storage.rendering.RenderingCache;
import com.ldtteam.structurize.storage.rendering.types.BlueprintPreviewData;
import com.ldtteam.structurize.storage.rendering.types.BoxPreviewData;
import com.ldtteam.structurize.util.WorldRenderMacros;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class ClientEventSubscriber {
    @SubscribeEvent
    public static void renderWorldLastEvent(RenderGuiOverlayEvent.Pre event) {
        if ((event.getOverlay() == VanillaGuiOverlay.PLAYER_HEALTH.type() || event.getOverlay() == VanillaGuiOverlay.FOOD_LEVEL.type()) && Minecraft.m_91087_().f_91080_ instanceof BOScreen && ((BOScreen)Minecraft.m_91087_().f_91080_).getWindow() instanceof WindowExtendedBuildTool) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void renderWorldLastEvent(RenderLevelStageEvent event) {
        RenderLevelStageEvent.Stage when;
        RenderLevelStageEvent.Stage stage = when = (Double)Structurize.getConfig().getClient().rendererTransparency.get() > (double)0.99f ? RenderLevelStageEvent.Stage.AFTER_CUTOUT_MIPPED_BLOCKS_BLOCKS : RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS;
        if (event.getStage() != when) {
            return;
        }
        PoseStack matrixStack = event.getPoseStack();
        MultiBufferSource.BufferSource bufferSource = WorldRenderMacros.getBufferSource();
        Minecraft mc = Minecraft.m_91087_();
        Vec3 viewPosition = mc.f_91063_.m_109153_().m_90583_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(-viewPosition.m_7096_(), -viewPosition.m_7098_(), -viewPosition.m_7094_());
        for (BlueprintPreviewData blueprintPreviewData : RenderingCache.getBlueprintsToRender()) {
            Blueprint blueprint = blueprintPreviewData.getBlueprint();
            if (blueprint == null) continue;
            mc.m_91307_().m_6180_("struct_render");
            BlockPos pos2 = blueprintPreviewData.getPos();
            BlockPos posMinusOffset = pos2.m_121996_((Vec3i)blueprint.getPrimaryBlockOffset());
            BlueprintHandler.getInstance().draw(blueprintPreviewData, pos2, event);
            WorldRenderMacros.renderWhiteLineBox(bufferSource, matrixStack, posMinusOffset, posMinusOffset.m_7918_(blueprint.getSizeX() - 1, blueprint.getSizeY() - 1, blueprint.getSizeZ() - 1), 0.02f);
            WorldRenderMacros.renderRedGlintLineBox(bufferSource, matrixStack, pos2, pos2, 0.02f);
            mc.m_91307_().m_7238_();
        }
        for (BoxPreviewData boxPreviewData : RenderingCache.getBoxesToRender()) {
            mc.m_91307_().m_6180_("struct_box");
            WorldRenderMacros.renderWhiteLineBox(bufferSource, matrixStack, boxPreviewData.getPos1(), boxPreviewData.getPos2(), 0.02f);
            boxPreviewData.getAnchor().ifPresent(pos -> WorldRenderMacros.renderRedGlintLineBox(bufferSource, matrixStack, pos, pos, 0.02f));
            mc.m_91307_().m_7238_();
        }
        LocalPlayer player = mc.f_91074_;
        ItemStack itemStack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (itemStack.m_41720_() == ModItems.tagTool.get() && itemStack.m_41784_().m_128441_("anchorpostag")) {
            mc.m_91307_().m_6180_("struct_tags");
            BlockPos tagAnchor = BlockPosUtil.readFromNBT(itemStack.m_41783_(), "anchorpostag");
            BlockEntity te = player.m_9236_().m_7702_(tagAnchor);
            if (te instanceof IBlueprintDataProviderBE) {
                Map<BlockPos, List<String>> tagPosList = ((IBlueprintDataProviderBE)te).getWorldTagPosMap();
                for (Map.Entry<BlockPos, List<String>> entry : tagPosList.entrySet()) {
                    WorldRenderMacros.renderWhiteLineBox(bufferSource, matrixStack, entry.getKey(), entry.getKey(), 0.02f);
                    WorldRenderMacros.renderDebugText(entry.getKey(), entry.getValue(), matrixStack, true, 3, (MultiBufferSource)bufferSource);
                }
            }
            WorldRenderMacros.renderRedGlintLineBox(bufferSource, matrixStack, tagAnchor, tagAnchor, 0.02f);
            mc.m_91307_().m_7238_();
        }
        bufferSource.m_109911_();
        matrixStack.m_85849_();
    }

    @SubscribeEvent
    public static void onClientTickEvent(TickEvent.ClientTickEvent event) {
        ItemScanTool tool;
        Item item;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        mc.m_91307_().m_6180_("structurize");
        if (mc.f_91073_ != null && mc.f_91073_.m_46467_() % 300L == 0L) {
            mc.m_91307_().m_6180_("blueprint_manager_tick");
            BlueprintHandler.getInstance().cleanCache();
            mc.m_91307_().m_7238_();
        }
        if (((KeyMapping)ModKeyMappings.TELEPORT.get()).m_90859_() && mc.f_91073_ != null && mc.f_91074_ != null && (item = mc.f_91074_.m_21205_().m_41720_()) instanceof ItemScanTool && (tool = (ItemScanTool)item).onTeleport((Player)mc.f_91074_, mc.f_91074_.m_21205_())) {
            Network.getNetwork().sendToServer(new ScanToolTeleportMessage());
        }
        mc.m_91307_().m_7238_();
    }

    @SubscribeEvent
    public static void onPreClientTickEvent(@NotNull TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91080_ != null || mc.f_91073_ == null) {
            return;
        }
        if (mc.f_91066_.f_92097_.m_90859_()) {
            ItemStack current;
            Item item;
            BlockPos pos;
            BlockPos blockPos = pos = mc.f_91077_ != null && mc.f_91077_.m_6662_() == HitResult.Type.BLOCK ? ((BlockHitResult)mc.f_91077_).m_82425_() : null;
            if (pos != null && mc.f_91073_.m_8055_(pos).m_60795_()) {
                pos = null;
            }
            if ((item = (current = mc.f_91074_.m_150109_().m_36056_()).m_41720_()) instanceof ISpecialBlockPickItem) {
                ISpecialBlockPickItem clickableItem = (ISpecialBlockPickItem)item;
                boolean ctrlKey = Screen.m_96637_();
                switch (clickableItem.onBlockPick((Player)mc.f_91074_, current, pos, ctrlKey)) {
                    case PASS: {
                        ++mc.f_91066_.f_92097_.f_90818_;
                        break;
                    }
                    case FAIL: {
                        break;
                    }
                    default: {
                        Network.getNetwork().sendToServer(new ItemMiddleMouseMessage(pos, ctrlKey));
                        break;
                    }
                }
            } else {
                ++mc.f_91066_.f_92097_.f_90818_;
            }
        }
    }

    @SubscribeEvent
    public static void onMouseWheel(InputEvent.MouseScrollingEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (event.isCanceled() || mc.f_91074_ == null || mc.f_91080_ != null || mc.f_91073_ == null) {
            return;
        }
        if (!mc.f_91074_.m_6144_()) {
            return;
        }
        ItemStack current = mc.f_91074_.m_150109_().m_36056_();
        Item item = current.m_41720_();
        if (item instanceof IScrollableItem) {
            IScrollableItem scrollableItem = (IScrollableItem)item;
            boolean ctrlKey = Screen.m_96637_();
            switch (scrollableItem.onMouseScroll((Player)mc.f_91074_, current, event.getScrollDelta(), ctrlKey)) {
                case PASS: {
                    break;
                }
                case FAIL: {
                    event.setCanceled(true);
                    break;
                }
                default: {
                    event.setCanceled(true);
                    Network.getNetwork().sendToServer(new ItemMiddleMouseMessage(event.getScrollDelta(), ctrlKey));
                }
            }
        }
    }
}

