/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.entity.ImprovedProjectileEntity;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.FakePlayerManager;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.FlanCompat;
import net.mehvahdjukaar.supplementaries.reg.ModEntities;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ThrowableBrickEntity
extends ImprovedProjectileEntity {
    private static final GameProfile BRICK_PLAYER = new GameProfile(UUID.randomUUID(), "Throwable Brick Fake Player");

    public ThrowableBrickEntity(EntityType<? extends ThrowableBrickEntity> type, Level world) {
        super(type, world);
    }

    public ThrowableBrickEntity(Level worldIn, LivingEntity throwerIn) {
        super(ModEntities.THROWABLE_BRICK.get(), throwerIn, worldIn);
    }

    public ThrowableBrickEntity(Level worldIn, double x, double y, double z) {
        super(ModEntities.THROWABLE_BRICK.get(), x, y, z, worldIn);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return PlatHelper.getEntitySpawnPacket((Entity)this);
    }

    protected Item m_7881_() {
        return Items.f_42460_;
    }

    private ParticleOptions makeParticle() {
        ItemStack itemstack = this.m_37454_();
        return itemstack.m_41619_() ? new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)this.m_7881_())) : new ItemParticleOption(ParticleTypes.f_123752_, itemstack);
    }

    public void m_7822_(byte id) {
        if (id == 3) {
            ParticleOptions particle = this.makeParticle();
            for (int i = 0; i < 8; ++i) {
                this.m_9236_().m_7106_(particle, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void m_8060_(BlockHitResult rayTraceResult) {
        super.m_8060_(rayTraceResult);
        Level level = this.m_9236_();
        if (!level.f_46443_) {
            Entity entity = this.m_19749_();
            BlockPos pos = rayTraceResult.m_82425_();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (CompatHandler.FLAN && !FlanCompat.canBreak(player, pos)) {
                    return;
                }
                if (!Utils.mayBuild((Player)player, (BlockPos)pos) && !this.m_7846_().m_204128_(level.m_9598_().m_175515_(Registries.f_256747_), new BlockInWorld((LevelReader)level, pos, false))) {
                    return;
                }
            }
            if (!(entity instanceof Mob) || level.m_46469_().m_46207_(GameRules.f_46132_) || PlatHelper.isMobGriefingOn((Level)level, (Entity)this)) {
                Player p = FakePlayerManager.get((GameProfile)BRICK_PLAYER, (Level)level);
                p.m_21008_(InteractionHand.MAIN_HAND, Items.f_42385_.m_7968_());
                if (level.m_8055_(pos).m_204336_(ModTags.BRICK_BREAKABLE_POTS)) {
                    level.m_46953_(pos, true, (Entity)p);
                } else {
                    this.breakGlass(pos, 6, p);
                }
            }
        }
    }

    private void breakGlass(BlockPos pos, int chance, Player p) {
        int c = chance - 1 - this.f_19796_.m_188503_(4);
        BlockState state = this.m_9236_().m_8055_(pos);
        if (state.m_60734_().m_7325_() > 3.0f) {
            return;
        }
        if (c < 0 || !state.m_204336_(ModTags.BRICK_BREAKABLE_GLASS)) {
            return;
        }
        this.m_9236_().m_46953_(pos, true, (Entity)p);
        this.breakGlass(pos.m_7494_(), c, p);
        this.breakGlass(pos.m_7495_(), c, p);
        this.breakGlass(pos.m_122029_(), c, p);
        this.breakGlass(pos.m_122024_(), c, p);
        this.breakGlass(pos.m_122012_(), c, p);
        this.breakGlass(pos.m_122019_(), c, p);
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        super.m_5790_(entityHitResult);
        Entity entity = entityHitResult.m_82443_();
        boolean i = true;
        entity.m_6469_(this.m_9236_().m_269111_().m_269390_((Entity)this, this.m_19749_()), (float)i);
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (!this.m_9236_().f_46443_) {
            Vec3 v = result.m_82450_();
            this.m_9236_().m_6263_(null, v.f_82479_, v.f_82480_, v.f_82481_, SoundEvents.f_12160_, SoundSource.NEUTRAL, 0.75f, 1.0f);
            this.m_9236_().m_7605_((Entity)this, (byte)3);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void m_37283_() {
    }
}

