/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.common.utils;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import me.codexadrian.tempad.common.config.ConfigCache;
import me.codexadrian.tempad.common.config.TempadConfig;
import me.codexadrian.tempad.common.items.TempadItem;
import me.codexadrian.tempad.common.utils.forge.TeleportUtilsImpl;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class TeleportUtils {
    public static boolean mayTeleport(ResourceKey<Level> level, Player player) {
        if (player.m_7500_()) {
            return true;
        }
        return level.equals((Object)player.m_9236_().m_46472_()) || (player.m_9236_().m_5776_() ? ConfigCache.allowInterdimensionalTravel : TempadConfig.allowInterdimensionalTravel);
    }

    public static ItemStack findAndReplaceTempad(Player player, @Nullable ItemStack replacementTempad) {
        AtomicReference<ItemStack> tempad = new AtomicReference<ItemStack>(ItemStack.f_41583_);
        Consumer<ItemStack> setTempad = TeleportUtils.findTempadInBaubles(player, tempad::set);
        if (setTempad != null) {
            if (replacementTempad != null) {
                setTempad.accept(replacementTempad);
            }
            return tempad.get();
        }
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            Item item = stack.m_41720_();
            if (!(item instanceof TempadItem)) continue;
            TempadItem tempadItem = (TempadItem)item;
            tempad.set(stack);
            int finalI = i;
            setTempad = itemStack -> player.m_150109_().m_6836_(finalI, itemStack);
            if (tempadItem.getOption().canTimedoorOpen(player, tempad.get())) break;
        }
        if (replacementTempad != null && setTempad != null) {
            setTempad.accept(replacementTempad);
        }
        return tempad.get();
    }

    public static ItemStack findTempad(Player player) {
        return TeleportUtils.findAndReplaceTempad(player, null);
    }

    public static boolean hasTempad(Player player) {
        return !TeleportUtils.findTempad(player).m_41619_();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @Nullable
    @ExpectPlatform.Transformed
    public static Consumer<ItemStack> findTempadInBaubles(Player player, Consumer<ItemStack> setTempad) {
        void var1_1;
        return TeleportUtilsImpl.findTempadInBaubles(player, (Consumer<ItemStack>)var1_1);
    }
}

