/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.mercurycatalyst;

import com.klikli_dev.theurgy.content.apparatus.mercurycatalyst.MercuryCatalystCraftingBehaviour;
import com.klikli_dev.theurgy.content.behaviour.CraftingBehaviour;
import com.klikli_dev.theurgy.content.capability.DefaultMercuryFluxStorage;
import com.klikli_dev.theurgy.content.capability.MercuryFluxStorage;
import com.klikli_dev.theurgy.content.storage.MonitoredItemStackHandler;
import com.klikli_dev.theurgy.registry.BlockEntityRegistry;
import com.klikli_dev.theurgy.registry.CapabilityRegistry;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MercuryCatalystBlockEntity
extends BlockEntity {
    public static final int CAPACITY = 50000;
    public static final int PUSH_TICK_INTERVAL = 20;
    public static final int PUSH_RATE_PER_TICK = 2;
    public ItemStackHandler inventory = new Inventory();
    public MercuryCatalystMercuryFluxStorage mercuryFluxStorage;
    public LazyOptional<IItemHandler> inventoryCapability = LazyOptional.of(() -> this.inventory);
    public LazyOptional<MercuryFluxStorage> mercuryFluxStorageCapability;
    protected CraftingBehaviour<?, ?, ?> craftingBehaviour;

    public MercuryCatalystBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityRegistry.MERCURY_CATALYST.get(), pPos, pBlockState);
        this.mercuryFluxStorage = new MercuryCatalystMercuryFluxStorage(50000);
        this.mercuryFluxStorageCapability = LazyOptional.of(() -> this.mercuryFluxStorage);
        this.craftingBehaviour = new MercuryCatalystCraftingBehaviour(this, () -> this.inventory, () -> this.inventory, () -> this.mercuryFluxStorage);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.writeNetwork(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.readNetwork(tag);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet) {
        CompoundTag tag = packet.m_131708_();
        if (tag != null) {
            this.readNetwork(tag);
        }
    }

    public void readNetwork(CompoundTag tag) {
        if (tag.m_128441_("mercuryFluxStorage")) {
            this.mercuryFluxStorage.deserializeNBT(tag.m_128423_("mercuryFluxStorage"));
            if (this.f_58857_ != null) {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 8);
            }
        }
    }

    public void writeNetwork(CompoundTag tag) {
        tag.m_128365_("mercuryFluxStorage", this.mercuryFluxStorage.serializeNBT());
    }

    public void sendBlockUpdated() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public void tickServer() {
        boolean hasInput = !this.inventory.getStackInSlot(0).m_41619_();
        this.craftingBehaviour.tickServer(true, hasInput);
        if (this.m_58904_().m_46467_() % 20L == 0L && ((Boolean)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61431_)).booleanValue()) {
            this.pushMercuryFlux();
        }
    }

    protected void pushMercuryFlux() {
        Collection directions = Direction.m_235667_((RandomSource)this.m_58904_().m_213780_());
        for (Direction direction : directions) {
            MercuryFluxStorage fluxStorage;
            if (this.mercuryFluxStorage.getEnergyStored() <= 0) break;
            BlockEntity blockEntity = this.m_58904_().m_7702_(this.m_58899_().m_121945_(direction));
            if (blockEntity == null || (fluxStorage = (MercuryFluxStorage)blockEntity.getCapability(CapabilityRegistry.MERCURY_FLUX).orElse(null)) == null) continue;
            int energy = this.mercuryFluxStorage.extractEnergy(40, true);
            int received = fluxStorage.receiveEnergy(energy, false);
            this.mercuryFluxStorage.extractEnergy(received, false);
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryCapability.cast();
        }
        if (cap == CapabilityRegistry.MERCURY_FLUX) {
            return this.mercuryFluxStorageCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inventoryCapability.invalidate();
        this.mercuryFluxStorageCapability.invalidate();
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
        pTag.m_128365_("mercuryFluxStorage", this.mercuryFluxStorage.serializeNBT());
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_("inventory")) {
            this.inventory.deserializeNBT(pTag.m_128469_("inventory"));
        }
        if (pTag.m_128441_("mercuryFluxStorage")) {
            this.mercuryFluxStorage.deserializeNBT(pTag.m_128423_("mercuryFluxStorage"));
        }
    }

    private class Inventory
    extends MonitoredItemStackHandler {
        public Inventory() {
            super(1);
        }

        @Override
        protected void onContentTypeChanged(int slot, ItemStack oldStack, ItemStack newStack) {
            MercuryCatalystBlockEntity.this.craftingBehaviour.onInputItemChanged(oldStack, newStack);
            MercuryCatalystBlockEntity.this.sendBlockUpdated();
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return MercuryCatalystBlockEntity.this.craftingBehaviour.canProcess(stack) && super.isItemValid(slot, stack);
        }

        protected void onContentsChanged(int slot) {
            MercuryCatalystBlockEntity.this.m_6596_();
        }
    }

    public class MercuryCatalystMercuryFluxStorage
    extends DefaultMercuryFluxStorage {
        public static final int UPDATE_THRESHOLD = 100;
        private int lastUpdateLevel;

        public MercuryCatalystMercuryFluxStorage(int capacity) {
            super(capacity);
        }

        @Override
        public int receiveEnergy(int maxReceive, boolean simulate) {
            int received = super.receiveEnergy(maxReceive, simulate);
            if (received > 0) {
                MercuryCatalystBlockEntity.this.m_6596_();
                this.trySendBlockUpdated();
            }
            return received;
        }

        @Override
        public int extractEnergy(int maxExtract, boolean simulate) {
            int extracted = super.extractEnergy(maxExtract, simulate);
            if (extracted > 0) {
                MercuryCatalystBlockEntity.this.m_6596_();
                this.trySendBlockUpdated();
            }
            return extracted;
        }

        public void trySendBlockUpdated() {
            int currentLevel = this.getEnergyStored();
            if (Math.abs(this.lastUpdateLevel - currentLevel) > 100) {
                this.lastUpdateLevel = currentLevel;
                MercuryCatalystBlockEntity.this.sendBlockUpdated();
            }
        }
    }
}

