/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.item.render;

import com.klikli_dev.theurgy.config.ClientConfig;
import com.klikli_dev.theurgy.content.item.AlchemicalSulfurItem;
import com.klikli_dev.theurgy.content.item.AlchemicalSulfurTier;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class AlchemicalSulfurBEWLR
extends BlockEntityWithoutLevelRenderer {
    private static final AlchemicalSulfurBEWLR instance = new AlchemicalSulfurBEWLR();
    private static final ItemStack labeledEmptyJarStack = new ItemStack((ItemLike)ItemRegistry.EMPTY_JAR_LABELED_ICON.get());
    private static final ItemStack labelStack = new ItemStack((ItemLike)ItemRegistry.JAR_LABEL_ICON.get());
    private static final Map<AlchemicalSulfurTier, ItemStack> tierToIconMap = Map.of(AlchemicalSulfurTier.ABUNDANT, new ItemStack((ItemLike)ItemRegistry.JAR_LABEL_FRAME_ABUNDANT_ICON.get()), AlchemicalSulfurTier.COMMON, new ItemStack((ItemLike)ItemRegistry.JAR_LABEL_FRAME_COMMON_ICON.get()), AlchemicalSulfurTier.RARE, new ItemStack((ItemLike)ItemRegistry.JAR_LABEL_FRAME_RARE_ICON.get()), AlchemicalSulfurTier.PRECIOUS, new ItemStack((ItemLike)ItemRegistry.JAR_LABEL_FRAME_PRECIOUS_ICON.get()));

    public AlchemicalSulfurBEWLR() {
        super(null, null);
    }

    public static AlchemicalSulfurBEWLR get() {
        return instance;
    }

    private static boolean isLeftHand(ItemDisplayContext displayContext) {
        return displayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || displayContext == ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
    }

    public void m_108829_(ItemStack sulfurStack, ItemDisplayContext displayContext, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        boolean flatLighting;
        Boolean renderSource = (Boolean)ClientConfig.get().rendering.renderSulfurSourceItem.get();
        ItemStack jarStack = renderSource != false ? AlchemicalSulfurItem.getEmptyJarStack(sulfurStack) : labeledEmptyJarStack;
        pPoseStack.m_85849_();
        pPoseStack.m_85836_();
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        if (displayContext == ItemDisplayContext.GUI && Screen.m_96638_()) {
            this.renderContainedItemFull(sulfurStack, displayContext, pPoseStack, pBuffer, pPackedLight, pPackedOverlay);
            return;
        }
        BakedModel model = itemRenderer.m_174264_(jarStack, null, null, 0);
        boolean bl = flatLighting = displayContext == ItemDisplayContext.GUI && !model.m_7547_();
        if (flatLighting) {
            Lighting.m_84930_();
        }
        itemRenderer.m_115143_(jarStack, displayContext, AlchemicalSulfurBEWLR.isLeftHand(displayContext), pPoseStack, pBuffer, pPackedLight, pPackedOverlay, model);
        this.renderLabelFrame(sulfurStack, displayContext, pPoseStack, pBuffer, pPackedLight, pPackedOverlay);
        if (renderSource.booleanValue()) {
            this.renderLabel(sulfurStack, displayContext, pPoseStack, pBuffer, pPackedLight, pPackedOverlay);
            this.renderContainedItem(sulfurStack, displayContext, pPoseStack, pBuffer, pPackedLight, pPackedOverlay);
        }
    }

    public void renderLabelFrame(ItemStack sulfurStack, ItemDisplayContext displayContext, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        ItemStack tierStack = tierToIconMap.get((Object)AlchemicalSulfurItem.getTier(sulfurStack));
        BakedModel labelModel = itemRenderer.m_174264_(tierStack, null, null, 0);
        pPoseStack.m_85836_();
        labelModel.applyTransform(displayContext, pPoseStack, AlchemicalSulfurBEWLR.isLeftHand(displayContext));
        pPoseStack.m_85836_();
        float pixel = 0.0625f;
        pPoseStack.m_85837_(0.0, 0.0, (double)pixel * 0.5);
        pPoseStack.m_85841_(1.0f, 1.0f, 0.01f);
        Lighting.m_84930_();
        itemRenderer.m_115143_(tierStack, ItemDisplayContext.GUI, AlchemicalSulfurBEWLR.isLeftHand(displayContext), pPoseStack, pBuffer, pPackedLight, pPackedOverlay, labelModel);
        pPoseStack.m_85849_();
        pPoseStack.m_85849_();
    }

    public void renderLabel(ItemStack sulfurStack, ItemDisplayContext displayContext, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        BakedModel labelModel = itemRenderer.m_174264_(labelStack, null, null, 0);
        pPoseStack.m_85836_();
        labelModel.applyTransform(displayContext, pPoseStack, AlchemicalSulfurBEWLR.isLeftHand(displayContext));
        pPoseStack.m_85836_();
        float pixel = 0.0625f;
        pPoseStack.m_85837_(0.0, 0.0, (double)pixel * 0.5);
        pPoseStack.m_85841_(1.0f, 1.0f, 0.01f);
        Lighting.m_84930_();
        itemRenderer.m_115143_(labelStack, ItemDisplayContext.GUI, AlchemicalSulfurBEWLR.isLeftHand(displayContext), pPoseStack, pBuffer, pPackedLight, pPackedOverlay, labelModel);
        pPoseStack.m_85849_();
        pPoseStack.m_85849_();
    }

    public void renderContainedItem(ItemStack sulfurStack, ItemDisplayContext pTransformType, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        ItemStack containedStack = AlchemicalSulfurItem.getSourceStack(sulfurStack);
        if (!containedStack.m_41619_()) {
            BakedModel containedModel = itemRenderer.m_174264_(containedStack, null, null, 0);
            BakedModel labelModel = itemRenderer.m_174264_(labelStack, null, null, 0);
            pPoseStack.m_85836_();
            labelModel.applyTransform(pTransformType, pPoseStack, AlchemicalSulfurBEWLR.isLeftHand(pTransformType));
            pPoseStack.m_85836_();
            float pixel = 0.0625f;
            pPoseStack.m_85837_(0.0, 0.0, (double)pixel * 0.6);
            float scale = 0.36f;
            pPoseStack.m_85841_(scale, scale, scale);
            pPoseStack.m_85837_(0.0, (double)(-pixel) * 3.2, 0.0);
            pPoseStack.m_85841_(0.74f, 0.74f, 0.01f);
            Lighting.m_84930_();
            itemRenderer.m_115143_(containedStack, ItemDisplayContext.GUI, AlchemicalSulfurBEWLR.isLeftHand(pTransformType), pPoseStack, pBuffer, pPackedLight, pPackedOverlay, containedModel);
            pPoseStack.m_85849_();
            pPoseStack.m_85849_();
        }
    }

    public void renderContainedItemFull(ItemStack sulfurStack, ItemDisplayContext pTransformType, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        ItemStack containedStack = AlchemicalSulfurItem.getSourceStack(sulfurStack);
        if (!containedStack.m_41619_()) {
            boolean flatLighting;
            BakedModel model = itemRenderer.m_174264_(containedStack, null, null, 0);
            boolean bl = flatLighting = !model.m_7547_();
            if (flatLighting) {
                Lighting.m_84930_();
            }
            itemRenderer.m_115143_(containedStack, ItemDisplayContext.GUI, AlchemicalSulfurBEWLR.isLeftHand(ItemDisplayContext.GUI), pPoseStack, pBuffer, pPackedLight, pPackedOverlay, model);
        }
    }
}

