/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.theurgy.Theurgy;
import com.klikli_dev.theurgy.config.ServerConfig;
import com.klikli_dev.theurgy.registry.RecipeSerializerRegistry;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class DivinationRodRecipe
extends ShapedRecipe {
    public DivinationRodRecipe(ResourceLocation pId, String pGroup, int pWidth, int pHeight, NonNullList<Ingredient> pRecipeItems, ItemStack pResult) {
        super(pId, pGroup, CraftingBookCategory.MISC, pWidth, pHeight, pRecipeItems, pResult);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializerRegistry.DIVINATION_ROD.get();
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        ItemStack result = super.m_8043_(registryAccess);
        CompoundTag resultTag = result.m_41784_();
        if (!resultTag.m_128441_("theurgy:divination.linked_block_id")) {
            String sourceId = null;
            for (Ingredient ingredient : this.m_7527_()) {
                CompoundTag ingredientTag;
                JsonObject jsonObj;
                JsonElement json = ingredient.m_43942_();
                if (!(json instanceof JsonObject) || !(jsonObj = (JsonObject)json).has("nbt") || !(ingredientTag = CraftingHelper.getNBT((JsonElement)jsonObj.get("nbt"))).m_128441_("theurgy:sulfur.source.id")) continue;
                sourceId = ingredientTag.m_128461_("theurgy:sulfur.source.id");
                break;
            }
            if (sourceId != null) {
                String translated = this.translateToBlock(sourceId);
                if (translated != null) {
                    resultTag.m_128359_("theurgy:divination.linked_block_id", translated);
                } else {
                    resultTag.m_128359_("theurgy:divination.linked_block_id", sourceId);
                }
                resultTag.m_128379_("theurgy:divination.linked_block_id.preview_mode", true);
            }
        }
        return result;
    }

    public ItemStack m_5874_(CraftingContainer pInv, RegistryAccess registryAccess) {
        ItemStack result = this.m_8043_(registryAccess).m_41777_();
        CompoundTag resultTag = result.m_41784_();
        if (!resultTag.m_128441_("theurgy:divination.linked_block_id") || resultTag.m_128471_("theurgy:divination.linked_block_id.preview_mode")) {
            String sourceId = null;
            for (int i = 0; i < pInv.m_6643_(); ++i) {
                CompoundTag tag;
                ItemStack stack = pInv.m_8020_(i);
                if (!stack.m_41782_() || !(tag = stack.m_41783_()).m_128441_("theurgy:sulfur.source.id")) continue;
                sourceId = tag.m_128461_("theurgy:sulfur.source.id");
                break;
            }
            if (sourceId != null) {
                String translated;
                String string = translated = sourceId.startsWith("#") ? this.translateTagToBlock(sourceId) : this.translateToBlock(sourceId);
                if (translated != null) {
                    resultTag.m_128359_("theurgy:divination.linked_block_id", translated);
                } else {
                    resultTag.m_128359_("theurgy:divination.linked_block_id", sourceId);
                }
            }
        }
        return result;
    }

    public String translateTagToBlock(String sourceTag) {
        String path;
        String mapped = (String)((Map)ServerConfig.get().recipes.sulfurSourceToBlockMapping.get()).get(sourceTag);
        if (mapped != null) {
            return mapped;
        }
        if (sourceTag.equals("#minecraft:coals")) {
            return "#forge:ores/coal";
        }
        String[] parts = sourceTag.split(":");
        String namespace = parts[0];
        String translatedPath = path = parts[1];
        if (path.contains("ingots/")) {
            translatedPath = path.replace("ingots/", "ores/");
        } else if (path.contains("nuggets/")) {
            translatedPath = path.replace("nuggets/", "ores/");
        } else if (path.contains("raw_materials/")) {
            translatedPath = path.replace("raw_materials/", "ores/");
        } else if (path.contains("dusts/")) {
            translatedPath = path.replace("dusts/", "ores/");
        } else if (path.contains("storage_blocks/")) {
            translatedPath = translatedPath.replace("storage_blocks/", "ores/");
        } else if (path.contains("gems/")) {
            translatedPath = translatedPath.replace("gems/", "ores/");
        }
        ResourceLocation translatedTag = new ResourceLocation(namespace.substring(1) + ":" + translatedPath);
        if (ForgeRegistries.BLOCKS.tags().getTag(TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)translatedTag)).isBound()) {
            return "#" + translatedTag;
        }
        Theurgy.LOGGER.warn("Could not find an appropriate block tag for sulfur source ttag: " + sourceTag + ", tried tag: #" + translatedTag);
        return null;
    }

    public String translateToBlock(String sourceId) {
        Optional<ResourceLocation> fallback;
        String mapped = (String)((Map)ServerConfig.get().recipes.sulfurSourceToBlockMapping.get()).get(sourceId);
        if (mapped != null) {
            return mapped;
        }
        String[] parts = sourceId.split(":");
        String namespace = parts[0];
        String path = parts[1];
        Object translatedPath = path;
        if (path.contains("raw_")) {
            translatedPath = path.replace("raw_", "");
        } else if (path.contains("_nugget")) {
            translatedPath = path.replace("_nugget", "");
        } else if (path.contains("_ingot")) {
            translatedPath = path.replace("_ingot", "");
        } else if (path.contains("_ore")) {
            translatedPath = path.replace("_ore", "");
            if (path.contains("deepslate_")) {
                translatedPath = ((String)translatedPath).replace("deepslate_", "");
            }
        } else if (path.contains("_dust")) {
            translatedPath = path.replace("_dust", "");
        } else if (path.contains("_block")) {
            translatedPath = path.replace("_block", "");
        }
        translatedPath = (String)translatedPath + "_ore";
        ResourceLocation translatedRL = new ResourceLocation(namespace + ":" + (String)translatedPath);
        if (ForgeRegistries.BLOCKS.containsKey(translatedRL)) {
            return translatedRL.toString();
        }
        if (!ForgeRegistries.BLOCKS.containsKey(translatedRL) && (fallback = ForgeRegistries.BLOCKS.getKeys().stream().filter(x -> x.m_135815_().equals(translatedRL.m_135815_())).findFirst()).isPresent()) {
            return fallback.get().toString();
        }
        Theurgy.LOGGER.warn("Could not find an appropriate block for sulfur source id: " + sourceId + ", tried path: " + (String)translatedPath);
        return null;
    }

    public static class Serializer
    implements RecipeSerializer<DivinationRodRecipe> {
        public DivinationRodRecipe fromJson(ResourceLocation pRecipeId, JsonObject pJson) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)RecipeSerializer.f_44076_.m_6729_(pRecipeId, pJson);
            return new DivinationRodRecipe(pRecipeId, shapedRecipe.m_6076_(), shapedRecipe.m_44220_(), shapedRecipe.m_44221_(), (NonNullList<Ingredient>)shapedRecipe.m_7527_(), shapedRecipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_));
        }

        public DivinationRodRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)RecipeSerializer.f_44076_.m_8005_(pRecipeId, pBuffer);
            return new DivinationRodRecipe(pRecipeId, shapedRecipe.m_6076_(), shapedRecipe.m_44220_(), shapedRecipe.m_44221_(), (NonNullList<Ingredient>)shapedRecipe.m_7527_(), shapedRecipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_));
        }

        public void toNetwork(FriendlyByteBuf pBuffer, DivinationRodRecipe pRecipe) {
            RecipeSerializer.f_44076_.m_6178_(pBuffer, (Recipe)pRecipe);
        }
    }
}

