/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.storage;

import java.util.function.Predicate;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class MonitoredFluidTank
extends FluidTank {
    public MonitoredFluidTank(int capacity) {
        super(capacity);
    }

    public MonitoredFluidTank(int capacity, Predicate<FluidStack> validator) {
        super(capacity, validator);
    }

    protected void onContentTypeChanged(FluidStack oldStack, FluidStack newStack) {
    }

    protected void onSetFluid(FluidStack oldStack, FluidStack newStack, boolean isSameFluid) {
    }

    protected void onFill(FluidStack oldStack, FluidStack newStack, FluidStack toInsert, int accepted, int remainingInSource) {
    }

    protected void onDrain(FluidStack oldStack, FluidStack newStack, FluidStack extracted) {
    }

    public int fill(FluidStack toInsert, IFluidHandler.FluidAction action) {
        if (action != IFluidHandler.FluidAction.SIMULATE) {
            FluidStack oldStack = this.getFluid().copy();
            int accepted = super.fill(toInsert, action);
            FluidStack newStack = this.getFluid();
            this.onFill(oldStack, newStack, toInsert, accepted, toInsert.getAmount() - accepted);
            if (oldStack.getFluid() != newStack.getFluid() || oldStack.isEmpty() != newStack.isEmpty()) {
                this.onContentTypeChanged(oldStack, newStack);
            }
            return accepted;
        }
        return super.fill(toInsert, action);
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (action != IFluidHandler.FluidAction.SIMULATE) {
            FluidStack oldStack = this.getFluid().copy();
            FluidStack extracted = super.drain(resource, action);
            FluidStack newStack = this.getFluid();
            this.onDrain(oldStack, newStack, extracted);
            if (oldStack.getFluid() != newStack.getFluid() || oldStack.isEmpty() != newStack.isEmpty()) {
                this.onContentTypeChanged(oldStack, newStack);
            }
            return extracted;
        }
        return super.drain(resource, action);
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (action != IFluidHandler.FluidAction.SIMULATE) {
            FluidStack oldStack = this.getFluid().copy();
            FluidStack extracted = super.drain(maxDrain, action);
            FluidStack newStack = this.getFluid();
            this.onDrain(oldStack, newStack, extracted);
            if (oldStack.getFluid() != newStack.getFluid() || oldStack.isEmpty() != newStack.isEmpty()) {
                this.onContentTypeChanged(oldStack, newStack);
            }
            return extracted;
        }
        return super.drain(maxDrain, action);
    }

    public void setFluid(FluidStack newStack) {
        FluidStack oldStack = this.getFluid();
        boolean sameFluid = newStack.isFluidEqual(oldStack);
        super.setFluid(newStack);
        this.onSetFluid(oldStack, newStack, sameFluid);
        if (!sameFluid || oldStack.isEmpty() != newStack.isEmpty()) {
            this.onContentTypeChanged(oldStack, newStack);
        }
    }
}

