/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.book.gettingstarted.reformation;

import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.EntryProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.klikli_dev.theurgy.registry.SulfurRegistry;
import com.mojang.datafixers.util.Pair;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;

public class ConvertWithinTypeAndTierEntry
extends EntryProvider {
    public static final String ENTRY_ID = "convert_within_type_and_tier";

    public ConvertWithinTypeAndTierEntry(CategoryProvider parent) {
        super(parent);
    }

    protected void generatePages() {
        this.page("intro", () -> BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build());
        this.pageTitle("Reformation");
        this.pageText("The core of every replication process is the reformation of Sulfur. Sulfur represents the \"Soul\" of matter, so to transform matter one needs to transform sulfur.\n\\\n\\\nAs already discussed, sulfur is of limited malleability, making it hard to transform.\n");
        this.page("possibilities", () -> BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build());
        this.pageTitle("Overcoming Limitations");
        this.pageText("However, even without further processing, Sulfur can be transformed into another type of Sulfur, if it is sufficiently similar.\n\\\n\\\nSpecifically it seems that Sulfurs that are of the same type (such as \"gem\") and tier (such as \"precious\") can be transformed into each other.\n");
        this.page("further_research", () -> BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build());
        this.pageTitle("Further Research");
        this.pageText("The transformation of Sulfur into other types or tiers, such as the legendary conversion of lower grade metals into gold, is more advanced. This book will cover those processes after you have mastered the basics of reformation.\n");
        this.page("theory", () -> BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build());
        this.pageTitle("Theoretical Underpinnings");
        this.pageText("This Reformation of one sulfur into the other can be achieved by the application of Sulfuric Flux. This is a type of Mercury flux that has been infused with the essence of one type of Sulfur, allowing it to transform other Sulfur it gets in contact with into the same type.\n");
        this.page("reassembly", () -> BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build());
        this.pageTitle("Reassembly");
        this.pageText("Once the desired Sulfur has been produced, {0}, specifically the {1} can be used to reassemble the matter into the desired form.\n", new Object[]{this.entryLink("Spagyrics", "apparatus", "spagyrics"), this.entryLink("Incubator", "apparatus", "incubator")});
        this.page("instructions", () -> BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build());
        this.pageTitle("Instructions");
        this.pageText("The following entries will guide you through the conversion of {0} into {1}, *assuming you already obtained at least one Sulfur of each*.\n", new Object[]{this.itemLink("Alchemical Sulfur: Lapis", (ItemLike)SulfurRegistry.LAPIS.get()), this.itemLink("Alchemical Sulfur: Quartz", (ItemLike)SulfurRegistry.QUARTZ.get())});
        this.page("instructions2", () -> BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build());
        this.pageTitle("Instructions");
        this.pageText("The instructions apply equally to all other reformation recipes within the same type and tier, such as {0} to {1}.\n", new Object[]{this.itemLink("Alchemical Sulfur: Diamond", (ItemLike)SulfurRegistry.DIAMOND.get()), this.itemLink("Alchemical Sulfur: Emerald", (ItemLike)SulfurRegistry.EMERALD.get())});
    }

    protected String entryName() {
        return "Replication by Reformation";
    }

    protected String entryDescription() {
        return "Obtaining more of an item by converting items of the same type and tier";
    }

    protected Pair<Integer, Integer> entryBackground() {
        return Pair.of((Object)0, (Object)2);
    }

    protected BookIconModel entryIcon() {
        return BookIconModel.create((ResourceLocation)this.modLoc("textures/gui/book/convert_items_rare.png"));
    }

    protected String entryId() {
        return ENTRY_ID;
    }
}

