/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.theurgy.datagen.recipe.JsonRecipeProvider;
import com.klikli_dev.theurgy.registry.ItemTagRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import com.klikli_dev.theurgy.registry.SulfurRegistry;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.Tags;

public class FermentationRecipeProvider
extends JsonRecipeProvider {
    public static final int TIME = 200;

    public FermentationRecipeProvider(PackOutput packOutput) {
        super(packOutput, "theurgy", "fermentation");
    }

    @Override
    void buildRecipes(BiConsumer<ResourceLocation, JsonObject> recipeConsumer) {
        this.makeRecipesForCropTag(ItemTagRegistry.SUGAR);
        this.makeRecipesForCropTag((TagKey<Item>)Tags.Items.CROPS);
    }

    public void makeRecipesForCropTag(TagKey<Item> cropTag) {
        this.makeRecipe((Fluid)Fluids.f_76193_, 125, List.of(ItemTagRegistry.ALCHEMICAL_SULFURS_GEMS_ABUNDANT, cropTag), (Item)SulfurRegistry.GEMS_ABUNDANT.get(), 1, 200, "_using_" + this.name(cropTag));
        this.makeRecipe((Fluid)Fluids.f_76193_, 250, List.of(ItemTagRegistry.ALCHEMICAL_SULFURS_GEMS_COMMON, cropTag), (Item)SulfurRegistry.GEMS_COMMON.get(), 1, 200, "_using_" + this.name(cropTag));
        this.makeRecipe((Fluid)Fluids.f_76193_, 500, List.of(ItemTagRegistry.ALCHEMICAL_SULFURS_GEMS_RARE, cropTag), (Item)SulfurRegistry.GEMS_RARE.get(), 1, 200, "_using_" + this.name(cropTag));
        this.makeRecipe((Fluid)Fluids.f_76193_, 1000, List.of(ItemTagRegistry.ALCHEMICAL_SULFURS_GEMS_PRECIOUS, cropTag), (Item)SulfurRegistry.GEMS_PRECIOUS.get(), 1, 200, "_using_" + this.name(cropTag));
        this.makeRecipe((Fluid)Fluids.f_76193_, 125, List.of(ItemTagRegistry.ALCHEMICAL_SULFURS_METALS_ABUNDANT, cropTag), (Item)SulfurRegistry.METALS_ABUNDANT.get(), 1, 200, "_using_" + this.name(cropTag));
        this.makeRecipe((Fluid)Fluids.f_76193_, 250, List.of(ItemTagRegistry.ALCHEMICAL_SULFURS_METALS_COMMON, cropTag), (Item)SulfurRegistry.METALS_COMMON.get(), 1, 200, "_using_" + this.name(cropTag));
        this.makeRecipe((Fluid)Fluids.f_76193_, 500, List.of(ItemTagRegistry.ALCHEMICAL_SULFURS_METALS_RARE, cropTag), (Item)SulfurRegistry.METALS_RARE.get(), 1, 200, "_using_" + this.name(cropTag));
        this.makeRecipe((Fluid)Fluids.f_76193_, 1000, List.of(ItemTagRegistry.ALCHEMICAL_SULFURS_METALS_PRECIOUS, cropTag), (Item)SulfurRegistry.METALS_PRECIOUS.get(), 1, 200, "_using_" + this.name(cropTag));
        this.makeRecipe((Fluid)Fluids.f_76193_, 125, List.of(ItemTagRegistry.ALCHEMICAL_SULFURS_OTHER_MINERALS_ABUNDANT, cropTag), (Item)SulfurRegistry.OTHER_MINERALS_ABUNDANT.get(), 1, 200, "_using_" + this.name(cropTag));
        this.makeRecipe((Fluid)Fluids.f_76193_, 250, List.of(ItemTagRegistry.ALCHEMICAL_SULFURS_OTHER_MINERALS_COMMON, cropTag), (Item)SulfurRegistry.OTHER_MINERALS_COMMON.get(), 1, 200, "_using_" + this.name(cropTag));
        this.makeRecipe((Fluid)Fluids.f_76193_, 500, List.of(ItemTagRegistry.ALCHEMICAL_SULFURS_OTHER_MINERALS_RARE, cropTag), (Item)SulfurRegistry.OTHER_MINERALS_RARE.get(), 1, 200, "_using_" + this.name(cropTag));
        this.makeRecipe((Fluid)Fluids.f_76193_, 1000, List.of(ItemTagRegistry.ALCHEMICAL_SULFURS_OTHER_MINERALS_PRECIOUS, cropTag), (Item)SulfurRegistry.OTHER_MINERALS_PRECIOUS.get(), 1, 200, "_using_" + this.name(cropTag));
    }

    public void makeRecipe(Fluid fluid, int fluidAmount, List<TagKey<Item>> ingredients, Item result, int resultCount, int time) {
        this.makeRecipe(this.name(result), fluid, fluidAmount, ingredients, result, resultCount, time);
    }

    public void makeRecipe(Fluid fluid, int fluidAmount, List<TagKey<Item>> ingredients, Item result, int resultCount, int time, String postFix) {
        this.makeRecipe(this.name(result) + postFix, fluid, fluidAmount, ingredients, result, resultCount, time);
    }

    public void makeRecipe(String name, Fluid fluid, int fluidAmount, List<TagKey<Item>> ingredients, Item result, int resultCount, int time) {
        JsonObject recipe = this.makeRecipeJson(this.makeFluidTagIngredient(this.locFor(fluid)), fluidAmount, ingredients.stream().map(i -> this.makeTagIngredient(this.locFor((TagKey<Item>)i))).toList(), this.makeItemStackCodecResult(this.locFor((ItemLike)result), resultCount), time);
        JsonArray conditions = new JsonArray();
        for (TagKey<Item> ingredient : ingredients) {
            conditions.add((JsonElement)this.makeTagNotEmptyCondition(ingredient.f_203868_().toString()));
        }
        recipe.add("conditions", (JsonElement)conditions);
        this.recipeConsumer.accept(this.modLoc(name), recipe);
    }

    public JsonObject makeRecipeJson(JsonObject fluid, int fluidAmount, List<JsonObject> ingredients, JsonObject result, int time) {
        JsonArray ingredientsArray = new JsonArray();
        for (JsonObject ingredient : ingredients) {
            ingredientsArray.add((JsonElement)ingredient);
        }
        JsonObject recipe = new JsonObject();
        recipe.addProperty("type", RecipeTypeRegistry.FERMENTATION.getId().toString());
        recipe.add("fluid", (JsonElement)fluid);
        recipe.addProperty("fluidAmount", (Number)fluidAmount);
        recipe.add("ingredients", (JsonElement)ingredientsArray);
        recipe.add("result", (JsonElement)result);
        recipe.addProperty("time", (Number)time);
        return recipe;
    }

    public String m_6055_() {
        return "Fermentation Recipes";
    }
}

