/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.registry;

import com.google.common.base.Suppliers;
import com.klikli_dev.theurgy.content.item.AlchemicalSulfurItem;
import com.klikli_dev.theurgy.content.item.AlchemicalSulfurTier;
import com.klikli_dev.theurgy.content.item.AlchemicalSulfurType;
import com.klikli_dev.theurgy.content.recipe.LiquefactionRecipe;
import com.klikli_dev.theurgy.registry.CreativeModeTabRegistry;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import com.klikli_dev.theurgy.util.LevelUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class SulfurRegistry {
    public static final DeferredRegister<Item> SULFURS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"theurgy");
    public static final RegistryObject<AlchemicalSulfurItem> GENERIC = SulfurRegistry.registerWithTagSourceNameOverride("generic", AlchemicalSulfurTier.ABUNDANT, AlchemicalSulfurType.MISC);
    public static final RegistryObject<AlchemicalSulfurItem> GEMS_ABUNDANT = SulfurRegistry.registerNiter("gems_abundant", ItemRegistry.GEMS_ABUNDANT_ICON, AlchemicalSulfurTier.ABUNDANT);
    public static final RegistryObject<AlchemicalSulfurItem> GEMS_COMMON = SulfurRegistry.registerNiter("gems_common", ItemRegistry.GEMS_COMMON_ICON, AlchemicalSulfurTier.COMMON);
    public static final RegistryObject<AlchemicalSulfurItem> GEMS_RARE = SulfurRegistry.registerNiter("gems_rare", ItemRegistry.GEMS_RARE_ICON, AlchemicalSulfurTier.RARE);
    public static final RegistryObject<AlchemicalSulfurItem> GEMS_PRECIOUS = SulfurRegistry.registerNiter("gems_precious", ItemRegistry.GEMS_PRECIOUS_ICON, AlchemicalSulfurTier.PRECIOUS);
    public static final RegistryObject<AlchemicalSulfurItem> METALS_ABUNDANT = SulfurRegistry.registerNiter("metals_abundant", ItemRegistry.METALS_ABUNDANT_ICON, AlchemicalSulfurTier.ABUNDANT);
    public static final RegistryObject<AlchemicalSulfurItem> METALS_COMMON = SulfurRegistry.registerNiter("metals_common", ItemRegistry.METALS_COMMON_ICON, AlchemicalSulfurTier.COMMON);
    public static final RegistryObject<AlchemicalSulfurItem> METALS_RARE = SulfurRegistry.registerNiter("metals_rare", ItemRegistry.METALS_RARE_ICON, AlchemicalSulfurTier.RARE);
    public static final RegistryObject<AlchemicalSulfurItem> METALS_PRECIOUS = SulfurRegistry.registerNiter("metals_precious", ItemRegistry.METALS_PRECIOUS_ICON, AlchemicalSulfurTier.PRECIOUS);
    public static final RegistryObject<AlchemicalSulfurItem> OTHER_MINERALS_ABUNDANT = SulfurRegistry.registerNiter("other_minerals_abundant", ItemRegistry.OTHER_MINERALS_ABUNDANT_ICON, AlchemicalSulfurTier.ABUNDANT);
    public static final RegistryObject<AlchemicalSulfurItem> OTHER_MINERALS_COMMON = SulfurRegistry.registerNiter("other_minerals_common", ItemRegistry.OTHER_MINERALS_COMMON_ICON, AlchemicalSulfurTier.COMMON);
    public static final RegistryObject<AlchemicalSulfurItem> OTHER_MINERALS_RARE = SulfurRegistry.registerNiter("other_minerals_rare", ItemRegistry.OTHER_MINERALS_RARE_ICON, AlchemicalSulfurTier.RARE);
    public static final RegistryObject<AlchemicalSulfurItem> OTHER_MINERALS_PRECIOUS = SulfurRegistry.registerNiter("other_minerals_precious", ItemRegistry.OTHER_MINERALS_PRECIOUS_ICON, AlchemicalSulfurTier.PRECIOUS);
    public static final RegistryObject<AlchemicalSulfurItem> LOGS = SulfurRegistry.registerWithTagSourceNameOverride("logs", AlchemicalSulfurTier.ABUNDANT, AlchemicalSulfurType.MISC);
    public static final RegistryObject<AlchemicalSulfurItem> WHEAT = SulfurRegistry.registerDefault("wheat", AlchemicalSulfurTier.ABUNDANT, AlchemicalSulfurType.MISC);
    public static final RegistryObject<AlchemicalSulfurItem> IRON = SulfurRegistry.registerWithSourceNameOverride("iron", AlchemicalSulfurTier.COMMON, AlchemicalSulfurType.METALS);
    public static final RegistryObject<AlchemicalSulfurItem> COPPER = SulfurRegistry.registerWithSourceNameOverride("copper", AlchemicalSulfurTier.ABUNDANT, AlchemicalSulfurType.METALS);
    public static final RegistryObject<AlchemicalSulfurItem> SILVER = SulfurRegistry.registerWithSourceNameOverride("silver", AlchemicalSulfurTier.RARE, AlchemicalSulfurType.METALS);
    public static final RegistryObject<AlchemicalSulfurItem> GOLD = SulfurRegistry.registerWithSourceNameOverride("gold", AlchemicalSulfurTier.RARE, AlchemicalSulfurType.METALS);
    public static final RegistryObject<AlchemicalSulfurItem> NETHERITE = SulfurRegistry.registerWithSourceNameOverride("netherite", AlchemicalSulfurTier.PRECIOUS, AlchemicalSulfurType.METALS);
    public static final RegistryObject<AlchemicalSulfurItem> URANIUM = SulfurRegistry.registerWithSourceNameOverride("uranium", AlchemicalSulfurTier.RARE, AlchemicalSulfurType.METALS);
    public static final RegistryObject<AlchemicalSulfurItem> AZURE_SILVER = SulfurRegistry.registerWithSourceNameOverride("azure_silver", AlchemicalSulfurTier.RARE, AlchemicalSulfurType.METALS);
    public static final RegistryObject<AlchemicalSulfurItem> ZINC = SulfurRegistry.registerWithSourceNameOverride("zinc", AlchemicalSulfurTier.COMMON, AlchemicalSulfurType.METALS);
    public static final RegistryObject<AlchemicalSulfurItem> OSMIUM = SulfurRegistry.registerWithSourceNameOverride("osmium", AlchemicalSulfurTier.COMMON, AlchemicalSulfurType.METALS);
    public static final RegistryObject<AlchemicalSulfurItem> NICKEL = SulfurRegistry.registerWithSourceNameOverride("nickel", AlchemicalSulfurTier.COMMON, AlchemicalSulfurType.METALS);
    public static final RegistryObject<AlchemicalSulfurItem> LEAD = SulfurRegistry.registerWithSourceNameOverride("lead", AlchemicalSulfurTier.COMMON, AlchemicalSulfurType.METALS);
    public static final RegistryObject<AlchemicalSulfurItem> ALLTHEMODIUM = SulfurRegistry.registerWithSourceNameOverride("allthemodium", AlchemicalSulfurTier.PRECIOUS, AlchemicalSulfurType.METALS);
    public static final RegistryObject<AlchemicalSulfurItem> UNOBTAINIUM = SulfurRegistry.registerWithSourceNameOverride("unobtainium", AlchemicalSulfurTier.PRECIOUS, AlchemicalSulfurType.METALS);
    public static final RegistryObject<AlchemicalSulfurItem> IRIDIUM = SulfurRegistry.registerWithSourceNameOverride("iridium", AlchemicalSulfurTier.RARE, AlchemicalSulfurType.METALS);
    public static final RegistryObject<AlchemicalSulfurItem> TIN = SulfurRegistry.registerWithSourceNameOverride("tin", AlchemicalSulfurTier.COMMON, AlchemicalSulfurType.METALS);
    public static final RegistryObject<AlchemicalSulfurItem> CINNABAR = SulfurRegistry.registerWithSourceNameOverride("cinnabar", AlchemicalSulfurTier.COMMON, AlchemicalSulfurType.METALS);
    public static final RegistryObject<AlchemicalSulfurItem> CRIMSON_IRON = SulfurRegistry.registerWithSourceNameOverride("crimson_iron", AlchemicalSulfurTier.RARE, AlchemicalSulfurType.METALS);
    public static final RegistryObject<AlchemicalSulfurItem> PLATINUM = SulfurRegistry.registerWithSourceNameOverride("platinum", AlchemicalSulfurTier.RARE, AlchemicalSulfurType.METALS);
    public static final RegistryObject<AlchemicalSulfurItem> VIBRANIUM = SulfurRegistry.registerWithSourceNameOverride("vibranium", AlchemicalSulfurTier.PRECIOUS, AlchemicalSulfurType.METALS);
    public static final RegistryObject<AlchemicalSulfurItem> DIAMOND = SulfurRegistry.registerWithSourceNameOverride("diamond", AlchemicalSulfurTier.PRECIOUS, AlchemicalSulfurType.GEMS);
    public static final RegistryObject<AlchemicalSulfurItem> EMERALD = SulfurRegistry.registerWithSourceNameOverride("emerald", AlchemicalSulfurTier.PRECIOUS, AlchemicalSulfurType.GEMS);
    public static final RegistryObject<AlchemicalSulfurItem> LAPIS = SulfurRegistry.registerWithSourceNameOverride("lapis", AlchemicalSulfurTier.COMMON, AlchemicalSulfurType.GEMS);
    public static final RegistryObject<AlchemicalSulfurItem> QUARTZ = SulfurRegistry.registerWithSourceNameOverride("quartz", AlchemicalSulfurTier.COMMON, AlchemicalSulfurType.GEMS);
    public static final RegistryObject<AlchemicalSulfurItem> AMETHYST = SulfurRegistry.registerWithSourceNameOverride("amethyst", AlchemicalSulfurTier.RARE, AlchemicalSulfurType.GEMS);
    public static final RegistryObject<AlchemicalSulfurItem> PRISMARINE = SulfurRegistry.registerWithSourceNameOverride("prismarine", AlchemicalSulfurTier.RARE, AlchemicalSulfurType.GEMS);
    public static final RegistryObject<AlchemicalSulfurItem> RUBY = SulfurRegistry.registerWithSourceNameOverride("ruby", AlchemicalSulfurTier.RARE, AlchemicalSulfurType.GEMS);
    public static final RegistryObject<AlchemicalSulfurItem> APATITE = SulfurRegistry.registerWithSourceNameOverride("apatite", AlchemicalSulfurTier.ABUNDANT, AlchemicalSulfurType.GEMS);
    public static final RegistryObject<AlchemicalSulfurItem> PERIDOT = SulfurRegistry.registerWithSourceNameOverride("peridot", AlchemicalSulfurTier.RARE, AlchemicalSulfurType.GEMS);
    public static final RegistryObject<AlchemicalSulfurItem> FLUORITE = SulfurRegistry.registerWithSourceNameOverride("fluorite", AlchemicalSulfurTier.ABUNDANT, AlchemicalSulfurType.GEMS);
    public static final RegistryObject<AlchemicalSulfurItem> SAPPHIRE = SulfurRegistry.registerWithSourceNameOverride("sapphire", AlchemicalSulfurTier.RARE, AlchemicalSulfurType.GEMS);
    public static final RegistryObject<AlchemicalSulfurItem> SAL_AMMONIAC = SulfurRegistry.registerWithSourceNameOverride("sal_ammoniac", AlchemicalSulfurTier.ABUNDANT, AlchemicalSulfurType.GEMS);
    public static final RegistryObject<AlchemicalSulfurItem> REDSTONE = SulfurRegistry.registerWithSourceNameOverride("redstone", AlchemicalSulfurTier.COMMON, AlchemicalSulfurType.OTHER_MINERALS);
    public static final RegistryObject<AlchemicalSulfurItem> COAL = SulfurRegistry.registerDefault("coal", AlchemicalSulfurTier.ABUNDANT, AlchemicalSulfurType.OTHER_MINERALS);
    public static final RegistryObject<AlchemicalSulfurItem> SULFUR = SulfurRegistry.registerWithSourceNameOverride("sulfur", AlchemicalSulfurTier.COMMON, AlchemicalSulfurType.OTHER_MINERALS);

    public static boolean keepInItemLists(AlchemicalSulfurItem sulfur) {
        return sulfur.type() == AlchemicalSulfurType.NITER;
    }

    public static RegistryObject<AlchemicalSulfurItem> registerWithTagSourceNameOverride(String name, AlchemicalSulfurTier tier, AlchemicalSulfurType type) {
        return SulfurRegistry.register(name, () -> new AlchemicalSulfurItem(new Item.Properties()).overrideTagSourceName(true).tier(tier).type(type));
    }

    public static RegistryObject<AlchemicalSulfurItem> registerWithSourceNameOverride(String name, AlchemicalSulfurTier tier, AlchemicalSulfurType type) {
        return SulfurRegistry.register(name, () -> new AlchemicalSulfurItem(new Item.Properties()).overrideSourceName(true).tier(tier).type(type));
    }

    public static RegistryObject<AlchemicalSulfurItem> registerNiter(String name, Supplier<Item> sourceStackSupplier, AlchemicalSulfurTier tier) {
        return SulfurRegistry.register(name, () -> new AlchemicalSulfurItem(new Item.Properties(), (Supplier<ItemStack>)Suppliers.memoize(() -> SulfurRegistry.lambda$registerNiter$2((Supplier)sourceStackSupplier))).overrideSourceName(true).autoTooltip(true, false).autoName(true, false).withJarIcon((Supplier<ItemStack>)Suppliers.memoize(() -> new ItemStack((ItemLike)ItemRegistry.EMPTY_CERAMIC_JAR_ICON.get()))).tier(tier).type(AlchemicalSulfurType.NITER));
    }

    public static RegistryObject<AlchemicalSulfurItem> registerDefault(String name, AlchemicalSulfurTier tier, AlchemicalSulfurType type) {
        return SulfurRegistry.register(name, () -> new AlchemicalSulfurItem(new Item.Properties()).tier(tier).type(type));
    }

    public static <T extends Item> RegistryObject<T> register(String name, Supplier<T> sup) {
        return SULFURS.register("alchemical_sulfur_" + name, sup);
    }

    public static void onBuildCreativeModTabs(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == CreativeModeTabRegistry.THEURGY.get()) {
            Level level = LevelUtil.getLevelWithoutContext();
            if (level == null) {
                return;
            }
            RecipeManager recipeManager = level.m_7465_();
            List liquefactionRecipes = recipeManager.m_44013_((RecipeType)RecipeTypeRegistry.LIQUEFACTION.get());
            SULFURS.getEntries().stream().map(RegistryObject::get).map(AlchemicalSulfurItem.class::cast).forEach(sulfur -> {
                Optional<ItemStack> preferred = SulfurRegistry.getPreferredSulfurVariant(sulfur, liquefactionRecipes, level);
                preferred.ifPresent(itemStack -> event.m_246342_(itemStack.m_255036_(1)));
            });
            event.m_246326_((ItemLike)GEMS_ABUNDANT.get());
            event.m_246326_((ItemLike)GEMS_COMMON.get());
            event.m_246326_((ItemLike)GEMS_RARE.get());
            event.m_246326_((ItemLike)GEMS_PRECIOUS.get());
            event.m_246326_((ItemLike)METALS_ABUNDANT.get());
            event.m_246326_((ItemLike)METALS_COMMON.get());
            event.m_246326_((ItemLike)METALS_RARE.get());
            event.m_246326_((ItemLike)METALS_PRECIOUS.get());
            event.m_246326_((ItemLike)OTHER_MINERALS_ABUNDANT.get());
            event.m_246326_((ItemLike)OTHER_MINERALS_COMMON.get());
            event.m_246326_((ItemLike)OTHER_MINERALS_RARE.get());
            event.m_246326_((ItemLike)OTHER_MINERALS_PRECIOUS.get());
        }
    }

    public static Optional<ItemStack> getPreferredSulfurVariant(AlchemicalSulfurItem sulfur, List<LiquefactionRecipe> liquefactionRecipes, Level level) {
        List<LiquefactionRecipe> matchingRecipes = liquefactionRecipes.stream().filter(recipe -> recipe.m_8043_(level.m_9598_()) != null && recipe.m_8043_(level.m_9598_()).m_41720_() == sulfur).toList();
        Optional<ItemStack> sulfurWithNbt = matchingRecipes.stream().filter(r -> Arrays.stream(r.getIngredient().m_43908_()).anyMatch(i -> i.m_204117_(Tags.Items.INGOTS) || i.m_204117_(Tags.Items.GEMS))).findFirst().map(r -> r.m_8043_(level.m_9598_()));
        if (sulfurWithNbt.isEmpty()) {
            sulfurWithNbt = matchingRecipes.stream().filter(r -> Arrays.stream(r.getIngredient().m_43908_()).anyMatch(i -> i.m_204117_(Tags.Items.DUSTS))).findFirst().map(r -> r.m_8043_(level.m_9598_()));
        }
        if (sulfurWithNbt.isEmpty()) {
            sulfurWithNbt = matchingRecipes.stream().findFirst().map(r -> r.m_8043_(level.m_9598_()));
        }
        return sulfurWithNbt;
    }

    private static /* synthetic */ ItemStack lambda$registerNiter$2(Supplier sourceStackSupplier) {
        return new ItemStack((ItemLike)sourceStackSupplier.get());
    }
}

