/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.incubator;

import com.klikli_dev.theurgy.content.apparatus.incubator.IncubatorCraftingBehaviour;
import com.klikli_dev.theurgy.content.apparatus.incubator.IncubatorMercuryVesselBlockEntity;
import com.klikli_dev.theurgy.content.apparatus.incubator.IncubatorSaltVesselBlockEntity;
import com.klikli_dev.theurgy.content.apparatus.incubator.IncubatorSulfurVesselBlockEntity;
import com.klikli_dev.theurgy.content.behaviour.CraftingBehaviour;
import com.klikli_dev.theurgy.content.behaviour.HeatConsumerBehaviour;
import com.klikli_dev.theurgy.content.behaviour.PreventInsertWrapper;
import com.klikli_dev.theurgy.content.capability.DefaultHeatReceiver;
import com.klikli_dev.theurgy.content.capability.HeatReceiver;
import com.klikli_dev.theurgy.content.recipe.wrapper.IncubatorRecipeWrapper;
import com.klikli_dev.theurgy.registry.BlockEntityRegistry;
import com.klikli_dev.theurgy.registry.CapabilityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncubatorBlockEntity
extends BlockEntity {
    public IncubatorMercuryVesselBlockEntity mercuryVessel;
    public IncubatorSulfurVesselBlockEntity sulfurVessel;
    public IncubatorSaltVesselBlockEntity saltVessel;
    public ItemStackHandler outputInventory = new OutputInventory();
    public PreventInsertWrapper outputInventoryTakeOnlyWrapper = new PreventInsertWrapper((IItemHandlerModifiable)this.outputInventory);
    public LazyOptional<IItemHandler> outputInventoryCapability = LazyOptional.of(() -> this.outputInventoryTakeOnlyWrapper);
    public IncubatorRecipeWrapper recipeWrapper;
    public DefaultHeatReceiver heatReceiver = new DefaultHeatReceiver();
    public LazyOptional<HeatReceiver> heatReceiverCapability = LazyOptional.of(() -> this.heatReceiver);
    public boolean isValidMultiblock;
    protected CraftingBehaviour<?, ?, ?> craftingBehaviour = new IncubatorCraftingBehaviour(this, () -> this.recipeWrapper, () -> null, () -> this.outputInventory);
    protected HeatConsumerBehaviour heatConsumerBehaviour = new HeatConsumerBehaviour(this);
    protected boolean checkValidMultiblockOnNextQuery = true;

    public IncubatorBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityRegistry.INCUBATOR.get(), pPos, pBlockState);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.writeNetwork(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.readNetwork(tag);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet) {
        CompoundTag tag = packet.m_131708_();
        if (tag != null) {
            this.readNetwork(tag);
        }
    }

    public void readNetwork(CompoundTag tag) {
        this.craftingBehaviour.readNetwork(tag);
    }

    public void writeNetwork(CompoundTag tag) {
        this.craftingBehaviour.writeNetwork(tag);
    }

    public void tickServer() {
        boolean isHeated = this.heatConsumerBehaviour.isHeated();
        boolean hasInput = this.isValidMultiblock() && !this.mercuryVessel.inputInventory.getStackInSlot(0).m_41619_() && !this.saltVessel.inputInventory.getStackInSlot(0).m_41619_() && !this.sulfurVessel.inputInventory.getStackInSlot(0).m_41619_();
        this.craftingBehaviour.tickServer(isHeated, hasInput);
    }

    public void tickClient() {
        RandomSource random;
        boolean isProcessing = this.craftingBehaviour.isProcessing();
        if (isProcessing && (random = this.m_58904_().m_213780_()).m_188501_() < 0.11f) {
            for (int i = 0; i < random.m_188503_(2) + 2; ++i) {
                this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123777_, (double)this.m_58899_().m_123341_() + 0.5 + (double)random.m_188501_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), (double)((float)(this.m_58899_().m_123342_() + 2) + random.m_188501_()), (double)this.m_58899_().m_123343_() + 0.5 + (double)random.m_188501_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), 0.0, 0.07, 0.0);
            }
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.outputInventoryCapability.cast();
        }
        if (cap == CapabilityRegistry.HEAT_RECEIVER) {
            return this.heatReceiverCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.outputInventoryCapability.invalidate();
        this.heatReceiverCapability.invalidate();
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("outputInventory", (Tag)this.outputInventory.serializeNBT());
        pTag.m_128365_("heatReceiver", this.heatReceiver.serializeNBT());
        this.craftingBehaviour.saveAdditional(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_("outputInventory")) {
            this.outputInventory.deserializeNBT(pTag.m_128469_("outputInventory"));
        }
        if (pTag.m_128441_("heatReceiver")) {
            this.heatReceiver.deserializeNBT(pTag.m_128423_("heatReceiver"));
        }
        this.craftingBehaviour.load(pTag);
    }

    private void checkForVessel(BlockPos pos) {
        BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
        if (blockEntity instanceof IncubatorMercuryVesselBlockEntity) {
            IncubatorMercuryVesselBlockEntity mercury;
            this.mercuryVessel = mercury = (IncubatorMercuryVesselBlockEntity)blockEntity;
            mercury.setIncubator(this);
        } else if (blockEntity instanceof IncubatorSulfurVesselBlockEntity) {
            IncubatorSulfurVesselBlockEntity sulfur;
            this.sulfurVessel = sulfur = (IncubatorSulfurVesselBlockEntity)blockEntity;
            sulfur.setIncubator(this);
        } else if (blockEntity instanceof IncubatorSaltVesselBlockEntity) {
            IncubatorSaltVesselBlockEntity salt;
            this.saltVessel = salt = (IncubatorSaltVesselBlockEntity)blockEntity;
            salt.setIncubator(this);
        }
    }

    public void validateMultiblock() {
        IncubatorMercuryVesselBlockEntity oldMercuryVessel = this.mercuryVessel;
        IncubatorSaltVesselBlockEntity oldSaltVessel = this.saltVessel;
        IncubatorSulfurVesselBlockEntity oldSulfurVessel = this.sulfurVessel;
        boolean wasValidMultiblock = this.isValidMultiblock;
        this.mercuryVessel = null;
        this.saltVessel = null;
        this.sulfurVessel = null;
        Direction.Plane.HORIZONTAL.m_122557_().forEach(direction -> {
            BlockPos pos = this.m_58899_().m_121945_(direction);
            this.checkForVessel(pos);
        });
        boolean bl = this.isValidMultiblock = this.mercuryVessel != null && this.sulfurVessel != null && this.saltVessel != null;
        if (wasValidMultiblock != this.isValidMultiblock) {
            if (this.isValidMultiblock) {
                this.onAssembleMultiblock();
            } else {
                this.onDisassembleMultiblock();
            }
        }
        if (oldMercuryVessel != this.mercuryVessel || oldSaltVessel != this.saltVessel || oldSulfurVessel != this.sulfurVessel) {
            this.onVesselItemChanged();
        }
    }

    public void onAssembleMultiblock() {
        this.recipeWrapper = new IncubatorRecipeWrapper((IItemHandlerModifiable)this.mercuryVessel.inputInventory, (IItemHandlerModifiable)this.saltVessel.inputInventory, (IItemHandlerModifiable)this.sulfurVessel.inputInventory);
    }

    public void onDisassembleMultiblock() {
        this.recipeWrapper = null;
    }

    public void onVesselItemChanged() {
        this.craftingBehaviour.onInputItemChanged(ItemStack.f_41583_, ItemStack.f_41583_);
    }

    public void m_7651_() {
        if (this.mercuryVessel != null) {
            this.mercuryVessel.setIncubator(null);
            this.mercuryVessel = null;
        }
        if (this.sulfurVessel != null) {
            this.sulfurVessel.setIncubator(null);
            this.sulfurVessel = null;
        }
        if (this.saltVessel != null) {
            this.saltVessel.setIncubator(null);
            this.saltVessel = null;
        }
        super.m_7651_();
    }

    public boolean isValidMultiblock() {
        if (this.checkValidMultiblockOnNextQuery) {
            this.checkValidMultiblockOnNextQuery = false;
            this.validateMultiblock();
        }
        return this.isValidMultiblock;
    }

    public class OutputInventory
    extends ItemStackHandler {
        public OutputInventory() {
            super(1);
        }

        protected void onContentsChanged(int slot) {
            IncubatorBlockEntity.this.m_6596_();
        }
    }
}

