/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.liquefactioncauldron;

import com.klikli_dev.theurgy.content.apparatus.liquefactioncauldron.LiquefactionCauldronCraftingBehaviour;
import com.klikli_dev.theurgy.content.behaviour.CraftingBehaviour;
import com.klikli_dev.theurgy.content.behaviour.HeatConsumerBehaviour;
import com.klikli_dev.theurgy.content.behaviour.PreventInsertWrapper;
import com.klikli_dev.theurgy.content.capability.DefaultHeatReceiver;
import com.klikli_dev.theurgy.content.capability.HeatReceiver;
import com.klikli_dev.theurgy.content.particle.ParticleColor;
import com.klikli_dev.theurgy.content.particle.coloredbubble.ColoredBubbleParticleProvider;
import com.klikli_dev.theurgy.registry.BlockEntityRegistry;
import com.klikli_dev.theurgy.registry.CapabilityRegistry;
import com.klikli_dev.theurgy.registry.FluidTagRegistry;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiquefactionCauldronBlockEntity
extends BlockEntity {
    public ItemStackHandler inputInventory = new InputInventory();
    public ItemStackHandler outputInventory = new OutputInventory();
    public PreventInsertWrapper outputInventoryTakeOnlyWrapper = new PreventInsertWrapper((IItemHandlerModifiable)this.outputInventory);
    public CombinedInvWrapper inventory = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputInventory, this.outputInventoryTakeOnlyWrapper});
    public LazyOptional<IItemHandler> inventoryCapability = LazyOptional.of(() -> this.inventory);
    public LazyOptional<IItemHandler> inputInventoryCapability = LazyOptional.of(() -> this.inputInventory);
    public LazyOptional<IItemHandler> outputInventoryCapability = LazyOptional.of(() -> this.outputInventoryTakeOnlyWrapper);
    public FluidTank solventTank = new SolventTank(2000, fluidStack -> ForgeRegistries.FLUIDS.tags().getTag(FluidTagRegistry.SOLVENT).contains((Object)fluidStack.getFluid()));
    public LazyOptional<IFluidHandler> solventTankCapability = LazyOptional.of(() -> this.solventTank);
    public DefaultHeatReceiver heatReceiver = new DefaultHeatReceiver();
    public LazyOptional<HeatReceiver> heatReceiverCapability = LazyOptional.of(() -> this.heatReceiver);
    protected CraftingBehaviour<?, ?, ?> craftingBehaviour = new LiquefactionCauldronCraftingBehaviour(this, () -> this.inputInventory, () -> this.outputInventory, () -> this.solventTank);
    protected HeatConsumerBehaviour heatConsumerBehaviour = new HeatConsumerBehaviour(this);

    public LiquefactionCauldronBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityRegistry.LIQUEFACTION_CAULDRON.get(), pPos, pBlockState);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.writeNetwork(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.readNetwork(tag);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet) {
        CompoundTag tag = packet.m_131708_();
        if (tag != null) {
            this.readNetwork(tag);
        }
    }

    public void readNetwork(CompoundTag tag) {
        if (tag.m_128441_("solventTank")) {
            this.solventTank.readFromNBT(tag.m_128469_("solventTank"));
        }
        this.craftingBehaviour.readNetwork(tag);
    }

    public void writeNetwork(CompoundTag tag) {
        tag.m_128365_("solventTank", (Tag)this.solventTank.writeToNBT(new CompoundTag()));
        this.craftingBehaviour.writeNetwork(tag);
    }

    public void sendBlockUpdated() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public void tickServer() {
        boolean isHeated = this.heatConsumerBehaviour.isHeated();
        boolean hasInput = !this.inputInventory.getStackInSlot(0).m_41619_();
        this.craftingBehaviour.tickServer(isHeated, hasInput);
    }

    public void tickClient() {
        boolean isProcessing = this.craftingBehaviour.isProcessing();
        if (isProcessing && this.m_58904_().m_46467_() % 2L == 0L) {
            this.m_58904_().m_7106_(ColoredBubbleParticleProvider.createOptions(new ParticleColor(255, 0, 255)), (double)this.m_58899_().m_123341_() + 0.33 + 0.33 * (double)this.m_58904_().m_213780_().m_188501_(), (double)this.m_58899_().m_123342_() + 1.1, (double)this.m_58899_().m_123343_() + 0.33 + 0.33 * (double)this.m_58904_().m_213780_().m_188501_(), 0.0, 0.015, 0.0);
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == Direction.UP) {
                return this.inputInventoryCapability.cast();
            }
            if (side == Direction.DOWN) {
                return this.outputInventoryCapability.cast();
            }
            return this.inventoryCapability.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.solventTankCapability.cast();
        }
        if (cap == CapabilityRegistry.HEAT_RECEIVER) {
            return this.heatReceiverCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inventoryCapability.invalidate();
        this.inputInventoryCapability.invalidate();
        this.outputInventoryCapability.invalidate();
        this.solventTankCapability.invalidate();
        this.heatReceiverCapability.invalidate();
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("inputInventory", (Tag)this.inputInventory.serializeNBT());
        pTag.m_128365_("outputInventory", (Tag)this.outputInventory.serializeNBT());
        pTag.m_128365_("solventTank", (Tag)this.solventTank.writeToNBT(new CompoundTag()));
        pTag.m_128365_("heatReceiver", this.heatReceiver.serializeNBT());
        this.craftingBehaviour.saveAdditional(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_("inputInventory")) {
            this.inputInventory.deserializeNBT(pTag.m_128469_("inputInventory"));
        }
        if (pTag.m_128441_("outputInventory")) {
            this.outputInventory.deserializeNBT(pTag.m_128469_("outputInventory"));
        }
        if (pTag.m_128441_("solventTank")) {
            this.solventTank.readFromNBT(pTag.m_128469_("solventTank"));
        }
        if (pTag.m_128441_("heatReceiver")) {
            this.heatReceiver.deserializeNBT(pTag.m_128423_("heatReceiver"));
        }
        this.craftingBehaviour.load(pTag);
    }

    public class InputInventory
    extends ItemStackHandler {
        public InputInventory() {
            super(1);
        }

        public void setStackInSlot(int slot, @NotNull ItemStack newStack) {
            ItemStack oldStack = this.getStackInSlot(slot);
            boolean sameItem = !newStack.m_41619_() && ItemStack.m_150942_((ItemStack)newStack, (ItemStack)oldStack);
            super.setStackInSlot(slot, newStack);
            if (!sameItem) {
                LiquefactionCauldronBlockEntity.this.craftingBehaviour.onInputItemChanged(oldStack, newStack);
            }
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack newStack, boolean simulate) {
            if (!simulate) {
                ItemStack oldStack = this.getStackInSlot(slot);
                ItemStack result = super.insertItem(slot, newStack, simulate);
                if (result != newStack) {
                    LiquefactionCauldronBlockEntity.this.craftingBehaviour.onInputItemChanged(oldStack, newStack);
                }
                return result;
            }
            return super.insertItem(slot, newStack, simulate);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return LiquefactionCauldronBlockEntity.this.craftingBehaviour.canProcess(stack) && super.isItemValid(slot, stack);
        }

        protected void onContentsChanged(int slot) {
            LiquefactionCauldronBlockEntity.this.m_6596_();
        }
    }

    public class OutputInventory
    extends ItemStackHandler {
        public OutputInventory() {
            super(1);
        }

        protected void onContentsChanged(int slot) {
            LiquefactionCauldronBlockEntity.this.m_6596_();
        }
    }

    public class SolventTank
    extends FluidTank {
        public SolventTank(int capacity, Predicate<FluidStack> validator) {
            super(capacity, validator);
        }

        protected void onContentsChanged() {
            LiquefactionCauldronBlockEntity.this.m_6596_();
            LiquefactionCauldronBlockEntity.this.sendBlockUpdated();
        }
    }
}

