/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.pyromanticbrazier;

import com.klikli_dev.theurgy.content.apparatus.calcinationoven.CalcinationOvenBlock;
import com.klikli_dev.theurgy.content.apparatus.pyromanticbrazier.PyromanticBrazierBlock;
import com.klikli_dev.theurgy.content.capability.HeatProvider;
import com.klikli_dev.theurgy.registry.BlockEntityRegistry;
import com.klikli_dev.theurgy.registry.CapabilityRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyromanticBrazierBlockEntity
extends BlockEntity {
    public ItemStackHandler inventory = new Inventory();
    public LazyOptional<IItemHandler> inventoryCapability = LazyOptional.of(() -> this.inventory);
    public LazyOptional<HeatProvider> heatProviderCapability = LazyOptional.of(() -> () -> (Boolean)this.m_58900_().m_61143_((Property)PyromanticBrazierBlock.LIT));
    private int remainingLitTime;

    public PyromanticBrazierBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityRegistry.PYROMANTIC_BRAZIER.get(), pPos, pBlockState);
    }

    protected int getBurnDuration(ItemStack pFuel) {
        if (pFuel.m_41619_()) {
            return 0;
        }
        return ForgeHooks.getBurnTime((ItemStack)pFuel, (RecipeType)((RecipeType)RecipeTypeRegistry.PYROMANTIC_BRAZIER.get()));
    }

    public boolean isLit() {
        return this.remainingLitTime > 0;
    }

    public void tickClient() {
    }

    public void tickServer() {
        ItemStack fuelStack;
        boolean hasFuel;
        boolean wasTurnedOnDuringThisTick = false;
        boolean wasLitAtBeginOfTick = this.isLit();
        if (wasLitAtBeginOfTick) {
            --this.remainingLitTime;
        }
        boolean bl = hasFuel = !(fuelStack = this.inventory.getStackInSlot(0)).m_41619_();
        if (!this.isLit() && hasFuel) {
            this.remainingLitTime = this.getBurnDuration(fuelStack);
            if (this.isLit()) {
                wasTurnedOnDuringThisTick = true;
                if (fuelStack.hasCraftingRemainingItem()) {
                    this.inventory.setStackInSlot(0, fuelStack.getCraftingRemainingItem());
                } else if (hasFuel) {
                    fuelStack.m_41774_(1);
                    if (fuelStack.m_41619_()) {
                        this.inventory.setStackInSlot(0, fuelStack.getCraftingRemainingItem());
                    }
                }
            }
        }
        if (wasLitAtBeginOfTick != this.isLit()) {
            wasTurnedOnDuringThisTick = true;
            BlockState newState = (BlockState)this.m_58900_().m_61124_((Property)CalcinationOvenBlock.LIT, (Comparable)Boolean.valueOf(this.isLit()));
            this.f_58857_.m_7731_(this.m_58899_(), newState, 3);
        }
        if (wasTurnedOnDuringThisTick) {
            this.m_6596_();
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryCapability.cast();
        }
        if (cap == CapabilityRegistry.HEAT_PROVIDER) {
            return this.heatProviderCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inventoryCapability.invalidate();
        this.heatProviderCapability.invalidate();
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
        pTag.m_128376_("remainingLitTime", (short)this.remainingLitTime);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_("inventory")) {
            this.inventory.deserializeNBT(pTag.m_128469_("inventory"));
        }
        if (pTag.m_128441_("remainingLitTime")) {
            this.remainingLitTime = pTag.m_128448_("remainingLitTime");
        }
    }

    private class Inventory
    extends ItemStackHandler {
        public Inventory() {
            super(1);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return PyromanticBrazierBlockEntity.this.getBurnDuration(stack) > 0;
        }

        protected void onContentsChanged(int slot) {
            PyromanticBrazierBlockEntity.this.m_6596_();
        }
    }
}

