/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.salammoniacaccumulator;

import com.klikli_dev.theurgy.content.recipe.AccumulationRecipe;
import com.klikli_dev.theurgy.content.recipe.wrapper.RecipeWrapperWithFluid;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

class SalAmmoniacAccumulatorCachedCheck
implements RecipeManager.CachedCheck<RecipeWrapperWithFluid, AccumulationRecipe> {
    private final RecipeType<AccumulationRecipe> type;
    private final RecipeManager.CachedCheck<RecipeWrapperWithFluid, AccumulationRecipe> internal;
    @Nullable
    private ResourceLocation lastRecipe;

    public SalAmmoniacAccumulatorCachedCheck(RecipeType<AccumulationRecipe> type) {
        this.type = type;
        this.internal = RecipeManager.m_220267_(type);
    }

    private Optional<Pair<ResourceLocation, AccumulationRecipe>> getRecipeFor(ItemStack stack, Level level, @Nullable ResourceLocation lastRecipe) {
        AccumulationRecipe recipe;
        RecipeManager recipeManager = level.m_7465_();
        Map map = recipeManager.m_44054_(this.type);
        if (lastRecipe != null && (recipe = (AccumulationRecipe)map.get(lastRecipe)) != null && recipe.hasSolute() && recipe.getSolute().test(stack)) {
            return Optional.of(Pair.of((Object)lastRecipe, (Object)recipe));
        }
        return map.entrySet().stream().filter(entry -> ((AccumulationRecipe)entry.getValue()).hasSolute() && ((AccumulationRecipe)entry.getValue()).getSolute().test(stack)).findFirst().map(entry -> Pair.of((Object)((ResourceLocation)entry.getKey()), (Object)((AccumulationRecipe)entry.getValue())));
    }

    private Optional<Pair<ResourceLocation, AccumulationRecipe>> getRecipeFor(FluidStack stack, Level level, @Nullable ResourceLocation lastRecipe) {
        AccumulationRecipe recipe;
        RecipeManager recipeManager = level.m_7465_();
        Map map = recipeManager.m_44054_(this.type);
        if (lastRecipe != null && (recipe = (AccumulationRecipe)map.get(lastRecipe)) != null && recipe.getEvaporant().test(stack)) {
            return Optional.of(Pair.of((Object)lastRecipe, (Object)recipe));
        }
        return map.entrySet().stream().filter(entry -> ((AccumulationRecipe)entry.getValue()).getEvaporant().test(stack)).findFirst().map(entry -> Pair.of((Object)((ResourceLocation)entry.getKey()), (Object)((AccumulationRecipe)entry.getValue())));
    }

    public Optional<AccumulationRecipe> getRecipeFor(ItemStack stack, Level level) {
        Optional<Pair<ResourceLocation, AccumulationRecipe>> optional = this.getRecipeFor(stack, level, this.lastRecipe);
        if (optional.isPresent()) {
            Pair<ResourceLocation, AccumulationRecipe> pair = optional.get();
            this.lastRecipe = (ResourceLocation)pair.getFirst();
            return Optional.of((AccumulationRecipe)pair.getSecond());
        }
        return Optional.empty();
    }

    public Optional<AccumulationRecipe> getRecipeFor(FluidStack stack, Level level) {
        Optional<Pair<ResourceLocation, AccumulationRecipe>> optional = this.getRecipeFor(stack, level, this.lastRecipe);
        if (optional.isPresent()) {
            Pair<ResourceLocation, AccumulationRecipe> pair = optional.get();
            this.lastRecipe = (ResourceLocation)pair.getFirst();
            return Optional.of((AccumulationRecipe)pair.getSecond());
        }
        return Optional.empty();
    }

    public Optional<AccumulationRecipe> getRecipeFor(RecipeWrapperWithFluid container, Level level) {
        Optional recipe = this.internal.m_213657_((Container)container, level);
        if (recipe.isPresent()) {
            this.lastRecipe = ((AccumulationRecipe)recipe.get()).m_6423_();
        }
        return recipe;
    }
}

