/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.salammoniacaccumulator;

import com.klikli_dev.theurgy.content.apparatus.salammoniacaccumulator.SalAmmoniacAccumulatorCachedCheck;
import com.klikli_dev.theurgy.content.behaviour.CraftingBehaviour;
import com.klikli_dev.theurgy.content.recipe.AccumulationRecipe;
import com.klikli_dev.theurgy.content.recipe.wrapper.RecipeWrapperWithFluid;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class SalAmmoniacAccumulatorCraftingBehaviour
extends CraftingBehaviour<RecipeWrapperWithFluid, AccumulationRecipe, SalAmmoniacAccumulatorCachedCheck> {
    protected Supplier<IFluidHandler> waterTankSupplier;
    protected Supplier<IFluidHandler> outputTankSupplier;

    public SalAmmoniacAccumulatorCraftingBehaviour(BlockEntity blockEntity, Supplier<IItemHandlerModifiable> inputInventorySupplier, Supplier<IItemHandlerModifiable> outputInventorySupplier, Supplier<IFluidHandler> waterTankSupplier, Supplier<IFluidHandler> outputTankSupplier) {
        super(blockEntity, Lazy.of(() -> new RecipeWrapperWithFluid((IItemHandlerModifiable)inputInventorySupplier.get(), (IFluidHandler)waterTankSupplier.get())), inputInventorySupplier, outputInventorySupplier, new SalAmmoniacAccumulatorCachedCheck((RecipeType<AccumulationRecipe>)((RecipeType)RecipeTypeRegistry.ACCUMULATION.get())));
        this.waterTankSupplier = waterTankSupplier;
        this.outputTankSupplier = outputTankSupplier;
    }

    @Override
    public boolean canProcess(ItemStack stack) {
        if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)((IItemHandlerModifiable)this.inputInventorySupplier.get()).getStackInSlot(0))) {
            return true;
        }
        return ((SalAmmoniacAccumulatorCachedCheck)this.recipeCachedCheck).getRecipeFor(stack, this.blockEntity.m_58904_()).isPresent();
    }

    public boolean canProcess(FluidStack stack) {
        if (this.waterTankSupplier.get().getFluidInTank(0).isFluidEqual(stack)) {
            return true;
        }
        return ((SalAmmoniacAccumulatorCachedCheck)this.recipeCachedCheck).getRecipeFor(stack, this.blockEntity.m_58904_()).isPresent();
    }

    @Override
    protected int getIngredientCount(AccumulationRecipe recipe) {
        return 1;
    }

    @Override
    protected int getCraftingTime(AccumulationRecipe recipe) {
        return recipe.getAccumulationTime();
    }

    @Override
    protected int getDefaultCraftingTime() {
        return 100;
    }

    @Override
    protected boolean canCraft(@Nullable AccumulationRecipe pRecipe) {
        if (pRecipe == null) {
            return false;
        }
        FluidStack assembledStack = pRecipe.assembleFluid((RecipeWrapperWithFluid)((Object)this.recipeWrapperSupplier.get()), this.blockEntity.m_58904_().m_9598_());
        if (assembledStack.isEmpty()) {
            return false;
        }
        IFluidHandler tank = this.outputTankSupplier.get();
        int fluidAccepted = tank.fill(assembledStack, IFluidHandler.FluidAction.SIMULATE);
        return fluidAccepted == assembledStack.getAmount();
    }

    @Override
    protected boolean craft(AccumulationRecipe pRecipe) {
        FluidStack assembledFluid = pRecipe.assembleFluid((RecipeWrapperWithFluid)((Object)this.recipeWrapperSupplier.get()), this.blockEntity.m_58904_().m_9598_());
        IFluidHandler outputFluidTank = this.outputTankSupplier.get();
        outputFluidTank.fill(assembledFluid, IFluidHandler.FluidAction.EXECUTE);
        if (pRecipe.hasSolute()) {
            ((IItemHandlerModifiable)this.inputInventorySupplier.get()).extractItem(0, this.getIngredientCount(pRecipe), false);
        }
        this.waterTankSupplier.get().drain(pRecipe.getEvaporantAmount(), IFluidHandler.FluidAction.EXECUTE);
        return true;
    }
}

