/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.behaviour;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.Nullable;

public abstract class CraftingBehaviour<W extends RecipeWrapper, R extends Recipe<W>, C extends RecipeManager.CachedCheck<W, R>> {
    protected BlockEntity blockEntity;
    protected Supplier<W> recipeWrapperSupplier;
    protected Supplier<IItemHandlerModifiable> inputInventorySupplier;
    protected Supplier<IItemHandlerModifiable> outputInventorySupplier;
    protected C recipeCachedCheck;
    protected int progress;
    protected int totalTime;
    protected boolean isProcessing;

    public CraftingBehaviour(BlockEntity blockEntity, Supplier<W> recipeWrapper, Supplier<IItemHandlerModifiable> inputInventorySupplier, Supplier<IItemHandlerModifiable> outputInventorySupplier, C recipeCachedCheck) {
        this.blockEntity = blockEntity;
        this.recipeWrapperSupplier = recipeWrapper;
        this.inputInventorySupplier = inputInventorySupplier;
        this.outputInventorySupplier = outputInventorySupplier;
        this.recipeCachedCheck = recipeCachedCheck;
    }

    public boolean isProcessing() {
        return this.isProcessing;
    }

    public void readNetwork(CompoundTag tag) {
        this.isProcessing = tag.m_128471_("isProcessing");
    }

    public void writeNetwork(CompoundTag tag) {
        tag.m_128379_("isProcessing", this.isProcessing);
    }

    public void saveAdditional(CompoundTag pTag) {
        pTag.m_128376_("progress", (short)this.progress);
    }

    public void load(CompoundTag pTag) {
        if (pTag.m_128441_("progress")) {
            this.progress = pTag.m_128448_("progress");
        }
    }

    public void tickServer(boolean canProcess, boolean hasInput) {
        if (hasInput) {
            Recipe recipe = this.recipeCachedCheck.m_213657_((Container)((RecipeWrapper)this.recipeWrapperSupplier.get()), this.blockEntity.m_58904_()).orElse(null);
            if (canProcess && this.canCraft(recipe)) {
                this.tryStartProcessing();
                ++this.progress;
                this.tryFinishProcessing(recipe);
            } else {
                this.stopProcessing();
            }
        } else {
            this.stopProcessing();
        }
    }

    public void onInputItemChanged(ItemStack oldStack, ItemStack newStack) {
        this.totalTime = this.getTotalTime();
        this.progress = 0;
    }

    public abstract boolean canProcess(ItemStack var1);

    protected void tryFinishProcessing(R pRecipe) {
        if (this.progress >= this.totalTime) {
            this.progress = 0;
            this.totalTime = this.getTotalTime();
            this.craft(pRecipe);
            this.sendBlockUpdated();
        }
    }

    protected void tryStartProcessing() {
        if (this.progress == 0) {
            this.isProcessing = true;
            this.sendBlockUpdated();
        }
    }

    protected void stopProcessing() {
        if (this.progress != 0 || this.isProcessing) {
            this.isProcessing = false;
            this.progress = 0;
            this.sendBlockUpdated();
        }
    }

    protected boolean canCraft(@Nullable R pRecipe) {
        if (pRecipe == null) {
            return false;
        }
        ItemStack assembledStack = pRecipe.m_5874_((Container)((RecipeWrapper)this.recipeWrapperSupplier.get()), this.blockEntity.m_58904_().m_9598_());
        if (assembledStack.m_41619_()) {
            return false;
        }
        ItemStack remainingStack = ItemHandlerHelper.insertItemStacked((IItemHandler)((IItemHandler)this.outputInventorySupplier.get()), (ItemStack)assembledStack, (boolean)true);
        return remainingStack.m_41619_();
    }

    protected boolean craft(R pRecipe) {
        ItemStack assembledStack = pRecipe.m_5874_((Container)((RecipeWrapper)this.recipeWrapperSupplier.get()), this.blockEntity.m_58904_().m_9598_());
        ItemHandlerHelper.insertItemStacked((IItemHandler)((IItemHandler)this.outputInventorySupplier.get()), (ItemStack)assembledStack, (boolean)false);
        this.inputInventorySupplier.get().extractItem(0, this.getIngredientCount(pRecipe), false);
        return true;
    }

    protected int getTotalTime() {
        return this.recipeCachedCheck.m_213657_((Container)((RecipeWrapper)this.recipeWrapperSupplier.get()), this.blockEntity.m_58904_()).map(this::getCraftingTime).orElse(this.getDefaultCraftingTime());
    }

    protected void sendBlockUpdated() {
        if (this.blockEntity.m_58904_() != null && !this.blockEntity.m_58904_().f_46443_) {
            this.blockEntity.m_58904_().m_7260_(this.blockEntity.m_58899_(), this.blockEntity.m_58900_(), this.blockEntity.m_58900_(), 2);
        }
    }

    protected abstract int getIngredientCount(R var1);

    protected abstract int getCraftingTime(R var1);

    protected abstract int getDefaultCraftingTime();
}

