/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.book;

import com.klikli_dev.modonomicon.api.datagen.BookProvider;
import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookCategoryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookCraftingRecipePageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookSpotlightPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.klikli_dev.theurgy.Theurgy;
import com.klikli_dev.theurgy.datagen.book.EntryBackground;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class MercuryFluxCategoryProvider
extends CategoryProvider {
    public static final String CATEGORY_ID = "mercury_flux";

    public MercuryFluxCategoryProvider(BookProvider parent) {
        super(parent, CATEGORY_ID);
    }

    protected String[] generateEntryMap() {
        return new String[]{"__________________________________", "__________________________________", "____________\u0107_____________________", "__________________________________", "__________i_c_____________________", "__________________________________", "__________________________________", "__________________________________", "__________________________________"};
    }

    protected void generateEntries() {
        BookEntryModel intro = this.add(this.intro('i'));
        BookEntryModel mercuryCatalyst = this.add(this.mercuryCatalyst('c'));
        BookEntryModel caloricFluxEmitter = this.add(this.caloricFluxEmitter('\u0107'));
        mercuryCatalyst.addParent(this.parent(intro));
        caloricFluxEmitter.addParent(this.parent(mercuryCatalyst));
    }

    protected BookCategoryModel generateCategory() {
        this.add(this.context().categoryName(), "Mercury Flux");
        return BookCategoryModel.create((ResourceLocation)Theurgy.loc(this.context().categoryId()), (String)this.context().categoryName()).withBackground(Theurgy.loc("textures/gui/book/bg_nightsky.png")).withIcon((ItemLike)ItemRegistry.MERCURY_SHARD.get());
    }

    private BookEntryModel intro(char location) {
        this.context().entry("intro");
        this.add(this.context().entryName(), "Mercury Flux");
        this.add(this.context().entryDescription(), "Raw Energy Manipulation");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "Mercury Flux");
        this.add(this.context().pageText(), "**Mercury** represents the Energy contained in all matter. The Spagyrics processes for Mercury extraction yield {0}. In this Form it is not immediately useful as an energy source, so it must first be transformed - catalyzed - into [#]($PURPLE)Mercury Flux[#](), which is Mercury in it's natural Form.\n", new Object[]{this.itemLink((ItemLike)ItemRegistry.MERCURY_SHARD.get())});
        return this.entry(location).withIcon((ItemLike)ItemRegistry.MERCURY_SHARD.get()).withEntryBackground(EntryBackground.CATEGORY_START).withPages(new BookPageModel[]{intro});
    }

    private BookEntryModel mercuryCatalyst(char location) {
        this.context().entry("mercury_catalyst");
        this.add(this.context().entryName(), "Mercury Catalyst");
        this.add(this.context().entryDescription(), "Accessing Raw Energy");
        this.context().page("intro");
        BookSpotlightPageModel intro = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.MERCURY_CATALYST.get()})).withText(this.context().pageText()).build();
        this.add(this.context().pageText(), "This apparatus slowly converts {0} into [#]($PURPLE)Mercury Flux[#](), which can be used as a source of Energy. It is the first step towards using the Energy contained in matter.\n", new Object[]{this.itemLink((ItemLike)ItemRegistry.MERCURY_SHARD.get())});
        this.context().page("usage");
        BookTextPageModel usage = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "Usage");
        this.add(this.context().pageText(), "Place the {0}, then insert {1} by right-clicking the oven with it. The Catalyst will begin to slowly fill up with [#]($PURPLE)Mercury Flux[#]().\n\\\n\\\nIt's sides will turn more and more blue as it fills up.\n", new Object[]{this.itemLink((ItemLike)ItemRegistry.MERCURY_CATALYST.get()), this.itemLink((ItemLike)ItemRegistry.MERCURY_SHARD.get())});
        this.context().page("recipe");
        BookCraftingRecipePageModel recipe = ((BookCraftingRecipePageModel.Builder)BookCraftingRecipePageModel.builder().withRecipeId1(Theurgy.loc("crafting/shaped/mercury_catalyst"))).build();
        return this.entry(location).withIcon((ItemLike)ItemRegistry.MERCURY_CATALYST.get()).withEntryBackground(EntryBackground.DEFAULT).withPages(new BookPageModel[]{intro, usage, recipe});
    }

    private BookEntryModel caloricFluxEmitter(char location) {
        this.context().entry("caloric_flux_emitter");
        this.add(this.context().entryName(), "Caloric Flux Emitter");
        this.add(this.context().entryDescription(), "Efficiently powering alchemical Apparatus");
        this.context().page("intro");
        BookSpotlightPageModel intro = BookSpotlightPageModel.builder().withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.CALORIC_FLUX_EMITTER.get()})).withText(this.context().pageText()).build();
        this.add(this.context().pageText(), "This devices converts raw mercury flux into [#]($PURPLE)Caloric Flux[#](), or simply: transferable heat. It can be used to power other alchemical apparatuses that would usually need a {0} below them.\n", new Object[]{this.itemLink((ItemLike)ItemRegistry.PYROMANTIC_BRAZIER.get())});
        this.context().page("usage");
        BookTextPageModel usage = BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build();
        this.add(this.context().pageTitle(), "Usage");
        this.add(this.context().pageText(), "Right-click the target block with the {0} until it is highlighted. Then place the Emitter onto a Mercury Flux source, such as a {1}.\\\nThe maximum range is **8** blocks.\\\nAs long as mercury flux is provided to it, the emitter will send caloric flux to the target block and keep it heated.\n", new Object[]{this.itemLink((ItemLike)ItemRegistry.CALORIC_FLUX_EMITTER.get()), this.itemLink((ItemLike)ItemRegistry.MERCURY_CATALYST.get())});
        this.context().page("recipe");
        BookCraftingRecipePageModel recipe = ((BookCraftingRecipePageModel.Builder)((BookCraftingRecipePageModel.Builder)BookCraftingRecipePageModel.builder().withRecipeId1(Theurgy.loc("crafting/shaped/caloric_flux_emitter_from_campfire"))).withRecipeId2(Theurgy.loc("crafting/shaped/caloric_flux_emitter_from_lava_bucket"))).build();
        return this.entry(location).withIcon((ItemLike)ItemRegistry.CALORIC_FLUX_EMITTER.get()).withEntryBackground(EntryBackground.DEFAULT).withPages(new BookPageModel[]{intro, usage, recipe});
    }
}

