/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.book;

import com.klikli_dev.modonomicon.api.datagen.BookProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookCategoryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookConditionModel;
import com.klikli_dev.theurgy.datagen.book.GettingStartedCategoryProvider;
import com.klikli_dev.theurgy.datagen.book.MercuryFluxCategoryProvider;
import com.klikli_dev.theurgy.datagen.book.SpagyricsCategoryProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.data.LanguageProvider;

public class TheurgyBookProvider
extends BookProvider {
    public TheurgyBookProvider(PackOutput packOutput, LanguageProvider lang, LanguageProvider ... translations) {
        super("the_hermetica", packOutput, "theurgy", lang, translations);
    }

    protected void registerDefaultMacros() {
        this.registerDefaultMacro("$PURPLE", "ad03fc");
    }

    protected BookModel generateBook() {
        this.lang.add(this.context().bookName(), "The Hermetica");
        this.lang.add(this.context().bookTooltip(), "A treatise on the Ancient Art of Alchemy.\n\u00a7o(In-Game Guide for Theurgy)\u00a7r");
        int categorySortNum = 1;
        BookCategoryModel gettingStartedCategory = new GettingStartedCategoryProvider(this).generate().withSortNumber(categorySortNum++);
        BookCategoryModel spagyricsCategory = new SpagyricsCategoryProvider(this).generate().withSortNumber(categorySortNum++);
        spagyricsCategory.withCondition((BookConditionModel)this.condition().entryRead(this.modLoc("getting_started/spagyrics")));
        BookCategoryModel mercuryFluxCategory = new MercuryFluxCategoryProvider(this).generate().withSortNumber(categorySortNum++);
        mercuryFluxCategory.withCondition((BookConditionModel)this.condition().entryRead(this.modLoc("getting_started/mercury_flux")));
        BookModel book = BookModel.create((ResourceLocation)this.modLoc(this.context().bookId()), (String)this.context().bookName()).withTooltip(this.context().bookTooltip()).withCategories(new BookCategoryModel[]{gettingStartedCategory, spagyricsCategory, mercuryFluxCategory}).withGenerateBookItem(true).withModel(this.modLoc("the_hermetica_icon")).withAutoAddReadConditions(true);
        return book;
    }
}

