/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.model;

import com.klikli_dev.theurgy.content.apparatus.incubator.IncubatorBlock;
import com.klikli_dev.theurgy.content.apparatus.liquefactioncauldron.LiquefactionCauldronBlock;
import com.klikli_dev.theurgy.registry.BlockRegistry;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class TheurgyBlockStateProvider
extends BlockStateProvider {
    public TheurgyBlockStateProvider(PackOutput packOutput, ExistingFileHelper exFileHelper) {
        super(packOutput, "theurgy", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.registerCalcinationOven();
        this.registerPyromanticBrazier();
        this.registerLiquefactionCauldron();
        this.registerDistiller();
        this.registerIncubator();
        this.registerIncubatorVessels();
        this.registerSalAmmoniacAccumulator();
        this.registerSalAmmoniacTank();
        this.registerMercuryCatalyst();
        this.registerCaloricFluxEmitter();
        this.simpleBlockWithItem((Block)BlockRegistry.SAL_AMMONIAC_ORE.get(), this.cubeAll((Block)BlockRegistry.SAL_AMMONIAC_ORE.get()));
        this.simpleBlockWithItem((Block)BlockRegistry.DEEPSLATE_SAL_AMMONIAC_ORE.get(), this.cubeAll((Block)BlockRegistry.DEEPSLATE_SAL_AMMONIAC_ORE.get()));
    }

    protected void registerCaloricFluxEmitter() {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("caloric_flux_emitter", this.modLoc("block/caloric_flux_emitter_template"))).ao(false)).renderType(new ResourceLocation("minecraft", "translucent"))).texture("emitter", this.modLoc("block/caloric_flux_emitter"))).texture("socket", this.modLoc("block/emitter_socket"))).texture("particle", this.modLoc("block/emitter_socket"));
        this.directionalBlock((Block)BlockRegistry.CALORIC_FLUX_EMITTER.get(), (ModelFile)model);
        this.simpleBlockItem((Block)BlockRegistry.CALORIC_FLUX_EMITTER.get(), (ModelFile)model);
    }

    protected void registerSalAmmoniacAccumulator() {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("sal_ammoniac_accumulator")).texture("particle", "minecraft:block/copper_block");
        this.simpleBlock((Block)BlockRegistry.SAL_AMMONIAC_ACCUMULATOR.get(), (ModelFile)model);
        ((ItemModelBuilder)this.itemModels().getBuilder("sal_ammoniac_accumulator")).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"));
    }

    protected void registerSalAmmoniacTank() {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("sal_ammoniac_tank")).texture("particle", "minecraft:block/copper_block");
        this.simpleBlock((Block)BlockRegistry.SAL_AMMONIAC_TANK.get(), (ModelFile)model);
        ((ItemModelBuilder)this.itemModels().getBuilder("sal_ammoniac_tank")).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"));
    }

    protected void registerMercuryCatalyst() {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("mercury_catalyst", this.modLoc("block/mercury_catalyst_template"))).ao(false)).renderType(new ResourceLocation("minecraft", "translucent"))).texture("texture", this.modLoc("block/mercury_catalyst"))).texture("particle", this.mcLoc("block/iron_block"));
        this.simpleBlockWithItem((Block)BlockRegistry.MERCURY_CATALYST.get(), (ModelFile)model);
    }

    protected void registerDistiller() {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("distiller")).texture("particle", "minecraft:block/copper_block");
        this.getVariantBuilder((Block)BlockRegistry.DISTILLER.get()).forAllStates(s -> ConfiguredModel.builder().modelFile((ModelFile)model).build());
        ((ItemModelBuilder)this.itemModels().getBuilder("distiller")).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"));
    }

    protected void registerIncubator() {
        BlockModelBuilder lowerHalfModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("incubator_lower", this.modLoc("block/incubator_template"))).ao(false)).texture("texture", this.modLoc("block/incubator_gold"))).texture("particle", this.mcLoc("block/copper_block"));
        BlockModelBuilder upperHalfModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("incubator_upper")).ao(false)).texture("particle", "minecraft:block/copper_block");
        BlockModelBuilder pipeModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("incubator_pipe", this.modLoc("block/incubator_pipe_template"))).ao(false)).texture("texture", this.modLoc("block/incubator_pipe"))).texture("particle", this.mcLoc("block/copper_block"));
        MultiPartBlockStateBuilder incubatorBuilder = this.getMultipartBuilder((Block)BlockRegistry.INCUBATOR.get());
        ((MultiPartBlockStateBuilder.PartBuilder)incubatorBuilder.part().modelFile((ModelFile)lowerHalfModel).addModel()).condition(IncubatorBlock.HALF, (Comparable[])new DoubleBlockHalf[]{DoubleBlockHalf.LOWER}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)incubatorBuilder.part().modelFile((ModelFile)upperHalfModel).addModel()).condition(IncubatorBlock.HALF, (Comparable[])new DoubleBlockHalf[]{DoubleBlockHalf.UPPER}).end();
        PipeBlock.f_55154_.entrySet().forEach(e -> {
            Direction dir = (Direction)e.getKey();
            if (dir.m_122434_().m_122479_()) {
                ((MultiPartBlockStateBuilder.PartBuilder)incubatorBuilder.part().modelFile((ModelFile)pipeModel).rotationY(((int)dir.m_122435_() + 180) % 360).uvLock(true).addModel()).condition((Property)e.getValue(), (Comparable[])new Boolean[]{true}).condition(IncubatorBlock.HALF, (Comparable[])new DoubleBlockHalf[]{DoubleBlockHalf.LOWER});
            }
        });
        ((ItemModelBuilder)this.itemModels().withExistingParent("incubator", lowerHalfModel.getLocation())).transforms().transform(ItemDisplayContext.GUI).rotation(30.0f, 225.0f, 0.0f).translation(0.0f, -2.0f, 0.0f).scale(0.35f).end().transform(ItemDisplayContext.GROUND).rotation(0.0f, 0.0f, 0.0f).translation(0.0f, 3.0f, 0.0f).scale(0.25f).end().transform(ItemDisplayContext.FIXED).rotation(0.0f, 0.0f, 0.0f).translation(0.0f, 3.0f, 0.0f).scale(0.5f).end().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(75.0f, 45.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, 45.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.4f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(75.0f, 225.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 225.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.4f).end();
    }

    protected void registerIncubatorVessels() {
        BlockModelBuilder incubatorVessel = (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("incubator_vessel")).texture("particle", "minecraft:block/copper_block");
        this.simpleBlock((Block)BlockRegistry.INCUBATOR_MERCURY_VESSEL.get(), (ModelFile)incubatorVessel);
        this.simpleBlock((Block)BlockRegistry.INCUBATOR_SALT_VESSEL.get(), (ModelFile)incubatorVessel);
        this.simpleBlock((Block)BlockRegistry.INCUBATOR_SULFUR_VESSEL.get(), (ModelFile)incubatorVessel);
        ((ItemModelBuilder)this.itemModels().getBuilder("incubator_mercury_vessel")).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"));
        ((ItemModelBuilder)this.itemModels().getBuilder("incubator_salt_vessel")).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"));
        ((ItemModelBuilder)this.itemModels().getBuilder("incubator_sulfur_vessel")).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"));
    }

    protected void registerLiquefactionCauldron() {
        BlockModelBuilder lowerHalfModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("liquefaction_cauldron_lower", this.modLoc("block/liquefaction_cauldron_template"))).ao(false)).texture("texture", this.modLoc("block/liquefaction_cauldron"))).texture("particle", this.mcLoc("block/copper_block"));
        BlockModelBuilder upperHalfModel = (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("liquefaction_cauldron_upper")).texture("particle", "minecraft:block/copper_block");
        this.getVariantBuilder((Block)BlockRegistry.LIQUEFACTION_CAULDRON.get()).forAllStates(s -> {
            BlockModelBuilder model = s.m_61143_(LiquefactionCauldronBlock.HALF) == DoubleBlockHalf.LOWER ? lowerHalfModel : upperHalfModel;
            return ConfiguredModel.builder().modelFile((ModelFile)model).build();
        });
        ((ItemModelBuilder)this.itemModels().withExistingParent("liquefaction_cauldron", lowerHalfModel.getLocation())).transforms().transform(ItemDisplayContext.GUI).rotation(30.0f, 225.0f, 0.0f).translation(0.0f, -2.0f, 0.0f).scale(0.5f).end();
    }

    protected void registerCalcinationOven() {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("calcination_oven")).texture("particle", "minecraft:block/copper_block");
        this.getVariantBuilder((Block)BlockRegistry.CALCINATION_OVEN.get()).forAllStates(s -> ConfiguredModel.builder().modelFile((ModelFile)model).build());
        ((ItemModelBuilder)this.itemModels().getBuilder("calcination_oven")).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"));
    }

    protected void registerPyromanticBrazier() {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("pyromantic_brazier", this.modLoc("block/pyromantic_brazier_template"))).ao(false)).texture("texture", this.modLoc("block/pyromantic_brazier"))).texture("particle", this.mcLoc("block/copper_block"));
        BlockModelBuilder modelLit = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("pyromantic_brazier_lit", this.modLoc("block/pyromantic_brazier_lit_template"))).renderType("cutout_mipped")).texture("texture", this.modLoc("block/pyromantic_brazier_lit"))).texture("particle", this.mcLoc("block/copper_block"))).texture("fire", this.mcLoc("block/campfire_fire"));
        ((VariantBlockStateBuilder)this.getVariantBuilder((Block)BlockRegistry.PYROMANTIC_BRAZIER.get()).partialState().with((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)model).addModel()).partialState().with((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)modelLit).addModel();
        ((ItemModelBuilder)this.itemModels().withExistingParent("pyromantic_brazier", this.modLoc("block/pyromantic_brazier"))).transforms().transform(ItemDisplayContext.GUI).rotation(30.0f, 225.0f, 0.0f).scale(0.5f).end();
    }
}

