/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.theurgy.content.item.AlchemicalSaltItem;
import com.klikli_dev.theurgy.content.item.AlchemicalSulfurItem;
import com.klikli_dev.theurgy.datagen.recipe.JsonRecipeProvider;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import com.klikli_dev.theurgy.registry.SaltRegistry;
import com.klikli_dev.theurgy.registry.SulfurRegistry;
import java.util.function.BiConsumer;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;

public class IncubationRecipeProvider
extends JsonRecipeProvider {
    public static final int TIME = 100;

    public IncubationRecipeProvider(PackOutput packOutput) {
        super(packOutput, "theurgy", "incubation");
    }

    @Override
    void buildRecipes(BiConsumer<ResourceLocation, JsonObject> recipeConsumer) {
        this.makeRecipe(Items.f_42405_, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.CROPS.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.WHEAT.get()));
        this.makeRecipe((TagKey<Item>)Tags.Items.INGOTS_IRON, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.IRON.get()));
        this.makeRecipe((TagKey<Item>)Tags.Items.INGOTS_COPPER, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.COPPER.get()));
        this.makeRecipe((TagKey<Item>)Tags.Items.INGOTS_GOLD, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.GOLD.get()));
        this.makeRecipe((TagKey<Item>)Tags.Items.INGOTS_NETHERITE, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.NETHERITE.get()));
        this.makeRecipe(this.tag("forge:ingots/uranium"), (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.URANIUM.get()));
        this.makeRecipe(this.tag("forge:ingots/silver"), (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.SILVER.get()));
        this.makeRecipe(this.tag("forge:ingots/azure_silver"), (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.AZURE_SILVER.get()));
        this.makeRecipe(this.tag("forge:ingots/zinc"), (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.ZINC.get()));
        this.makeRecipe(this.tag("forge:ingots/osmium"), (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.OSMIUM.get()));
        this.makeRecipe(this.tag("forge:ingots/nickel"), (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.NICKEL.get()));
        this.makeRecipe(this.tag("forge:ingots/lead"), (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.LEAD.get()));
        this.makeRecipe(this.tag("forge:ingots/allthemodium"), (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.ALLTHEMODIUM.get()));
        this.makeRecipe(this.tag("forge:ingots/unobtainium"), (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.UNOBTAINIUM.get()));
        this.makeRecipe(this.tag("forge:ingots/iridium"), (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.IRIDIUM.get()));
        this.makeRecipe(this.tag("forge:ingots/tin"), (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.TIN.get()));
        this.makeRecipe(this.tag("forge:ingots/cinnabar"), (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.CINNABAR.get()));
        this.makeRecipe(this.tag("forge:ingots/crimson_iron"), (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.CRIMSON_IRON.get()));
        this.makeRecipe(this.tag("forge:ingots/platinum"), (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.PLATINUM.get()));
        this.makeRecipe(this.tag("forge:ingots/vibranium"), (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.VIBRANIUM.get()));
        this.makeRecipe(this.tag("forge:gems/diamond"), (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.DIAMOND.get()));
        this.makeRecipe(this.tag("forge:gems/emerald"), (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.EMERALD.get()));
        this.makeRecipe(this.tag("forge:gems/lapis"), (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.LAPIS.get()));
        this.makeRecipe(this.tag("forge:gems/quartz"), (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.QUARTZ.get()));
        this.makeRecipe(this.tag("forge:gems/amethyst"), (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.AMETHYST.get()));
        this.makeRecipe(this.tag("forge:gems/prismarine"), (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.PRISMARINE.get()));
        this.makeRecipe(this.tag("forge:gems/ruby"), (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.RUBY.get()));
        this.makeRecipe(this.tag("forge:gems/apatite"), (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.APATITE.get()));
        this.makeRecipe(this.tag("forge:gems/peridot"), (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.PERIDOT.get()));
        this.makeRecipe(this.tag("forge:gems/fluorite"), (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.FLUORITE.get()));
        this.makeRecipe(this.tag("forge:gems/sapphire"), (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.SAPPHIRE.get()));
        this.makeRecipe(this.tag("forge:gems/sal_ammoniac"), (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.SAL_AMMONIAC.get()));
        this.makeRecipe((TagKey<Item>)Tags.Items.DUSTS_REDSTONE, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.REDSTONE.get()));
        this.makeRecipe((TagKey<Item>)ItemTags.f_13160_, (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.COAL.get()));
        this.makeRecipe(this.tag("forge:gems/sulfur"), (Item)ItemRegistry.MERCURY_SHARD.get(), (AlchemicalSaltItem)((Object)SaltRegistry.MINERAL.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.SULFUR.get()));
    }

    public void makeRecipe(TagKey<Item> result, Item mercury, AlchemicalSaltItem salt, AlchemicalSulfurItem sulfur) {
        this.makeRecipe(result, 1, mercury, salt, sulfur, 100);
    }

    public void makeRecipe(TagKey<Item> result, Item mercury, AlchemicalSaltItem salt, AlchemicalSulfurItem sulfur, int incubationTime) {
        this.makeRecipe(result, 1, mercury, salt, sulfur, incubationTime);
    }

    public void makeRecipe(TagKey<Item> result, int resultCount, Item mercury, AlchemicalSaltItem salt, AlchemicalSulfurItem sulfur, int incubationTime) {
        this.makeRecipe(this.name(result) + "_from_" + this.name(sulfur), result, resultCount, mercury, salt, sulfur, incubationTime);
    }

    public void makeRecipe(String recipeName, TagKey<Item> result, Item mercury, AlchemicalSaltItem salt, AlchemicalSulfurItem sulfur, int incubationTime) {
        this.makeRecipe(recipeName, result, 1, mercury, salt, sulfur, incubationTime);
    }

    public void makeRecipe(String recipeName, TagKey<Item> result, int resultCount, Item mercury, AlchemicalSaltItem salt, AlchemicalSulfurItem sulfur, int incubationTime) {
        JsonObject recipe = this.makeRecipeJson(this.makeItemIngredient(this.locFor((ItemLike)mercury)), this.makeItemIngredient(this.locFor((ItemLike)salt)), this.makeItemIngredient(this.locFor((ItemLike)sulfur)), this.makeTagResult(this.locFor(result), resultCount), incubationTime);
        JsonArray conditions = new JsonArray();
        conditions.add((JsonElement)this.makeTagNotEmptyCondition(result.f_203868_().toString()));
        recipe.add("conditions", (JsonElement)conditions);
        this.recipeConsumer.accept(this.modLoc(recipeName), recipe);
    }

    public void makeRecipe(Item result, Item mercury, AlchemicalSaltItem salt, AlchemicalSulfurItem sulfur) {
        this.makeRecipe(result, 1, mercury, salt, sulfur, 100);
    }

    public void makeRecipe(Item result, Item mercury, AlchemicalSaltItem salt, AlchemicalSulfurItem sulfur, int incubationTime) {
        this.makeRecipe(result, 1, mercury, salt, sulfur, incubationTime);
    }

    public void makeRecipe(Item result, int resultCount, Item mercury, AlchemicalSaltItem salt, AlchemicalSulfurItem sulfur, int incubationTime) {
        this.makeRecipe(this.name(result), result, resultCount, mercury, salt, sulfur, incubationTime);
    }

    public void makeRecipe(String recipeName, Item result, Item mercury, AlchemicalSaltItem salt, AlchemicalSulfurItem sulfur, int incubationTime) {
        this.makeRecipe(recipeName, result, 1, mercury, salt, sulfur, incubationTime);
    }

    public void makeRecipe(String recipeName, Item result, int resultCount, Item mercury, AlchemicalSaltItem salt, AlchemicalSulfurItem sulfur, int incubationTime) {
        this.recipeConsumer.accept(this.modLoc(recipeName), this.makeRecipeJson(this.makeItemIngredient(this.locFor((ItemLike)mercury)), this.makeItemIngredient(this.locFor((ItemLike)salt)), this.makeItemIngredient(this.locFor((ItemLike)sulfur)), this.makeItemResult(this.locFor((ItemLike)result), resultCount), incubationTime));
    }

    public JsonObject makeRecipeJson(JsonObject mercury, JsonObject salt, JsonObject sulfur, JsonObject result, int incubationTime) {
        JsonObject recipe = new JsonObject();
        recipe.addProperty("type", RecipeTypeRegistry.INCUBATION.getId().toString());
        recipe.add("mercury", (JsonElement)mercury);
        recipe.add("salt", (JsonElement)salt);
        recipe.add("sulfur", (JsonElement)sulfur);
        recipe.add("result", (JsonElement)result);
        recipe.addProperty("incubation_time", (Number)incubationTime);
        return recipe;
    }

    public String m_6055_() {
        return "Incubation Recipes";
    }
}

