/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.theurgy.datagen.recipe.JsonRecipeProvider;
import com.klikli_dev.theurgy.registry.FluidRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import com.klikli_dev.theurgy.registry.SulfurRegistry;
import java.util.function.BiConsumer;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.Tags;

public class LiquefactionRecipeProvider
extends JsonRecipeProvider {
    public static final int TIME = 100;

    public LiquefactionRecipeProvider(PackOutput packOutput) {
        super(packOutput, "theurgy", "liquefaction");
    }

    @Override
    void buildRecipes(BiConsumer<ResourceLocation, JsonObject> recipeConsumer) {
        Fluid salAmmoniac = (Fluid)FluidRegistry.SAL_AMMONIAC.get();
        this.makeRecipe((Item)SulfurRegistry.LOGS.get(), (TagKey<Item>)ItemTags.f_13182_, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.WHEAT.get(), Items.f_42405_, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.IRON.get(), 3, (TagKey<Item>)Tags.Items.ORES_IRON, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.COPPER.get(), 3, (TagKey<Item>)Tags.Items.ORES_COPPER, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.GOLD.get(), 3, (TagKey<Item>)Tags.Items.ORES_GOLD, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.NETHERITE.get(), 1, (TagKey<Item>)Tags.Items.ORES_NETHERITE_SCRAP, salAmmoniac, 100);
        this.makeRecipe((Item)SulfurRegistry.URANIUM.get(), 3, this.tag("forge:ores/uranium"), salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.SILVER.get(), 3, this.tag("forge:ores/silver"), salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.AZURE_SILVER.get(), 3, this.tag("forge:ores/azure_silver"), salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.ZINC.get(), 3, this.tag("forge:ores/zinc"), salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.OSMIUM.get(), 3, this.tag("forge:ores/osmium"), salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.NICKEL.get(), 3, this.tag("forge:ores/nickel"), salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.LEAD.get(), 3, this.tag("forge:ores/lead"), salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.ALLTHEMODIUM.get(), 3, this.tag("forge:ores/allthemodium"), salAmmoniac, 100);
        this.makeRecipe((Item)SulfurRegistry.UNOBTAINIUM.get(), 3, this.tag("forge:ores/unobtainium"), salAmmoniac, 100);
        this.makeRecipe((Item)SulfurRegistry.IRIDIUM.get(), 3, this.tag("forge:ores/iridium"), salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.TIN.get(), 3, this.tag("forge:ores/tin"), salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CINNABAR.get(), 3, this.tag("forge:ores/cinnabar"), salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CRIMSON_IRON.get(), 3, this.tag("forge:ores/crimson_iron"), salAmmoniac, 20);
        this.makeRecipe((Item)SulfurRegistry.PLATINUM.get(), 3, this.tag("forge:ores/platinum"), salAmmoniac, 20);
        this.makeRecipe((Item)SulfurRegistry.VIBRANIUM.get(), 3, this.tag("forge:ores/vibranium"), salAmmoniac, 20);
        this.makeRecipe((Item)SulfurRegistry.DIAMOND.get(), 4, (TagKey<Item>)Tags.Items.ORES_DIAMOND, salAmmoniac, 100);
        this.makeRecipe((Item)SulfurRegistry.EMERALD.get(), 4, (TagKey<Item>)Tags.Items.ORES_EMERALD, salAmmoniac, 100);
        this.makeRecipe((Item)SulfurRegistry.LAPIS.get(), 10, (TagKey<Item>)Tags.Items.ORES_LAPIS, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.QUARTZ.get(), 8, (TagKey<Item>)Tags.Items.ORES_QUARTZ, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.RUBY.get(), 6, this.tag("forge:ores/ruby"), salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.APATITE.get(), 8, this.tag("forge:ores/apatite"), salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.PERIDOT.get(), 6, this.tag("forge:ores/peridot"), salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.FLUORITE.get(), 6, this.tag("forge:ores/fluorite"), salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.SAPPHIRE.get(), 6, this.tag("forge:ores/sapphire"), salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.SAL_AMMONIAC.get(), 4, this.tag("forge:ores/sal_ammoniac"), salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.REDSTONE.get(), 9, (TagKey<Item>)Tags.Items.ORES_REDSTONE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.COAL.get(), 4, (TagKey<Item>)Tags.Items.ORES_COAL, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.SULFUR.get(), 6, this.tag("forge:ores/sulfur"), salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.IRON.get(), 2, (TagKey<Item>)Tags.Items.RAW_MATERIALS_IRON, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.COPPER.get(), 2, (TagKey<Item>)Tags.Items.RAW_MATERIALS_COPPER, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.GOLD.get(), 2, (TagKey<Item>)Tags.Items.RAW_MATERIALS_GOLD, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.URANIUM.get(), 2, this.tag("forge:raw_materials/uranium"), salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.AZURE_SILVER.get(), 2, this.tag("forge:raw_materials/azure_silver"), salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.SILVER.get(), 2, this.tag("forge:raw_materials/silver"), salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.ZINC.get(), 2, this.tag("forge:raw_materials/zinc"), salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.OSMIUM.get(), 2, this.tag("forge:raw_materials/osmium"), salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.NICKEL.get(), 2, this.tag("forge:raw_materials/nickel"), salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.LEAD.get(), 2, this.tag("forge:raw_materials/lead"), salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.ALLTHEMODIUM.get(), 2, this.tag("forge:raw_materials/allthemodium"), salAmmoniac, 100);
        this.makeRecipe((Item)SulfurRegistry.UNOBTAINIUM.get(), 2, this.tag("forge:raw_materials/unobtainium"), salAmmoniac, 100);
        this.makeRecipe((Item)SulfurRegistry.IRIDIUM.get(), 2, this.tag("forge:raw_materials/iridium"), salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.TIN.get(), 2, this.tag("forge:raw_materials/tin"), salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CINNABAR.get(), 2, this.tag("forge:raw_materials/cinnabar"), salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CRIMSON_IRON.get(), 2, this.tag("forge:raw_materials/crimson_iron"), salAmmoniac, 20);
        this.makeRecipe((Item)SulfurRegistry.PLATINUM.get(), 2, this.tag("forge:raw_materials/platinum"), salAmmoniac, 20);
        this.makeRecipe((Item)SulfurRegistry.VIBRANIUM.get(), 2, this.tag("forge:raw_materials/vibranium"), salAmmoniac, 20);
        this.makeRecipe((Item)SulfurRegistry.IRON.get(), 1, (TagKey<Item>)Tags.Items.INGOTS_IRON, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.COPPER.get(), 1, (TagKey<Item>)Tags.Items.INGOTS_COPPER, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.GOLD.get(), 1, (TagKey<Item>)Tags.Items.INGOTS_GOLD, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.NETHERITE.get(), 1, (TagKey<Item>)Tags.Items.INGOTS_NETHERITE, salAmmoniac, 100);
        this.makeRecipe((Item)SulfurRegistry.URANIUM.get(), 1, this.tag("forge:ingots/uranium"), salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.SILVER.get(), 1, this.tag("forge:ingots/silver"), salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.AZURE_SILVER.get(), 1, this.tag("forge:ingots/azure_silver"), salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.ZINC.get(), 1, this.tag("forge:ingots/zinc"), salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.OSMIUM.get(), 1, this.tag("forge:ingots/osmium"), salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.NICKEL.get(), 1, this.tag("forge:ingots/nickel"), salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.LEAD.get(), 1, this.tag("forge:ingots/lead"), salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.ALLTHEMODIUM.get(), 1, this.tag("forge:ingots/allthemodium"), salAmmoniac, 100);
        this.makeRecipe((Item)SulfurRegistry.UNOBTAINIUM.get(), 1, this.tag("forge:ingots/unobtainium"), salAmmoniac, 100);
        this.makeRecipe((Item)SulfurRegistry.IRIDIUM.get(), 1, this.tag("forge:ingots/iridium"), salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.TIN.get(), 1, this.tag("forge:ingots/tin"), salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CINNABAR.get(), 1, this.tag("forge:ingots/cinnabar"), salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CRIMSON_IRON.get(), 1, this.tag("forge:ingots/crimson_iron"), salAmmoniac, 20);
        this.makeRecipe((Item)SulfurRegistry.PLATINUM.get(), 1, this.tag("forge:ingots/platinum"), salAmmoniac, 20);
        this.makeRecipe((Item)SulfurRegistry.VIBRANIUM.get(), 1, this.tag("forge:ingots/vibranium"), salAmmoniac, 20);
        this.makeRecipe((Item)SulfurRegistry.DIAMOND.get(), 1, (TagKey<Item>)Tags.Items.GEMS_DIAMOND, salAmmoniac, 100);
        this.makeRecipe((Item)SulfurRegistry.EMERALD.get(), 1, (TagKey<Item>)Tags.Items.GEMS_EMERALD, salAmmoniac, 100);
        this.makeRecipe((Item)SulfurRegistry.LAPIS.get(), 1, (TagKey<Item>)Tags.Items.GEMS_LAPIS, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.QUARTZ.get(), 1, (TagKey<Item>)Tags.Items.GEMS_QUARTZ, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.AMETHYST.get(), 1, (TagKey<Item>)Tags.Items.GEMS_AMETHYST, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.PRISMARINE.get(), 1, (TagKey<Item>)Tags.Items.GEMS_PRISMARINE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.RUBY.get(), 1, this.tag("forge:gems/ruby"), salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.APATITE.get(), 1, this.tag("forge:gems/apatite"), salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.PERIDOT.get(), 1, this.tag("forge:gems/peridot"), salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.FLUORITE.get(), 1, this.tag("forge:gems/fluorite"), salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.SAPPHIRE.get(), 1, this.tag("forge:gems/sapphire"), salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.SAL_AMMONIAC.get(), 1, this.tag("forge:gems/sal_ammoniac"), salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.REDSTONE.get(), 1, (TagKey<Item>)Tags.Items.DUSTS_REDSTONE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.COAL.get(), 1, (TagKey<Item>)ItemTags.f_13160_, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.SULFUR.get(), 1, this.tag("forge:gems/sulfur"), salAmmoniac, 10);
    }

    public void makeRecipe(Item sulfurName, Item ingredient, Fluid solvent, int solventAmount) {
        this.makeRecipe(sulfurName, 1, ingredient, solvent, solventAmount, 100);
    }

    public void makeRecipe(Item sulfur, Item ingredient, Fluid solvent, int solventAmount, int liquefactionTime) {
        this.makeRecipe(sulfur, 1, ingredient, solvent, solventAmount, liquefactionTime);
    }

    public void makeRecipe(Item sulfur, int resultCount, Item ingredient, Fluid solvent, int solventAmount) {
        this.makeRecipe(sulfur, resultCount, ingredient, solvent, solventAmount, 100);
    }

    public void makeRecipe(Item sulfur, int resultCount, Item ingredient, Fluid solvent, int solventAmount, int liquefactionTime) {
        JsonObject nbt = this.makeSulfurNbt(ingredient);
        this.recipeConsumer.accept(this.modLoc(this.name(sulfur)), this.makeRecipeJson(this.makeItemIngredient(this.locFor((ItemLike)ingredient)), this.makeFluidIngredient(this.locFor(solvent)), solventAmount, this.makeItemResult(this.locFor((ItemLike)sulfur), resultCount, nbt), liquefactionTime));
    }

    public void makeRecipe(Item sulfurName, TagKey<Item> ingredient, Fluid solvent, int solventAmount) {
        this.makeRecipe(sulfurName, 1, ingredient, solvent, solventAmount, 100);
    }

    public void makeRecipe(Item sulfurName, TagKey<Item> ingredient, Fluid solvent, int solventAmount, int liquefactionTime) {
        this.makeRecipe(sulfurName, 1, ingredient, solvent, solventAmount, liquefactionTime);
    }

    public void makeRecipe(Item sulfur, int resultCount, TagKey<Item> ingredient, Fluid solvent, int solventAmount) {
        this.makeRecipe(sulfur, resultCount, ingredient, solvent, solventAmount, 100);
    }

    public void makeRecipe(Item sulfur, int resultCount, TagKey<Item> ingredient, Fluid solvent, int solventAmount, int liquefactionTime) {
        String name = this.name(sulfur) + "_from_" + this.name(ingredient);
        JsonObject nbt = this.makeSulfurNbt(ingredient);
        JsonObject recipe = this.makeRecipeJson(this.makeTagIngredient(ingredient.f_203868_()), this.makeFluidIngredient(this.locFor(solvent)), solventAmount, this.makeItemResult(this.locFor((ItemLike)sulfur), resultCount, nbt), liquefactionTime);
        JsonArray conditions = new JsonArray();
        conditions.add((JsonElement)this.makeTagNotEmptyCondition(ingredient.f_203868_().toString()));
        recipe.add("conditions", (JsonElement)conditions);
        this.recipeConsumer.accept(this.modLoc(name), recipe);
    }

    public JsonObject makeSulfurNbt(Item ingredient) {
        JsonObject nbt = new JsonObject();
        nbt.addProperty("theurgy:sulfur.source.id", this.locFor((ItemLike)ingredient).toString());
        return nbt;
    }

    public JsonObject makeSulfurNbt(TagKey<Item> ingredient) {
        JsonObject nbt = new JsonObject();
        nbt.addProperty("theurgy:sulfur.source.id", "#" + ingredient.f_203868_());
        return nbt;
    }

    public JsonObject makeRecipeJson(JsonObject ingredient, JsonObject solvent, int solventAmount, JsonObject result, int liquefactionTime) {
        JsonObject recipe = new JsonObject();
        recipe.addProperty("type", RecipeTypeRegistry.LIQUEFACTION.getId().toString());
        recipe.add("solvent", (JsonElement)solvent);
        recipe.addProperty("solvent_amount", (Number)solventAmount);
        recipe.add("ingredient", (JsonElement)ingredient);
        recipe.add("result", (JsonElement)result);
        recipe.addProperty("liquefaction_time", (Number)liquefactionTime);
        return recipe;
    }

    public String m_6055_() {
        return "Liquefaction Recipes";
    }
}

