/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.registry.ItemRegistry;
import com.klikli_dev.theurgy.datagen.recipe.JsonRecipeProvider;
import java.util.function.BiConsumer;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class ShapelessRecipeProvider
extends JsonRecipeProvider {
    public ShapelessRecipeProvider(PackOutput packOutput) {
        super(packOutput, "theurgy", "crafting/shapeless");
    }

    @Override
    void buildRecipes(BiConsumer<ResourceLocation, JsonObject> recipeConsumer) {
        JsonObject hermeticaNbt = new JsonObject();
        hermeticaNbt.addProperty("modonomicon:book_id", "theurgy:the_hermetica");
        this.makeRecipe("the_hermetica", new RecipeBuilder((ItemLike)ItemRegistry.MODONOMICON.get(), 1, hermeticaNbt).requires((ItemLike)Items.f_42517_).requires((TagKey<Item>)Tags.Items.SAND, 2));
    }

    public void makeRecipe(String name, RecipeBuilder recipe) {
        this.recipeConsumer.accept(this.modLoc(name), recipe.build());
    }

    public String m_6055_() {
        return "Shapeless Crafting Recipes";
    }

    private class RecipeBuilder {
        JsonObject recipe = new JsonObject();

        public RecipeBuilder(ItemLike result) {
            this(result, 1);
        }

        public RecipeBuilder(ItemLike result, int count) {
            this(result, count, null);
        }

        public RecipeBuilder(ItemLike result, @Nullable int count, JsonObject nbt) {
            this(shapelessRecipeProvider.makeItemResult(shapelessRecipeProvider.locFor(result), count, nbt));
        }

        public RecipeBuilder(JsonObject result) {
            this.recipe.addProperty("type", ForgeRegistries.RECIPE_SERIALIZERS.getKey((Object)RecipeSerializer.f_44077_).toString());
            this.recipe.add("result", (JsonElement)result);
            this.recipe.add("ingredients", (JsonElement)new JsonArray());
        }

        public RecipeBuilder requires(TagKey<Item> tag, int count) {
            for (int i = 0; i < count; ++i) {
                this.requires(tag);
            }
            return this;
        }

        public RecipeBuilder requires(TagKey<Item> tag) {
            return this.requires(ShapelessRecipeProvider.this.makeTagIngredient(ShapelessRecipeProvider.this.locFor(tag)));
        }

        public RecipeBuilder requires(ItemLike item, int count) {
            for (int i = 0; i < count; ++i) {
                this.requires(item);
            }
            return this;
        }

        public RecipeBuilder requires(ItemLike item) {
            return this.requires(ShapelessRecipeProvider.this.makeItemIngredient(ShapelessRecipeProvider.this.locFor(item)));
        }

        public RecipeBuilder requires(JsonObject ingredient) {
            this.recipe.getAsJsonArray("ingredients").add((JsonElement)ingredient);
            return this;
        }

        public JsonObject build() {
            return this.recipe;
        }
    }
}

