/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.integration.jei.recipes;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.klikli_dev.theurgy.content.gui.GuiTextures;
import com.klikli_dev.theurgy.content.recipe.AccumulationRecipe;
import com.klikli_dev.theurgy.integration.jei.JeiDrawables;
import com.klikli_dev.theurgy.integration.jei.JeiRecipeTypes;
import com.klikli_dev.theurgy.registry.BlockRegistry;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;

public class AccumulationCategory
implements IRecipeCategory<AccumulationRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final Component localizedName;
    private final LoadingCache<Integer, IDrawableAnimated> cachedAnimatedArrow;

    public AccumulationCategory(final IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(82, 40);
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)BlockRegistry.SAL_AMMONIAC_ACCUMULATOR.get()));
        this.localizedName = Component.m_237115_((String)"theurgy.jei.category.accumulation");
        this.cachedAnimatedArrow = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer cookTime) {
                return JeiDrawables.asAnimatedDrawable(guiHelper, GuiTextures.JEI_ARROW_RIGHT_FULL, cookTime, IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    public static IRecipeSlotTooltipCallback addFluidTooltip(int overrideAmount) {
        return (view, tooltip) -> {
            Optional displayed = view.getDisplayedIngredient((IIngredientType)ForgeTypes.FLUID_STACK);
            if (displayed.isEmpty()) {
                return;
            }
            FluidStack fluidStack = (FluidStack)displayed.get();
            int amount = overrideAmount == -1 ? fluidStack.getAmount() : overrideAmount;
            MutableComponent text = Component.m_237110_((String)"theurgy.misc.unit.millibuckets", (Object[])new Object[]{amount}).m_130940_(ChatFormatting.GOLD);
            if (tooltip.isEmpty()) {
                tooltip.add(0, text);
            } else {
                List siblings = ((Component)tooltip.get(0)).m_7360_();
                siblings.add(Component.m_237113_((String)" "));
                siblings.add(text);
            }
        };
    }

    protected IDrawableAnimated getAnimatedArrow(AccumulationRecipe recipe) {
        int cookTime = recipe.getAccumulationTime();
        if (cookTime <= 0) {
            cookTime = 100;
        }
        return (IDrawableAnimated)this.cachedAnimatedArrow.getUnchecked((Object)cookTime);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(AccumulationRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        GuiTextures.JEI_ARROW_RIGHT_EMPTY.render(guiGraphics, 24, 2);
        this.getAnimatedArrow(recipe).draw(guiGraphics, 24, 2);
        this.drawCookTime(recipe, guiGraphics, 29);
    }

    protected void drawCookTime(AccumulationRecipe recipe, GuiGraphics guiGraphics, int y) {
        int cookTime = recipe.getAccumulationTime();
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            MutableComponent timeString = Component.m_237110_((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            Minecraft minecraft = Minecraft.m_91087_();
            Font font = minecraft.f_91062_;
            int stringWidth = font.m_92852_((FormattedText)timeString);
            guiGraphics.m_280614_(font, (Component)timeString, this.background.getWidth() - stringWidth, y, -8355712, false);
        }
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AccumulationRecipe recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).setBackground(JeiDrawables.INPUT_SLOT, -1, -1).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, List.of(recipe.getEvaporant().getFluids()))).addTooltipCallback(AccumulationCategory.addFluidTooltip(recipe.getEvaporantAmount()));
        if (recipe.hasSolute()) {
            builder.addSlot(RecipeIngredientRole.INPUT, 1, 21).setBackground(JeiDrawables.INPUT_SLOT, -1, -1).addIngredients(recipe.getSolute());
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 56, 1).setBackground(JeiDrawables.INPUT_SLOT, -1, -1).addFluidStack(recipe.getResult().getFluid(), (long)recipe.getResult().getAmount())).addTooltipCallback(AccumulationCategory.addFluidTooltip(recipe.getResult().getAmount()));
        builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStack(new ItemStack((ItemLike)recipe.getResult().getFluid().m_6859_()));
    }

    public RecipeType<AccumulationRecipe> getRecipeType() {
        return JeiRecipeTypes.ACCUMULATION;
    }
}

