/*
 * Decompiled with CFR 0.152.
 */
package com.haoict.tiab.common.core.api;

import com.haoict.tiab.common.config.TiabConfig;
import com.haoict.tiab.common.core.ItemRegistry;
import com.haoict.tiab.common.core.api.APIHooks;
import com.haoict.tiab.common.core.api.APIRegistry;
import com.haoict.tiab.common.core.api.interfaces.ITimeInABottleCommandAPI;
import com.haoict.tiab.common.core.api.interfaces.ITimeInABottleItemAPI;
import com.haoict.tiab.common.items.TimeInABottleItem;
import com.haoict.tiab.common.utils.Utils;
import com.magorage.tiab.api.ITimeInABottleAPI;
import com.magorage.tiab.api.TiabProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.registries.RegistryObject;

public final class TimeInABottleAPI
implements ITimeInABottleAPI {
    private final String API_MOD_ID;
    private final APIRegistry REGISTRY = APIRegistry.getAPI();

    private TimeInABottleAPI(String API_MOD_ID) {
        this.API_MOD_ID = API_MOD_ID;
    }

    @Override
    public RegistryObject<Item> getRegistryObject() {
        return ItemRegistry.timeInABottleItem;
    }

    @Override
    public String getModID() {
        return "tiab";
    }

    @Override
    public int getTotalTime(ItemStack bottle) {
        ITimeInABottleItemAPI api = this.REGISTRY.getRegistered(ITimeInABottleItemAPI.class);
        if (api != null && bottle.m_41720_() instanceof TimeInABottleItem) {
            return api.getTotalAccumulatedTime(bottle);
        }
        return 0;
    }

    @Override
    public int getStoredTime(ItemStack bottle) {
        ITimeInABottleItemAPI api = this.REGISTRY.getRegistered(ITimeInABottleItemAPI.class);
        if (api != null && bottle.m_41720_() instanceof TimeInABottleItem) {
            return api.getStoredEnergy(bottle);
        }
        return 0;
    }

    @Override
    public void setStoredTime(ItemStack bottle, int time) {
        ITimeInABottleItemAPI api = this.REGISTRY.getRegistered(ITimeInABottleItemAPI.class);
        if (api != null && this.canUse() && bottle.m_41720_() instanceof TimeInABottleItem) {
            api.setStoredEnergy(bottle, time);
        }
    }

    @Override
    public void setTotalTime(ItemStack bottle, int time) {
        ITimeInABottleItemAPI api = this.REGISTRY.getRegistered(ITimeInABottleItemAPI.class);
        if (api != null && this.canUse() && bottle.m_41720_() instanceof TimeInABottleItem) {
            api.setTotalAccumulatedTime(bottle, time);
        }
    }

    @Override
    public int processCommand(Function<ServerPlayer, ItemStack> itemStackFunction, ServerPlayer player, String messageValue, boolean isAdd) {
        ITimeInABottleCommandAPI api = this.REGISTRY.getRegistered(ITimeInABottleCommandAPI.class);
        if (api != null && this.canUse()) {
            return api.processCommand(itemStackFunction, player, messageValue, isAdd);
        }
        return 0;
    }

    @Override
    public Component getTotalTimeTranslated(ItemStack stack) {
        return Utils.getTotalTimeTranslated(stack);
    }

    @Override
    public Component getStoredTimeTranslated(ItemStack stack) {
        return Utils.getStoredTimeTranslated(stack);
    }

    @Override
    public void playSound(Level level, BlockPos pos, int nextRate) {
        ITimeInABottleItemAPI api = this.REGISTRY.getRegistered(ITimeInABottleItemAPI.class);
        if (api != null && this.canUse()) {
            api.playSound(level, pos, nextRate);
        }
    }

    @Override
    public void applyDamage(ItemStack stack, int damage) {
        ITimeInABottleItemAPI api = this.REGISTRY.getRegistered(ITimeInABottleItemAPI.class);
        if (api != null && this.canUse()) {
            api.applyDamage(stack, damage);
        }
    }

    @Override
    public int getEnergyCost(int timeRate) {
        ITimeInABottleItemAPI api = this.REGISTRY.getRegistered(ITimeInABottleItemAPI.class);
        if (api != null) {
            return api.getEnergyCost(timeRate);
        }
        return -1;
    }

    @Override
    public boolean canUse() {
        return !((List)TiabConfig.COMMON.MODS_API.get()).contains(this.API_MOD_ID);
    }

    @Override
    public boolean callCommandEvent(ServerPlayer player, int messageValue, boolean isAdd) {
        if (this.API_MOD_ID.equals("tiab")) {
            return APIHooks.getHooks().fireCommandEvent(player, messageValue, isAdd);
        }
        return false;
    }

    @Override
    public boolean callTickEvent(ServerPlayer player, ItemStack stack) {
        if (this.API_MOD_ID.equals("tiab")) {
            return APIHooks.getHooks().fireTickEvent(player, stack);
        }
        return false;
    }

    @Override
    public boolean callUseEvent(ItemStack bottle, Player player, Level level, BlockPos pos) {
        if (this.API_MOD_ID.equals("tiab")) {
            return APIHooks.getHooks().fireUseEvent(bottle, player, level, pos);
        }
        return false;
    }

    @Override
    public InteractionResult accelerateBlock(ITimeInABottleAPI API, ItemStack stack, Player player, Level level, BlockPos pos) {
        ITimeInABottleItemAPI api = this.REGISTRY.getRegistered(ITimeInABottleItemAPI.class);
        if (api != null) {
            return api.accelerateBlock(API, stack, player, level, pos);
        }
        return InteractionResult.FAIL;
    }

    private static class IMC {
        private IMC() {
        }

        private static void imcProcess(InterModProcessEvent event) {
            ArrayList PROCESSED_MODS = new ArrayList();
            event.getIMCStream("get_api"::equals).forEach(e -> {
                Object patt1918$temp = e.messageSupplier().get();
                if (patt1918$temp instanceof TiabProvider) {
                    TiabProvider provider = (TiabProvider)patt1918$temp;
                    if (PROCESSED_MODS.contains(provider.getModID())) {
                        throw new IllegalStateException("Some mod tried to get API for TIAB when it already has been given one! Mods can only get one API! %s mod tried to do this!".formatted(e.senderModId()));
                    }
                    TimeInABottleAPI api = new TimeInABottleAPI(provider.getModID());
                    provider.setAPI(api);
                    APIHooks.getHooks().addEventCallbacks(provider.getHooks());
                    provider.setFinalized();
                    PROCESSED_MODS.add(provider.getModID());
                }
            });
        }
    }

    public static class IMCPublic {
        public static void load(IEventBus bus) {
            bus.addListener(IMC::imcProcess);
        }
    }
}

