/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.component.bundle;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.block.tile.BasicTile;
import com.hrznstudio.titanium.client.screen.addon.LockableOverlayAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonInfo;
import com.hrznstudio.titanium.component.IComponentBundle;
import com.hrznstudio.titanium.component.IComponentHandler;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.container.addon.IContainerAddon;
import com.hrznstudio.titanium.util.LangUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.INBTSerializable;

public class LockableInventoryBundle<T extends BasicTile>
implements IComponentBundle,
INBTSerializable<CompoundTag> {
    private InventoryComponent<T> inventory;
    private BiPredicate<ItemStack, Integer> cachedFilter;
    private ButtonComponent buttonAddon;
    private T componentHarness;
    private ItemStack[] filter;
    private int lockPosX;
    private int lockPosY;
    private boolean isLocked;

    public LockableInventoryBundle(T componentHarness, final InventoryComponent<T> inventory, int lockPosX, int lockPosY, boolean isLocked) {
        this.componentHarness = componentHarness;
        this.inventory = inventory;
        this.cachedFilter = inventory.getInsertPredicate();
        this.filter = new ItemStack[this.inventory.getSlots()];
        Arrays.fill(this.filter, ItemStack.f_41583_);
        this.lockPosX = lockPosX;
        this.lockPosY = lockPosY;
        this.isLocked = isLocked;
        this.buttonAddon = new ButtonComponent(lockPosX, lockPosY, 14, 14){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new StateButtonAddon(LockableInventoryBundle.this.buttonAddon, new StateButtonInfo[]{new StateButtonInfo(0, AssetTypes.BUTTON_UNLOCKED, ChatFormatting.GOLD + LangUtil.getString("tooltip.titanium.locks", new Object[0]) + ChatFormatting.WHITE + " " + LangUtil.getString("tooltip.titanium.facing_handler." + inventory.getName().toLowerCase(), new Object[0])), new StateButtonInfo(1, AssetTypes.BUTTON_LOCKED, ChatFormatting.GOLD + LangUtil.getString("tooltip.titanium.unlocks", new Object[0]) + ChatFormatting.WHITE + " " + LangUtil.getString("tooltip.titanium.facing_handler." + inventory.getName().toLowerCase(), new Object[0]))}){

                    @Override
                    public int getState() {
                        return LockableInventoryBundle.this.isLocked ? 1 : 0;
                    }
                });
            }
        }.setPredicate((playerEntity, compoundNBT) -> {
            this.isLocked = !this.isLocked;
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                this.filter[i] = this.inventory.getStackInSlot(i).m_41777_();
            }
            this.updateFilter();
            ((BasicTile)this.componentHarness).syncObject(this);
        });
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        return this.inventory instanceof SidedInventoryComponent ? Collections.singletonList(() -> new LockableOverlayAddon((SidedInventoryComponent)this.inventory, this.lockPosX, this.lockPosY)) : Collections.emptyList();
    }

    @Override
    public void accept(IComponentHandler ... handler) {
        for (IComponentHandler iComponentHandler : handler) {
            iComponentHandler.add(this.inventory, this.buttonAddon);
        }
    }

    @Override
    @Nonnull
    public List<IFactory<? extends IContainerAddon>> getContainerAddons() {
        return Collections.emptyList();
    }

    public CompoundTag serializeNBT() {
        CompoundTag compoundNBT = new CompoundTag();
        compoundNBT.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        compoundNBT.m_128379_("Locked", this.isLocked);
        ListTag nbt = new ListTag();
        for (ItemStack stack : this.filter) {
            nbt.add((Object)stack.serializeNBT());
        }
        compoundNBT.m_128365_("Filter", (Tag)nbt);
        return compoundNBT;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.inventory.deserializeNBT(nbt.m_128469_("Inventory"));
        this.isLocked = nbt.m_128471_("Locked");
        ListTag list = (ListTag)nbt.m_128423_("Filter");
        this.filter = new ItemStack[list.size()];
        Arrays.fill(this.filter, ItemStack.f_41583_);
        for (int i = 0; i < list.size(); ++i) {
            this.filter[i] = ItemStack.m_41712_((CompoundTag)list.m_128728_(i));
        }
        this.updateFilter();
    }

    private void updateFilter() {
        if (this.isLocked) {
            this.inventory.setInputFilter((stack, integer) -> integer < this.filter.length && !this.filter[integer].m_41619_() && ItemStack.m_150942_((ItemStack)this.filter[integer], (ItemStack)stack));
        } else {
            Arrays.fill(this.filter, ItemStack.f_41583_);
            this.inventory.setInputFilter(this.cachedFilter);
        }
        for (int i = 0; i < this.filter.length; ++i) {
            this.inventory.setSlotToItemStackRender(i, this.filter[i]);
        }
    }

    public InventoryComponent<T> getInventory() {
        return this.inventory;
    }
}

