/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.command.ISubCommand;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.BackupService;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;

public final class CommandTBRecovery
extends TombstoneCommand {
    private final SuggestionProvider<CommandSourceStack> SUGGESTION_PLAYER_SAVES = (ctx, build) -> {
        File[] matchingFiles;
        File checkedFile;
        String playerName = StringArgumentType.getString((CommandContext)ctx, (String)"player");
        GameProfile profil = EntityHelper.getGameProfile(((CommandSourceStack)ctx.getSource()).m_81377_(), playerName);
        List<Object> list = new ArrayList();
        if (profil != null && (checkedFile = new File(((CommandSourceStack)ctx.getSource()).m_81377_().m_129843_(SAVE_FOLDER).toFile(), profil.getId().toString())).exists() && (matchingFiles = checkedFile.listFiles((file, name) -> name.endsWith(".save"))) != null) {
            list = Arrays.stream(matchingFiles).map(p -> p.getName().replace(".save", "")).collect(Collectors.toList());
            list.add(".latest");
            list.add(".oldest");
        }
        return SharedSuggestionProvider.m_82970_(list, (SuggestionsBuilder)build);
    };
    private final SuggestionProvider<CommandSourceStack> SUGGESTION_SAVED_PLAYERS = (ctx, build) -> {
        File[] matchingFiles;
        ArrayList<String> list = new ArrayList<String>();
        File checkedFile = ((CommandSourceStack)ctx.getSource()).m_81377_().m_129843_(SAVE_FOLDER).toFile();
        if (checkedFile.exists() && (matchingFiles = checkedFile.listFiles((file, name) -> file.isDirectory())) != null) {
            for (File file2 : matchingFiles) {
                try {
                    UUID uuid = UUID.fromString(file2.getName());
                    GameProfile profil = EntityHelper.getGameProfile(((CommandSourceStack)ctx.getSource()).m_81377_(), uuid);
                    if (profil == null) continue;
                    list.add(profil.getName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return SharedSuggestionProvider.m_82970_(list, (SuggestionsBuilder)build);
    };
    private static final LevelResource SAVE_FOLDER = new LevelResource("tombstone/saved_players");

    @Override
    protected TombstoneCommand.CommandName getCommandName() {
        return TombstoneCommand.CommandName.RECOVERY;
    }

    @Override
    LiteralArgumentBuilder<CommandSourceStack> getBuilder(LiteralArgumentBuilder<CommandSourceStack> builder, CommandBuildContext buildContext) {
        builder.executes(this::showUsage);
        builder.then(SubCommand.SAVE_ALL_PLAYERS.literal().executes(c -> CommandTBRecovery.saveAllPlayers(((CommandSourceStack)c.getSource()).m_81377_(), success -> this.sendMessage((CommandSourceStack)c.getSource(), (success ? LangKey.MESSAGE_RECOVERY_SAVE_ALL_PLAYERS_SUCCESS : LangKey.MESSAGE_RECOVERY_SAVE_ALL_PLAYERS_FAILED).getText(new Object[0]), true))));
        builder.then(((LiteralArgumentBuilder)SubCommand.SAVE_PLAYER.literal().executes(this::showUsage)).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(c -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)c, (String)"player");
            return CommandTBRecovery.savePlayer(player, success -> this.sendMessage((CommandSourceStack)c.getSource(), (success ? LangKey.MESSAGE_RECOVERY_SAVE_PLAYER_SUCCESS : LangKey.MESSAGE_RECOVERY_SAVE_PLAYER_FAILED).getText(player.m_7755_()), false));
        })));
        builder.then(((LiteralArgumentBuilder)SubCommand.LOAD_PLAYER.literal().executes(this::showUsage)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.word()).suggests(this.SUGGESTION_SAVED_PLAYERS).executes(c -> {
            String playerName = StringArgumentType.getString((CommandContext)c, (String)"player");
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81377_().m_6846_().m_11255_(playerName);
            if (player != null) {
                return this.loadPlayer((CommandSourceStack)c.getSource(), player, ".latest");
            }
            GameProfile profil = EntityHelper.getGameProfile(((CommandSourceStack)c.getSource()).m_81377_(), playerName);
            if (profil == null) {
                throw EntityArgument.f_91438_.create();
            }
            return this.recoverPlayerOffline((CommandSourceStack)c.getSource(), profil, ".latest");
        })).then(Commands.m_82129_((String)"file_string", (ArgumentType)StringArgumentType.word()).suggests(this.SUGGESTION_PLAYER_SAVES).executes(c -> {
            String playerName = StringArgumentType.getString((CommandContext)c, (String)"player");
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81377_().m_6846_().m_11255_(playerName);
            if (player != null) {
                return this.loadPlayer((CommandSourceStack)c.getSource(), player, StringArgumentType.getString((CommandContext)c, (String)"file_string"));
            }
            GameProfile profil = EntityHelper.getGameProfile(((CommandSourceStack)c.getSource()).m_81377_(), playerName);
            if (profil == null) {
                throw EntityArgument.f_91438_.create();
            }
            return this.recoverPlayerOffline((CommandSourceStack)c.getSource(), profil, StringArgumentType.getString((CommandContext)c, (String)"file_string"));
        }))));
        return builder;
    }

    public static int saveAllPlayers(MinecraftServer server, BooleanConsumer consumer) {
        File baseFolder = server.m_129843_(SAVE_FOLDER).toFile();
        if (!baseFolder.exists() && !baseFolder.mkdirs()) {
            ModTombstone.LOGGER.warn("The backup folder for players cannot be created");
            consumer.accept(false);
            return 1;
        }
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        boolean hasPlayerSkipped = false;
        for (ServerPlayer player : server.m_6846_().m_11314_()) {
            if (!player.m_6084_() || player.m_5833_()) continue;
            File playerFolder = CommandTBRecovery.getPlayerFolder(player);
            if (playerFolder == null) {
                hasPlayerSkipped = true;
                continue;
            }
            pairs.add(Pair.of((Object)player.m_20240_(new CompoundTag()), (Object)playerFolder));
        }
        if (pairs.size() == 0) {
            consumer.accept(true);
            return 1;
        }
        boolean skipped = hasPlayerSkipped;
        BackupService.get().execute(() -> {
            boolean wasSuccessful = !skipped;
            for (Pair pair : pairs) {
                boolean success = CommandTBRecovery.savePlayerData((CompoundTag)pair.getLeft(), (File)pair.getRight());
                if (success) continue;
                wasSuccessful = false;
            }
            boolean isSuccessful = wasSuccessful;
            server.m_18689_(() -> consumer.accept(isSuccessful));
        });
        return 1;
    }

    public static int savePlayer(ServerPlayer player, BooleanConsumer consumer) {
        CommandTBRecovery.checkAlive((Entity)player);
        CommandTBRecovery.checkNotSpectator((Entity)player);
        File playerFolder = CommandTBRecovery.getPlayerFolder(player);
        if (playerFolder == null) {
            consumer.accept(false);
            return 1;
        }
        MinecraftServer listener = player.m_9236_().m_7654_();
        CompoundTag tag = player.m_20240_(new CompoundTag());
        BackupService.get().execute(() -> CommandTBRecovery.lambda$savePlayer$9(tag, playerFolder, (BlockableEventLoop)listener, consumer));
        return 1;
    }

    private static boolean savePlayerData(CompoundTag tag, File saveFolder) {
        boolean bl;
        String dateString = new SimpleDateFormat("yyyyMMdd-HHmmss", Locale.US).format(new Date());
        FileWriter writer = new FileWriter(new File(saveFolder, dateString + ".save"));
        try {
            writer.write(tag.toString());
            writer.close();
            File[] matchingFiles = saveFolder.listFiles((file, name) -> name.endsWith(".save"));
            if (matchingFiles != null && matchingFiles.length > (Integer)ConfigTombstone.recovery.recoveryPlayerMaxSaves.get()) {
                int diff = matchingFiles.length - (Integer)ConfigTombstone.recovery.recoveryPlayerMaxSaves.get();
                Arrays.sort(matchingFiles, Comparator.comparingLong(File::lastModified));
                int num = 0;
                for (File file2 : matchingFiles) {
                    if (num >= diff) break;
                    file2.delete();
                    ++num;
                }
            }
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        writer.close();
        return bl;
    }

    @Nullable
    private static File getPlayerFolder(ServerPlayer player) {
        File saveFolder = new File(player.m_9236_().m_7654_().m_129843_(SAVE_FOLDER).toFile(), "" + player.m_36316_().getId());
        if (!saveFolder.exists() && !saveFolder.mkdirs()) {
            ModTombstone.LOGGER.warn("The backup folder cannot be created");
            return null;
        }
        return saveFolder;
    }

    private int recoverPlayerOffline(CommandSourceStack sender, GameProfile profil, String fileString) {
        ServerPlayer player = EntityHelper.getPlayerForLogin(sender.m_81377_(), profil);
        try (BufferedReader reader = new BufferedReader(new FileReader(this.getBackupFile(sender, profil.getId(), fileString)));){
            CompoundTag nbt = TagParser.m_129359_((String)reader.readLine());
            reader.close();
            if (!nbt.m_128431_().isEmpty()) {
                player.m_20258_(nbt);
                EntityHelper.writePlayerData(sender.m_81377_(), (Player)player);
                this.sendMessage(sender, LangKey.MESSAGE_RECOVERY_LOAD_PLAYER_SUCCESS.getText(player.m_7755_()), false);
            }
        }
        catch (Exception e) {
            throw LangKey.MESSAGE_RECOVERY_LOAD_PLAYER_FAILED.asCommandException(player.m_7755_());
        }
        return 1;
    }

    private int loadPlayer(CommandSourceStack sender, ServerPlayer player, String fileString) {
        block10: {
            CommandTBRecovery.checkAlive((Entity)player);
            CommandTBRecovery.checkNotSpectator((Entity)player);
            File file = this.getBackupFile(sender, player.m_36316_().getId(), fileString);
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                CompoundTag nbt = TagParser.m_129359_((String)reader.readLine());
                reader.close();
                if (!nbt.m_128456_()) {
                    ServerLevel targetWorld;
                    ResourceKey sourceDim = player.m_9236_().m_46472_();
                    ResourceKey targetDim = NBTStackHelper.getWorldKey(nbt, "Dimension");
                    MinecraftServer server = sender.m_81377_();
                    if (targetDim == null || (targetWorld = sender.m_81377_().m_129880_(targetDim)) == null) {
                        targetDim = Level.f_46428_;
                        targetWorld = server.m_129783_();
                    }
                    ListTag pos = nbt.m_128437_("Pos", 6);
                    double x = pos.m_128772_(0);
                    double y = pos.m_128772_(1);
                    double z = pos.m_128772_(2);
                    nbt.m_128473_("Dimension");
                    nbt.m_128473_("Pos");
                    nbt.m_128473_("Rotation");
                    player.deserializeNBT(nbt);
                    Helper.teleport(player, x, y, z, targetWorld);
                    if (sourceDim == targetDim) {
                        player.f_8906_.m_9829_((Packet)new ClientboundPlayerAbilitiesPacket(player.m_150110_()));
                        server.m_6846_().m_11229_(player, targetWorld);
                        server.m_6846_().m_11292_(player);
                        player.m_21220_().forEach(e -> player.f_8906_.m_9829_((Packet)new ClientboundUpdateMobEffectPacket(player.m_19879_(), e)));
                        player.f_8920_ = -1;
                        player.f_8917_ = -1.0f;
                        player.f_8918_ = -1;
                        ForgeEventFactory.firePlayerRespawnEvent((Player)player, (boolean)false);
                    }
                    LangKey.MESSAGE_RECOVERY_LOAD_PLAYER_TARGET_SUCCESS.sendMessage((Player)player, StyleType.MESSAGE_SPELL, new Object[0]);
                    this.sendMessage(sender, LangKey.MESSAGE_RECOVERY_LOAD_PLAYER_SUCCESS.getText(player.m_7755_()), false);
                    break block10;
                }
                throw LangKey.MESSAGE_RECOVERY_LOAD_PLAYER_FAILED.asCommandException(player.m_7755_());
            }
            catch (Throwable e2) {
                throw LangKey.MESSAGE_RECOVERY_LOAD_PLAYER_FAILED.asCommandException(player.m_7755_());
            }
        }
        return 1;
    }

    private File getBackupFile(CommandSourceStack sender, UUID id, String fileString) {
        Object fileName;
        File saveFolder = new File(sender.m_81377_().m_129843_(SAVE_FOLDER).toFile(), "" + id);
        if (!saveFolder.exists()) {
            throw LangKey.MESSAGE_RECOVERY_NO_FOLDER.asCommandException(saveFolder.getAbsolutePath());
        }
        if (fileString.equals(".latest") || fileString.equals(".oldest")) {
            File[] saveFiles = saveFolder.listFiles(p -> p.isFile() && p.getName().endsWith(".save"));
            if (saveFiles == null || saveFiles.length == 0) {
                throw LangKey.MESSAGE_RECOVERY_NO_FILE.asCommandException(fileString);
            }
            Optional<File> res = fileString.equals(".latest") ? Stream.of(saveFiles).max(File::compareTo) : Stream.of(saveFiles).min(File::compareTo);
            fileName = res.get().getName();
        } else {
            fileName = fileString + ".save";
            File[] files = saveFolder.listFiles(arg_0 -> CommandTBRecovery.lambda$getBackupFile$13((String)fileName, arg_0));
            if (files == null || files.length == 0) {
                throw LangKey.MESSAGE_RECOVERY_NO_FILE.asCommandException(fileName);
            }
        }
        return new File(saveFolder, (String)fileName);
    }

    private static /* synthetic */ boolean lambda$getBackupFile$13(String fileName, File p) {
        return p.isFile() && p.getName().equals(fileName);
    }

    private static /* synthetic */ void lambda$savePlayer$9(CompoundTag tag, File playerFolder, BlockableEventLoop listener, BooleanConsumer consumer) {
        boolean result = CommandTBRecovery.savePlayerData(tag, playerFolder);
        listener.m_18689_(() -> consumer.accept(result));
    }

    private static enum SubCommand implements ISubCommand
    {
        SAVE_ALL_PLAYERS,
        SAVE_PLAYER,
        LOAD_PLAYER;

    }
}

