/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.config.ConfigTombstone;

public final class PlayerPreference {
    private static final Map<UUID, PlayerPreference> PLAYER_PREFERENCES = new ConcurrentHashMap<UUID, PlayerPreference>();
    private static final PlayerPreference DEFAULT_PREFERENCE = new PlayerPreference(GraveModel.getDefault(), BlockGraveMarble.MarbleType.getDefault(), ConfigTombstone.Client.GraveSpawnRule.getDefault(), ConfigTombstone.Client.AutoEquipRule.getDefault(), false, false, true, false, true, true);
    private GraveModel graveModel;
    private BlockGraveMarble.MarbleType marbleType;
    private ConfigTombstone.Client.GraveSpawnRule graveSpawnRule;
    private ConfigTombstone.Client.AutoEquipRule autoEquipRule;
    private boolean equipElytraInPriority;
    private boolean equipCurioSlotMagicBook;
    private boolean knowledgeMessage;
    private boolean priorizeToolOnHotbar;
    private boolean activateGraveBySneaking;
    private boolean allowGraveInWater;

    private PlayerPreference(GraveModel graveModel, BlockGraveMarble.MarbleType marbleType, ConfigTombstone.Client.GraveSpawnRule graveSpawnRule, ConfigTombstone.Client.AutoEquipRule autoEquipRule, boolean equipElytraInPriority, boolean equipCurioSlotMagicBook, boolean knowledgeMessage, boolean priorizeToolOnHotbar, boolean activateGraveBySneaking, boolean allowGraveInWater) {
        this.graveModel = graveModel;
        this.marbleType = marbleType;
        this.graveSpawnRule = graveSpawnRule;
        this.autoEquipRule = autoEquipRule;
        this.equipElytraInPriority = equipElytraInPriority;
        this.equipCurioSlotMagicBook = equipCurioSlotMagicBook;
        this.knowledgeMessage = knowledgeMessage;
        this.priorizeToolOnHotbar = priorizeToolOnHotbar;
        this.activateGraveBySneaking = activateGraveBySneaking;
        this.allowGraveInWater = allowGraveInWater;
    }

    public GraveModel getFavoriteGrave() {
        return this.graveModel;
    }

    public BlockGraveMarble.MarbleType getMarbleType() {
        return this.marbleType;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setFavoriteGrave(@Nullable GraveModel graveModel) {
        this.graveModel = Optional.ofNullable(graveModel).orElse(GraveModel.getDefault());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setMarbleType(@Nullable BlockGraveMarble.MarbleType marbleType) {
        this.marbleType = Optional.ofNullable(marbleType).orElse(BlockGraveMarble.MarbleType.getDefault());
    }

    public boolean hasSameFavoriteGrave(PlayerPreference aPlayerPreference) {
        return this.hasSameFavoriteGrave(aPlayerPreference.getFavoriteGrave(), aPlayerPreference.getMarbleType());
    }

    private boolean hasSameFavoriteGrave(GraveModel graveModel, BlockGraveMarble.MarbleType marbleType) {
        return this.getFavoriteGrave() == graveModel && this.getMarbleType() == marbleType;
    }

    public boolean equipElytraInPriority() {
        return this.equipElytraInPriority;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setEquipElytraInPriority(boolean flag) {
        this.equipElytraInPriority = flag;
    }

    public boolean equipCurioSlotMagicBook() {
        return this.equipCurioSlotMagicBook;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setEquipCurioSlotMagicBook(boolean flag) {
        this.equipCurioSlotMagicBook = flag;
    }

    public boolean displayKnowledgeMessage() {
        return this.knowledgeMessage;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setDisplayKnowledgeMessage(boolean flag) {
        this.knowledgeMessage = flag;
    }

    public boolean priorizeToolOnHotbar() {
        return this.priorizeToolOnHotbar;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setPriorizeToolOnHotbar(boolean flag) {
        this.priorizeToolOnHotbar = flag;
    }

    public boolean activateGraveBySneaking() {
        return this.activateGraveBySneaking;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setActivateGraveBySneaking(boolean flag) {
        this.activateGraveBySneaking = flag;
    }

    public boolean allowGraveInWater() {
        return this.allowGraveInWater;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setAllowGraveInWater(boolean flag) {
        this.allowGraveInWater = flag;
    }

    public ConfigTombstone.Client.GraveSpawnRule getGraveSpawnRule() {
        return this.graveSpawnRule;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setGraveSpawnRule(ConfigTombstone.Client.GraveSpawnRule graveSpawnRule) {
        this.graveSpawnRule = graveSpawnRule;
    }

    public ConfigTombstone.Client.AutoEquipRule getAutoEquipRule() {
        return this.autoEquipRule;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setAutoEquipRule(ConfigTombstone.Client.AutoEquipRule autoEquipRule) {
        this.autoEquipRule = autoEquipRule;
    }

    public static void set(ServerPlayer player, PlayerPreference playerPreference) {
        if (playerPreference.graveModel == null) {
            playerPreference.graveModel = GraveModel.getDefault();
        }
        if (playerPreference.marbleType == null) {
            playerPreference.marbleType = BlockGraveMarble.MarbleType.getDefault();
        }
        if (playerPreference.graveSpawnRule == null) {
            playerPreference.graveSpawnRule = ConfigTombstone.Client.GraveSpawnRule.getDefault();
        }
        if (playerPreference.autoEquipRule == null) {
            playerPreference.autoEquipRule = ConfigTombstone.Client.AutoEquipRule.getDefault();
        }
        PLAYER_PREFERENCES.put(player.m_36316_().getId(), playerPreference);
    }

    public static PlayerPreference get(ServerPlayer player) {
        return PLAYER_PREFERENCES.getOrDefault(player.m_36316_().getId(), DEFAULT_PREFERENCE);
    }

    public static void clear() {
        PLAYER_PREFERENCES.clear();
    }

    public static void toBytes(PlayerPreference playerPreference, FriendlyByteBuf buf) {
        buf.writeByte(playerPreference.graveModel.ordinal());
        buf.writeByte(playerPreference.marbleType.ordinal());
        buf.writeByte(playerPreference.graveSpawnRule.ordinal());
        buf.writeByte(playerPreference.autoEquipRule.ordinal());
        buf.writeBoolean(playerPreference.equipElytraInPriority);
        buf.writeBoolean(playerPreference.equipCurioSlotMagicBook);
        buf.writeBoolean(playerPreference.knowledgeMessage);
        buf.writeBoolean(playerPreference.priorizeToolOnHotbar);
        buf.writeBoolean(playerPreference.activateGraveBySneaking);
        buf.writeBoolean(playerPreference.allowGraveInWater);
    }

    public static PlayerPreference fromBytes(FriendlyByteBuf buf) {
        return new PlayerPreference(GraveModel.byId(buf.readByte()), BlockGraveMarble.MarbleType.byId(buf.readByte()), ConfigTombstone.Client.GraveSpawnRule.byId(buf.readByte()), ConfigTombstone.Client.AutoEquipRule.byId(buf.readByte()), buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static PlayerPreference fromClientConfig() {
        return new PlayerPreference((GraveModel)((Object)ConfigTombstone.client.favoriteGrave.get()), (BlockGraveMarble.MarbleType)((Object)ConfigTombstone.client.favoriteGraveMarble.get()), (ConfigTombstone.Client.GraveSpawnRule)((Object)ConfigTombstone.client.graveSpawnRule.get()), (ConfigTombstone.Client.AutoEquipRule)((Object)ConfigTombstone.client.autoEquipRule.get()), (Boolean)ConfigTombstone.client.equipElytraInPriority.get(), (Boolean)ConfigTombstone.client.equipCurioSlotMagicBook.get(), (Boolean)ConfigTombstone.client.displayKnowledgeMessage.get(), (Boolean)ConfigTombstone.client.priorizeToolOnHotbar.get(), (Boolean)ConfigTombstone.client.activateGraveBySneaking.get(), (Boolean)ConfigTombstone.client.allowGraveInWater.get());
    }

    public boolean hasChangedFromConfig() {
        return !this.hasSameFavoriteGrave((GraveModel)((Object)ConfigTombstone.client.favoriteGrave.get()), (BlockGraveMarble.MarbleType)((Object)ConfigTombstone.client.favoriteGraveMarble.get())) || this.graveSpawnRule != ConfigTombstone.client.graveSpawnRule.get() || this.autoEquipRule != ConfigTombstone.client.autoEquipRule.get() || this.equipElytraInPriority != (Boolean)ConfigTombstone.client.equipElytraInPriority.get() || this.equipCurioSlotMagicBook != (Boolean)ConfigTombstone.client.equipCurioSlotMagicBook.get() || this.knowledgeMessage != (Boolean)ConfigTombstone.client.displayKnowledgeMessage.get() || this.priorizeToolOnHotbar != (Boolean)ConfigTombstone.client.priorizeToolOnHotbar.get() || this.activateGraveBySneaking != (Boolean)ConfigTombstone.client.activateGraveBySneaking.get() || this.allowGraveInWater != (Boolean)ConfigTombstone.client.allowGraveInWater.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateClientConfig() {
        ConfigTombstone.client.favoriteGrave.set((Object)this.graveModel);
        ConfigTombstone.client.favoriteGraveMarble.set((Object)this.marbleType);
        ConfigTombstone.client.graveSpawnRule.set((Object)this.graveSpawnRule);
        ConfigTombstone.client.autoEquipRule.set((Object)this.autoEquipRule);
        ConfigTombstone.client.displayKnowledgeMessage.set((Object)this.knowledgeMessage);
        ConfigTombstone.client.equipElytraInPriority.set((Object)this.equipElytraInPriority);
        ConfigTombstone.client.equipCurioSlotMagicBook.set((Object)this.equipCurioSlotMagicBook);
        ConfigTombstone.client.priorizeToolOnHotbar.set((Object)this.priorizeToolOnHotbar);
        ConfigTombstone.client.activateGraveBySneaking.set((Object)this.activateGraveBySneaking);
        ConfigTombstone.client.allowGraveInWater.set((Object)this.allowGraveInWater);
    }
}

