/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.CastingType;
import ovh.corail.tombstone.item.ItemTablet;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemTabletOfRecall
extends ItemTablet {
    private static final String TOMB_POS_NBT_LOCATION = "tomb_pos";

    public ItemTabletOfRecall() {
        super("tablet_of_recall", () -> SharedConfigTombstone.allowed_magic_items.allowTabletOfRecall.get());
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, Level level, List<Component> tooltip) {
        this.addItemDesc(tooltip);
        boolean isAncient = this.isAncient(stack);
        if (isAncient) {
            this.addItemDesc(tooltip, "_ancient", new Object[0]);
        }
        if (!this.isEnchanted(stack)) {
            this.addItemUse(tooltip, "1", new Object[0]);
        } else {
            this.addItemPosition(tooltip, this.getTombPos(stack));
            this.addItemUse(tooltip, "2", new Object[0]);
            this.addItemUse(tooltip, "3", new Object[0]);
        }
        super.addTooltipInfo(stack, level, tooltip);
    }

    private boolean setTombPos(ItemStack stack, Location location) {
        if (stack.m_150930_((Item)this) && !location.isOrigin()) {
            NBTStackHelper.setLocation(stack, TOMB_POS_NBT_LOCATION, location);
            return true;
        }
        return false;
    }

    public Location getTombPos(ItemStack stack) {
        return stack.m_150930_((Item)this) ? NBTStackHelper.getLocation(stack, TOMB_POS_NBT_LOCATION) : Location.ORIGIN;
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return !this.getTombPos(stack).isOrigin();
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        boolean valid = this.setTombPos(stack, new Location(gravePos, level));
        if (valid) {
            this.setUseCount(stack, this.getUseMax());
            if (!this.isAncient(stack) && soulStrength > 1) {
                NBTStackHelper.setBoolean(stack, "ancient", true);
                return ISoulConsumer.ConsumeResult.success((Component)LangKey.MESSAGE_ITEM_BOUND_TO_PLACE.getText(new Object[0]), 2);
            }
            return ISoulConsumer.ConsumeResult.success((Component)LangKey.MESSAGE_ITEM_BOUND_TO_PLACE.getText(new Object[0]), 1);
        }
        return ISoulConsumer.ConsumeResult.fail();
    }

    @Override
    public void onSneakGrave(Level level, BlockPos gravePos, Player player, ItemStack stack) {
        if (!level.m_5776_() && this.isEnchanted(stack) && EntityHelper.noGlobalItemCooldown(player, this)) {
            this.setTombPos(stack, new Location(gravePos, level));
            EntityHelper.setGlobalItemCooldown(player, this, 100);
            LangKey.sendSystemMessage(player, (Component)LangKey.MESSAGE_ITEM_BOUND_TO_PLACE.getText(new Object[0]), StyleType.MESSAGE_NORMAL);
        }
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (!player.m_6144_()) {
            return super.m_7203_(level, player, hand);
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
    }

    @Override
    protected boolean doEffects(ServerLevel world, ServerPlayer player, ItemStack stack, @Nullable LivingEntity target) {
        MinecraftServer server;
        ServerLevel targetWorld;
        Location location = this.getTombPos(stack);
        if (location.isOrigin()) {
            LangKey.MESSAGE_INVALID_LOCATION.sendMessage((Player)player, new Object[0]);
            return false;
        }
        boolean isSameDim = location.isSameDimension((Level)world);
        if (isSameDim) {
            if (location.isInRange(player.m_20183_(), 10)) {
                LangKey.MESSAGE_TELEPORT_TOO_CLOSE_FROM_GRAVE.sendMessage((Player)player, new Object[0]);
                return false;
            }
        } else if (!((Boolean)ConfigTombstone.general.teleportDim.get()).booleanValue()) {
            LangKey.MESSAGE_TELEPORT_SAME_DIMENSION.sendMessage((Player)player, new Object[0]);
            return false;
        }
        if (!Helper.isValidPos((Level)(targetWorld = (server = Objects.requireNonNull(player.m_20194_())).m_129880_(location.dim)), location.getPos())) {
            LangKey.MESSAGE_INVALID_LOCATION.sendMessage((Player)player, new Object[0]);
            return false;
        }
        targetWorld.m_7726_().m_8387_(TicketType.f_9448_, new ChunkPos(location.getPos()), 1, (Object)player.m_19879_());
        CallbackHandler.addFastCallback(() -> {
            boolean isAncient = this.isAncient(stack);
            ServerPlayer newPlayer = Helper.teleportToGrave(player, location, targetWorld);
            if (isAncient) {
                Location home = new Location((Entity)newPlayer);
                world.m_6249_((Entity)player, player.m_20191_().m_82377_(3.0, 0.0, 3.0), e -> e.m_6084_() && e.m_6072_() && !e.m_5833_()).forEach(entity -> Helper.teleport(entity, home, targetWorld));
            }
            LangKey.MESSAGE_TELEPORT_SUCCESS.sendMessage((Player)newPlayer, new Object[0]);
            ModTriggers.USE_RECALL.trigger(player);
        });
        return true;
    }

    @Override
    protected CastingType getCastingType(ItemStack stack) {
        return this.isAncient(stack) ? CastingType.AREA_TELEPORT : CastingType.SIMPLE_TELEPORT;
    }
}

