/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.mixin;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ovh.corail.tombstone.capability.FamiliarProvider;
import ovh.corail.tombstone.capability.IFamiliar;
import ovh.corail.tombstone.capability.SpellCasterProvider;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.registry.ModEffects;

@Mixin(value={Mob.class})
public class MobMixin {
    @Inject(method={"isSunBurnTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void methodIsSunBurnTick(CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        if (EntityHelper.isServant((Entity)((Mob)this))) {
            callbackInfoReturnable.setReturnValue((Object)false);
        }
    }

    @Inject(method={"checkDespawn"}, at={@At(value="HEAD")}, cancellable=true)
    private void methodCheckDespawn(CallbackInfo callbackInfo) {
        if (EntityHelper.isServant((Entity)((Mob)this))) {
            callbackInfo.cancel();
        }
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void methodTick(CallbackInfo callbackInfo) {
        Mob mob = (Mob)this;
        mob.getCapability(SpellCasterProvider.SPELLCASTER_CAPABILITY).ifPresent(cap -> cap.tick(mob));
    }

    @Inject(method={"canBeLeashed"}, at={@At(value="HEAD")}, cancellable=true)
    private void methodCanBeLeashed(Player player, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        Mob mob = (Mob)this;
        if (!mob.m_21523_() && EntityHelper.getServantOwnerId((Entity)mob).map(ownerId -> ownerId.equals(player.m_36316_().getId())).orElse(false).booleanValue()) {
            callbackInfoReturnable.setReturnValue((Object)true);
        }
    }

    @Inject(method={"setTarget"}, at={@At(value="HEAD")}, cancellable=true)
    private void methodSetTarget(@Nullable LivingEntity target, CallbackInfo callbackInfo) {
        if (target != null) {
            Mob attacker = (Mob)this;
            if (EffectHelper.isPotionActive(target, ModEffects.ghostly_shape) || EffectHelper.isPotionActive(target, ModEffects.diversion)) {
                NeutralMob neutralMob;
                if (target.equals((Object)attacker.m_21188_())) {
                    attacker.m_6703_(null);
                } else if (target.equals((Object)attacker.f_20888_)) {
                    attacker.m_6598_(null);
                }
                if (attacker instanceof NeutralMob && Optional.ofNullable((neutralMob = (NeutralMob)attacker).m_6120_()).map(uuid -> uuid.equals(target.m_20148_())).orElse(false).booleanValue()) {
                    neutralMob.m_6925_(null);
                    neutralMob.m_7870_(0);
                }
                if (attacker.m_6274_().m_21874_(MemoryModuleType.f_26372_)) {
                    attacker.m_6274_().m_21886_(MemoryModuleType.f_26372_, Optional.empty());
                }
                callbackInfo.cancel();
            }
        }
    }

    @Inject(method={"isWithinMeleeAttackRange"}, at={@At(value="HEAD")}, cancellable=true)
    private void methodIsWithinMeleeAttackRange(LivingEntity target, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        Mob mob = (Mob)this;
        if (mob.getCapability(FamiliarProvider.FAMILIAR_CAPABILITY).map(IFamiliar::isActive).orElse(false).booleanValue()) {
            double distance = mob.m_262793_(target);
            callbackInfoReturnable.setReturnValue((Object)(distance * (double)0.8f <= mob.m_142593_(target) ? 1 : 0));
        }
    }
}

