/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.enchantment;

import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import org.apache.commons.lang3.tuple.Triple;
import ovh.corail.tombstone.enchantment.TombstoneEnchantment;
import ovh.corail.tombstone.helper.DamageCategory;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.TimeHelper;

public abstract class WeaponEnchantment
extends TombstoneEnchantment {
    private Triple<UUID, UUID, Long> lastAttackId = null;

    WeaponEnchantment(String name, Enchantment.Rarity rarity, EnchantmentCategory type, EquipmentSlot ... slots) {
        super(name, rarity, type, slots);
    }

    public void m_7677_(LivingEntity attacker, Entity entity, int initialAmplifier) {
        int amplifier;
        LivingEntity target;
        block6: {
            block5: {
                if (attacker == null || !(entity instanceof LivingEntity)) break block5;
                target = (LivingEntity)entity;
                if (!attacker.m_9236_().m_5776_()) break block6;
            }
            return;
        }
        Triple attackId = Triple.of((Object)attacker.m_20148_(), (Object)target.m_20148_(), (Object)TimeHelper.worldTicks(attacker.m_9236_()));
        if (attackId.equals(this.lastAttackId)) {
            return;
        }
        this.lastAttackId = attackId;
        if (this.canAffectTarget(target) && target.m_6084_() && this.isMainHand(attacker, target) && (amplifier = attacker.m_21205_().getEnchantmentLevel((Enchantment)this)) > 0 && this.testProc(attacker, target, amplifier)) {
            this.onProc(attacker, target, amplifier);
        }
    }

    protected boolean canAffectTarget(LivingEntity target) {
        return true;
    }

    protected boolean testProc(LivingEntity attacker, LivingEntity target, int amplifier) {
        return attacker.m_217043_().m_188503_(Math.max(10, this.m_6586_())) < amplifier;
    }

    private boolean isMainHand(LivingEntity attacker, LivingEntity target) {
        return EntityHelper.isValidPlayer((Entity)attacker) ? EntityHelper.getPersistentTag((Player)attacker).m_128471_("attack_mainhand") : target.m_21225_() != null && !DamageCategory.isProjectile(target.m_21225_()) && target.f_20930_ == TimeHelper.worldTicks(target.m_9236_());
    }

    protected abstract void onProc(LivingEntity var1, LivingEntity var2, int var3);
}

